/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.InlineRedactionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProtectionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProtectionSettings> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(DataProtectionSettings.getter(DataProtectionSettings::additionalEncryptionContext)).setter(DataProtectionSettings.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(DataProtectionSettings.getter(DataProtectionSettings::associatedPortalArns)).setter(DataProtectionSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DataProtectionSettings.getter(DataProtectionSettings::creationDate)).setter(DataProtectionSettings.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(DataProtectionSettings.getter(DataProtectionSettings::customerManagedKey)).setter(DataProtectionSettings.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final SdkField<String> DATA_PROTECTION_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProtectionSettingsArn").getter(DataProtectionSettings.getter(DataProtectionSettings::dataProtectionSettingsArn)).setter(DataProtectionSettings.setter(Builder::dataProtectionSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProtectionSettingsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DataProtectionSettings.getter(DataProtectionSettings::description)).setter(DataProtectionSettings.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(DataProtectionSettings.getter(DataProtectionSettings::displayName)).setter(DataProtectionSettings.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<InlineRedactionConfiguration> INLINE_REDACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inlineRedactionConfiguration").getter(DataProtectionSettings.getter(DataProtectionSettings::inlineRedactionConfiguration)).setter(DataProtectionSettings.setter(Builder::inlineRedactionConfiguration)).constructor(InlineRedactionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRedactionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, CREATION_DATE_FIELD, CUSTOMER_MANAGED_KEY_FIELD, DATA_PROTECTION_SETTINGS_ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, INLINE_REDACTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProtectionSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> additionalEncryptionContext;
    private final List<String> associatedPortalArns;
    private final Instant creationDate;
    private final String customerManagedKey;
    private final String dataProtectionSettingsArn;
    private final String description;
    private final String displayName;
    private final InlineRedactionConfiguration inlineRedactionConfiguration;

    private DataProtectionSettings(BuilderImpl builder) {
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.creationDate = builder.creationDate;
        this.customerManagedKey = builder.customerManagedKey;
        this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.inlineRedactionConfiguration = builder.inlineRedactionConfiguration;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public final String dataProtectionSettingsArn() {
        return this.dataProtectionSettingsArn;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final InlineRedactionConfiguration inlineRedactionConfiguration() {
        return this.inlineRedactionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProtectionSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineRedactionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtectionSettings)) {
            return false;
        }
        DataProtectionSettings other = (DataProtectionSettings)obj;
        return this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey()) && Objects.equals(this.dataProtectionSettingsArn(), other.dataProtectionSettingsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.inlineRedactionConfiguration(), other.inlineRedactionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataProtectionSettings").add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("CreationDate", (Object)this.creationDate()).add("CustomerManagedKey", (Object)this.customerManagedKey()).add("DataProtectionSettingsArn", (Object)this.dataProtectionSettingsArn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("InlineRedactionConfiguration", (Object)this.inlineRedactionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
            case "dataProtectionSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.dataProtectionSettingsArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "inlineRedactionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inlineRedactionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("dataProtectionSettingsArn", DATA_PROTECTION_SETTINGS_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("inlineRedactionConfiguration", INLINE_REDACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProtectionSettings, T> g) {
        return obj -> g.apply((DataProtectionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private String customerManagedKey;
        private String dataProtectionSettingsArn;
        private String description;
        private String displayName;
        private InlineRedactionConfiguration inlineRedactionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtectionSettings model) {
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.associatedPortalArns(model.associatedPortalArns);
            this.creationDate(model.creationDate);
            this.customerManagedKey(model.customerManagedKey);
            this.dataProtectionSettingsArn(model.dataProtectionSettingsArn);
            this.description(model.description);
            this.displayName(model.displayName);
            this.inlineRedactionConfiguration(model.inlineRedactionConfiguration);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final String getDataProtectionSettingsArn() {
            return this.dataProtectionSettingsArn;
        }

        public final void setDataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
        }

        @Override
        public final Builder dataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final InlineRedactionConfiguration.Builder getInlineRedactionConfiguration() {
            return this.inlineRedactionConfiguration != null ? this.inlineRedactionConfiguration.toBuilder() : null;
        }

        public final void setInlineRedactionConfiguration(InlineRedactionConfiguration.BuilderImpl inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration != null ? inlineRedactionConfiguration.build() : null;
        }

        @Override
        public final Builder inlineRedactionConfiguration(InlineRedactionConfiguration inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration;
            return this;
        }

        public DataProtectionSettings build() {
            return new DataProtectionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProtectionSettings> {
        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder creationDate(Instant var1);

        public Builder customerManagedKey(String var1);

        public Builder dataProtectionSettingsArn(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder inlineRedactionConfiguration(InlineRedactionConfiguration var1);

        default public Builder inlineRedactionConfiguration(Consumer<InlineRedactionConfiguration.Builder> inlineRedactionConfiguration) {
            return this.inlineRedactionConfiguration((InlineRedactionConfiguration)((InlineRedactionConfiguration.Builder)InlineRedactionConfiguration.builder().applyMutation(inlineRedactionConfiguration)).build());
        }
    }
}

