/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.GlobalInlineRedactionUrlsCopier;
import software.amazon.awssdk.services.workspacesweb.model.InlineRedactionPattern;
import software.amazon.awssdk.services.workspacesweb.model.InlineRedactionPatternsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineRedactionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineRedactionConfiguration> {
    private static final SdkField<Integer> GLOBAL_CONFIDENCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("globalConfidenceLevel").getter(InlineRedactionConfiguration.getter(InlineRedactionConfiguration::globalConfidenceLevel)).setter(InlineRedactionConfiguration.setter(Builder::globalConfidenceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalConfidenceLevel").build()}).build();
    private static final SdkField<List<String>> GLOBAL_ENFORCED_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("globalEnforcedUrls").getter(InlineRedactionConfiguration.getter(InlineRedactionConfiguration::globalEnforcedUrls)).setter(InlineRedactionConfiguration.setter(Builder::globalEnforcedUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalEnforcedUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GLOBAL_EXEMPT_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("globalExemptUrls").getter(InlineRedactionConfiguration.getter(InlineRedactionConfiguration::globalExemptUrls)).setter(InlineRedactionConfiguration.setter(Builder::globalExemptUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalExemptUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InlineRedactionPattern>> INLINE_REDACTION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inlineRedactionPatterns").getter(InlineRedactionConfiguration.getter(InlineRedactionConfiguration::inlineRedactionPatterns)).setter(InlineRedactionConfiguration.setter(Builder::inlineRedactionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRedactionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InlineRedactionPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CONFIDENCE_LEVEL_FIELD, GLOBAL_ENFORCED_URLS_FIELD, GLOBAL_EXEMPT_URLS_FIELD, INLINE_REDACTION_PATTERNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineRedactionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer globalConfidenceLevel;
    private final List<String> globalEnforcedUrls;
    private final List<String> globalExemptUrls;
    private final List<InlineRedactionPattern> inlineRedactionPatterns;

    private InlineRedactionConfiguration(BuilderImpl builder) {
        this.globalConfidenceLevel = builder.globalConfidenceLevel;
        this.globalEnforcedUrls = builder.globalEnforcedUrls;
        this.globalExemptUrls = builder.globalExemptUrls;
        this.inlineRedactionPatterns = builder.inlineRedactionPatterns;
    }

    public final Integer globalConfidenceLevel() {
        return this.globalConfidenceLevel;
    }

    public final boolean hasGlobalEnforcedUrls() {
        return this.globalEnforcedUrls != null && !(this.globalEnforcedUrls instanceof SdkAutoConstructList);
    }

    public final List<String> globalEnforcedUrls() {
        return this.globalEnforcedUrls;
    }

    public final boolean hasGlobalExemptUrls() {
        return this.globalExemptUrls != null && !(this.globalExemptUrls instanceof SdkAutoConstructList);
    }

    public final List<String> globalExemptUrls() {
        return this.globalExemptUrls;
    }

    public final boolean hasInlineRedactionPatterns() {
        return this.inlineRedactionPatterns != null && !(this.inlineRedactionPatterns instanceof SdkAutoConstructList);
    }

    public final List<InlineRedactionPattern> inlineRedactionPatterns() {
        return this.inlineRedactionPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalConfidenceLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalEnforcedUrls() ? this.globalEnforcedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalExemptUrls() ? this.globalExemptUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInlineRedactionPatterns() ? this.inlineRedactionPatterns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineRedactionConfiguration)) {
            return false;
        }
        InlineRedactionConfiguration other = (InlineRedactionConfiguration)obj;
        return Objects.equals(this.globalConfidenceLevel(), other.globalConfidenceLevel()) && this.hasGlobalEnforcedUrls() == other.hasGlobalEnforcedUrls() && Objects.equals(this.globalEnforcedUrls(), other.globalEnforcedUrls()) && this.hasGlobalExemptUrls() == other.hasGlobalExemptUrls() && Objects.equals(this.globalExemptUrls(), other.globalExemptUrls()) && this.hasInlineRedactionPatterns() == other.hasInlineRedactionPatterns() && Objects.equals(this.inlineRedactionPatterns(), other.inlineRedactionPatterns());
    }

    public final String toString() {
        return ToString.builder((String)"InlineRedactionConfiguration").add("GlobalConfidenceLevel", (Object)this.globalConfidenceLevel()).add("GlobalEnforcedUrls", (Object)(this.globalEnforcedUrls() == null ? null : "*** Sensitive Data Redacted ***")).add("GlobalExemptUrls", (Object)(this.globalExemptUrls() == null ? null : "*** Sensitive Data Redacted ***")).add("InlineRedactionPatterns", this.hasInlineRedactionPatterns() ? this.inlineRedactionPatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "globalConfidenceLevel": {
                return Optional.ofNullable(clazz.cast(this.globalConfidenceLevel()));
            }
            case "globalEnforcedUrls": {
                return Optional.ofNullable(clazz.cast(this.globalEnforcedUrls()));
            }
            case "globalExemptUrls": {
                return Optional.ofNullable(clazz.cast(this.globalExemptUrls()));
            }
            case "inlineRedactionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inlineRedactionPatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("globalConfidenceLevel", GLOBAL_CONFIDENCE_LEVEL_FIELD);
        map.put("globalEnforcedUrls", GLOBAL_ENFORCED_URLS_FIELD);
        map.put("globalExemptUrls", GLOBAL_EXEMPT_URLS_FIELD);
        map.put("inlineRedactionPatterns", INLINE_REDACTION_PATTERNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineRedactionConfiguration, T> g) {
        return obj -> g.apply((InlineRedactionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer globalConfidenceLevel;
        private List<String> globalEnforcedUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> globalExemptUrls = DefaultSdkAutoConstructList.getInstance();
        private List<InlineRedactionPattern> inlineRedactionPatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InlineRedactionConfiguration model) {
            this.globalConfidenceLevel(model.globalConfidenceLevel);
            this.globalEnforcedUrls(model.globalEnforcedUrls);
            this.globalExemptUrls(model.globalExemptUrls);
            this.inlineRedactionPatterns(model.inlineRedactionPatterns);
        }

        public final Integer getGlobalConfidenceLevel() {
            return this.globalConfidenceLevel;
        }

        public final void setGlobalConfidenceLevel(Integer globalConfidenceLevel) {
            this.globalConfidenceLevel = globalConfidenceLevel;
        }

        @Override
        public final Builder globalConfidenceLevel(Integer globalConfidenceLevel) {
            this.globalConfidenceLevel = globalConfidenceLevel;
            return this;
        }

        public final Collection<String> getGlobalEnforcedUrls() {
            if (this.globalEnforcedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.globalEnforcedUrls;
        }

        public final void setGlobalEnforcedUrls(Collection<String> globalEnforcedUrls) {
            this.globalEnforcedUrls = GlobalInlineRedactionUrlsCopier.copy(globalEnforcedUrls);
        }

        @Override
        public final Builder globalEnforcedUrls(Collection<String> globalEnforcedUrls) {
            this.globalEnforcedUrls = GlobalInlineRedactionUrlsCopier.copy(globalEnforcedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalEnforcedUrls(String ... globalEnforcedUrls) {
            this.globalEnforcedUrls(Arrays.asList(globalEnforcedUrls));
            return this;
        }

        public final Collection<String> getGlobalExemptUrls() {
            if (this.globalExemptUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.globalExemptUrls;
        }

        public final void setGlobalExemptUrls(Collection<String> globalExemptUrls) {
            this.globalExemptUrls = GlobalInlineRedactionUrlsCopier.copy(globalExemptUrls);
        }

        @Override
        public final Builder globalExemptUrls(Collection<String> globalExemptUrls) {
            this.globalExemptUrls = GlobalInlineRedactionUrlsCopier.copy(globalExemptUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalExemptUrls(String ... globalExemptUrls) {
            this.globalExemptUrls(Arrays.asList(globalExemptUrls));
            return this;
        }

        public final List<InlineRedactionPattern.Builder> getInlineRedactionPatterns() {
            List<InlineRedactionPattern.Builder> result = InlineRedactionPatternsCopier.copyToBuilder(this.inlineRedactionPatterns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineRedactionPatterns(Collection<InlineRedactionPattern.BuilderImpl> inlineRedactionPatterns) {
            this.inlineRedactionPatterns = InlineRedactionPatternsCopier.copyFromBuilder(inlineRedactionPatterns);
        }

        @Override
        public final Builder inlineRedactionPatterns(Collection<InlineRedactionPattern> inlineRedactionPatterns) {
            this.inlineRedactionPatterns = InlineRedactionPatternsCopier.copy(inlineRedactionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineRedactionPatterns(InlineRedactionPattern ... inlineRedactionPatterns) {
            this.inlineRedactionPatterns(Arrays.asList(inlineRedactionPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineRedactionPatterns(Consumer<InlineRedactionPattern.Builder> ... inlineRedactionPatterns) {
            this.inlineRedactionPatterns(Stream.of(inlineRedactionPatterns).map(c -> (InlineRedactionPattern)((InlineRedactionPattern.Builder)InlineRedactionPattern.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InlineRedactionConfiguration build() {
            return new InlineRedactionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineRedactionConfiguration> {
        public Builder globalConfidenceLevel(Integer var1);

        public Builder globalEnforcedUrls(Collection<String> var1);

        public Builder globalEnforcedUrls(String ... var1);

        public Builder globalExemptUrls(Collection<String> var1);

        public Builder globalExemptUrls(String ... var1);

        public Builder inlineRedactionPatterns(Collection<InlineRedactionPattern> var1);

        public Builder inlineRedactionPatterns(InlineRedactionPattern ... var1);

        public Builder inlineRedactionPatterns(Consumer<InlineRedactionPattern.Builder> ... var1);
    }
}

