/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;

public class ListBrowserSettingsPublisher
implements SdkPublisher<ListBrowserSettingsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListBrowserSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBrowserSettingsPublisher(WorkSpacesWebAsyncClient client, ListBrowserSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBrowserSettingsPublisher(WorkSpacesWebAsyncClient client, ListBrowserSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBrowserSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBrowserSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBrowserSettingsResponseFetcher
    implements AsyncPageFetcher<ListBrowserSettingsResponse> {
        private ListBrowserSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListBrowserSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBrowserSettingsResponse> nextPage(ListBrowserSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListBrowserSettingsPublisher.this.client.listBrowserSettings(ListBrowserSettingsPublisher.this.firstRequest);
            }
            return ListBrowserSettingsPublisher.this.client.listBrowserSettings((ListBrowserSettingsRequest)((Object)ListBrowserSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

