/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.HiddenToolbarItemListCopier;
import software.amazon.awssdk.services.workspacesweb.model.MaxDisplayResolution;
import software.amazon.awssdk.services.workspacesweb.model.ToolbarItem;
import software.amazon.awssdk.services.workspacesweb.model.ToolbarType;
import software.amazon.awssdk.services.workspacesweb.model.VisualMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolbarConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolbarConfiguration> {
    private static final SdkField<List<String>> HIDDEN_TOOLBAR_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hiddenToolbarItems").getter(ToolbarConfiguration.getter(ToolbarConfiguration::hiddenToolbarItemsAsStrings)).setter(ToolbarConfiguration.setter(Builder::hiddenToolbarItemsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hiddenToolbarItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MAX_DISPLAY_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("maxDisplayResolution").getter(ToolbarConfiguration.getter(ToolbarConfiguration::maxDisplayResolutionAsString)).setter(ToolbarConfiguration.setter(Builder::maxDisplayResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDisplayResolution").build()}).build();
    private static final SdkField<String> TOOLBAR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolbarType").getter(ToolbarConfiguration.getter(ToolbarConfiguration::toolbarTypeAsString)).setter(ToolbarConfiguration.setter(Builder::toolbarType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolbarType").build()}).build();
    private static final SdkField<String> VISUAL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visualMode").getter(ToolbarConfiguration.getter(ToolbarConfiguration::visualModeAsString)).setter(ToolbarConfiguration.setter(Builder::visualMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visualMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIDDEN_TOOLBAR_ITEMS_FIELD, MAX_DISPLAY_RESOLUTION_FIELD, TOOLBAR_TYPE_FIELD, VISUAL_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolbarConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> hiddenToolbarItems;
    private final String maxDisplayResolution;
    private final String toolbarType;
    private final String visualMode;

    private ToolbarConfiguration(BuilderImpl builder) {
        this.hiddenToolbarItems = builder.hiddenToolbarItems;
        this.maxDisplayResolution = builder.maxDisplayResolution;
        this.toolbarType = builder.toolbarType;
        this.visualMode = builder.visualMode;
    }

    public final List<ToolbarItem> hiddenToolbarItems() {
        return HiddenToolbarItemListCopier.copyStringToEnum(this.hiddenToolbarItems);
    }

    public final boolean hasHiddenToolbarItems() {
        return this.hiddenToolbarItems != null && !(this.hiddenToolbarItems instanceof SdkAutoConstructList);
    }

    public final List<String> hiddenToolbarItemsAsStrings() {
        return this.hiddenToolbarItems;
    }

    public final MaxDisplayResolution maxDisplayResolution() {
        return MaxDisplayResolution.fromValue(this.maxDisplayResolution);
    }

    public final String maxDisplayResolutionAsString() {
        return this.maxDisplayResolution;
    }

    public final ToolbarType toolbarType() {
        return ToolbarType.fromValue(this.toolbarType);
    }

    public final String toolbarTypeAsString() {
        return this.toolbarType;
    }

    public final VisualMode visualMode() {
        return VisualMode.fromValue(this.visualMode);
    }

    public final String visualModeAsString() {
        return this.visualMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenToolbarItems() ? this.hiddenToolbarItemsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDisplayResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolbarTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolbarConfiguration)) {
            return false;
        }
        ToolbarConfiguration other = (ToolbarConfiguration)obj;
        return this.hasHiddenToolbarItems() == other.hasHiddenToolbarItems() && Objects.equals(this.hiddenToolbarItemsAsStrings(), other.hiddenToolbarItemsAsStrings()) && Objects.equals(this.maxDisplayResolutionAsString(), other.maxDisplayResolutionAsString()) && Objects.equals(this.toolbarTypeAsString(), other.toolbarTypeAsString()) && Objects.equals(this.visualModeAsString(), other.visualModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ToolbarConfiguration").add("HiddenToolbarItems", this.hasHiddenToolbarItems() ? this.hiddenToolbarItemsAsStrings() : null).add("MaxDisplayResolution", (Object)this.maxDisplayResolutionAsString()).add("ToolbarType", (Object)this.toolbarTypeAsString()).add("VisualMode", (Object)this.visualModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hiddenToolbarItems": {
                return Optional.ofNullable(clazz.cast(this.hiddenToolbarItemsAsStrings()));
            }
            case "maxDisplayResolution": {
                return Optional.ofNullable(clazz.cast(this.maxDisplayResolutionAsString()));
            }
            case "toolbarType": {
                return Optional.ofNullable(clazz.cast(this.toolbarTypeAsString()));
            }
            case "visualMode": {
                return Optional.ofNullable(clazz.cast(this.visualModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hiddenToolbarItems", HIDDEN_TOOLBAR_ITEMS_FIELD);
        map.put("maxDisplayResolution", MAX_DISPLAY_RESOLUTION_FIELD);
        map.put("toolbarType", TOOLBAR_TYPE_FIELD);
        map.put("visualMode", VISUAL_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolbarConfiguration, T> g) {
        return obj -> g.apply((ToolbarConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> hiddenToolbarItems = DefaultSdkAutoConstructList.getInstance();
        private String maxDisplayResolution;
        private String toolbarType;
        private String visualMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolbarConfiguration model) {
            this.hiddenToolbarItemsWithStrings(model.hiddenToolbarItems);
            this.maxDisplayResolution(model.maxDisplayResolution);
            this.toolbarType(model.toolbarType);
            this.visualMode(model.visualMode);
        }

        public final Collection<String> getHiddenToolbarItems() {
            if (this.hiddenToolbarItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenToolbarItems;
        }

        public final void setHiddenToolbarItems(Collection<String> hiddenToolbarItems) {
            this.hiddenToolbarItems = HiddenToolbarItemListCopier.copy(hiddenToolbarItems);
        }

        @Override
        public final Builder hiddenToolbarItemsWithStrings(Collection<String> hiddenToolbarItems) {
            this.hiddenToolbarItems = HiddenToolbarItemListCopier.copy(hiddenToolbarItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenToolbarItemsWithStrings(String ... hiddenToolbarItems) {
            this.hiddenToolbarItemsWithStrings(Arrays.asList(hiddenToolbarItems));
            return this;
        }

        @Override
        public final Builder hiddenToolbarItems(Collection<ToolbarItem> hiddenToolbarItems) {
            this.hiddenToolbarItems = HiddenToolbarItemListCopier.copyEnumToString(hiddenToolbarItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenToolbarItems(ToolbarItem ... hiddenToolbarItems) {
            this.hiddenToolbarItems(Arrays.asList(hiddenToolbarItems));
            return this;
        }

        public final String getMaxDisplayResolution() {
            return this.maxDisplayResolution;
        }

        public final void setMaxDisplayResolution(String maxDisplayResolution) {
            this.maxDisplayResolution = maxDisplayResolution;
        }

        @Override
        public final Builder maxDisplayResolution(String maxDisplayResolution) {
            this.maxDisplayResolution = maxDisplayResolution;
            return this;
        }

        @Override
        public final Builder maxDisplayResolution(MaxDisplayResolution maxDisplayResolution) {
            this.maxDisplayResolution(maxDisplayResolution == null ? null : maxDisplayResolution.toString());
            return this;
        }

        public final String getToolbarType() {
            return this.toolbarType;
        }

        public final void setToolbarType(String toolbarType) {
            this.toolbarType = toolbarType;
        }

        @Override
        public final Builder toolbarType(String toolbarType) {
            this.toolbarType = toolbarType;
            return this;
        }

        @Override
        public final Builder toolbarType(ToolbarType toolbarType) {
            this.toolbarType(toolbarType == null ? null : toolbarType.toString());
            return this;
        }

        public final String getVisualMode() {
            return this.visualMode;
        }

        public final void setVisualMode(String visualMode) {
            this.visualMode = visualMode;
        }

        @Override
        public final Builder visualMode(String visualMode) {
            this.visualMode = visualMode;
            return this;
        }

        @Override
        public final Builder visualMode(VisualMode visualMode) {
            this.visualMode(visualMode == null ? null : visualMode.toString());
            return this;
        }

        public ToolbarConfiguration build() {
            return new ToolbarConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolbarConfiguration> {
        public Builder hiddenToolbarItemsWithStrings(Collection<String> var1);

        public Builder hiddenToolbarItemsWithStrings(String ... var1);

        public Builder hiddenToolbarItems(Collection<ToolbarItem> var1);

        public Builder hiddenToolbarItems(ToolbarItem ... var1);

        public Builder maxDisplayResolution(String var1);

        public Builder maxDisplayResolution(MaxDisplayResolution var1);

        public Builder toolbarType(String var1);

        public Builder toolbarType(ToolbarType var1);

        public Builder visualMode(String var1);

        public Builder visualMode(VisualMode var1);
    }
}

