/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.DataProtectionSettingsSummary;
import software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsResponse;

public class ListDataProtectionSettingsIterable
implements SdkIterable<ListDataProtectionSettingsResponse> {
    private final WorkSpacesWebClient client;
    private final ListDataProtectionSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataProtectionSettingsIterable(WorkSpacesWebClient client, ListDataProtectionSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataProtectionSettingsResponseFetcher();
    }

    public Iterator<ListDataProtectionSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataProtectionSettingsSummary> dataProtectionSettings() {
        Function<ListDataProtectionSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataProtectionSettings() != null) {
                return response.dataProtectionSettings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataProtectionSettingsResponseFetcher
    implements SyncPageFetcher<ListDataProtectionSettingsResponse> {
        private ListDataProtectionSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataProtectionSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataProtectionSettingsResponse nextPage(ListDataProtectionSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListDataProtectionSettingsIterable.this.client.listDataProtectionSettings(ListDataProtectionSettingsIterable.this.firstRequest);
            }
            return ListDataProtectionSettingsIterable.this.client.listDataProtectionSettings((ListDataProtectionSettingsRequest)((Object)ListDataProtectionSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

