/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.CustomPattern;
import software.amazon.awssdk.services.workspacesweb.model.InlineRedactionUrlsCopier;
import software.amazon.awssdk.services.workspacesweb.model.RedactionPlaceHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineRedactionPattern
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineRedactionPattern> {
    private static final SdkField<String> BUILT_IN_PATTERN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("builtInPatternId").getter(InlineRedactionPattern.getter(InlineRedactionPattern::builtInPatternId)).setter(InlineRedactionPattern.setter(Builder::builtInPatternId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builtInPatternId").build()}).build();
    private static final SdkField<Integer> CONFIDENCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("confidenceLevel").getter(InlineRedactionPattern.getter(InlineRedactionPattern::confidenceLevel)).setter(InlineRedactionPattern.setter(Builder::confidenceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceLevel").build()}).build();
    private static final SdkField<CustomPattern> CUSTOM_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customPattern").getter(InlineRedactionPattern.getter(InlineRedactionPattern::customPattern)).setter(InlineRedactionPattern.setter(Builder::customPattern)).constructor(CustomPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPattern").build()}).build();
    private static final SdkField<List<String>> ENFORCED_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("enforcedUrls").getter(InlineRedactionPattern.getter(InlineRedactionPattern::enforcedUrls)).setter(InlineRedactionPattern.setter(Builder::enforcedUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enforcedUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXEMPT_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exemptUrls").getter(InlineRedactionPattern.getter(InlineRedactionPattern::exemptUrls)).setter(InlineRedactionPattern.setter(Builder::exemptUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exemptUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RedactionPlaceHolder> REDACTION_PLACE_HOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redactionPlaceHolder").getter(InlineRedactionPattern.getter(InlineRedactionPattern::redactionPlaceHolder)).setter(InlineRedactionPattern.setter(Builder::redactionPlaceHolder)).constructor(RedactionPlaceHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactionPlaceHolder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILT_IN_PATTERN_ID_FIELD, CONFIDENCE_LEVEL_FIELD, CUSTOM_PATTERN_FIELD, ENFORCED_URLS_FIELD, EXEMPT_URLS_FIELD, REDACTION_PLACE_HOLDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("builtInPatternId", BUILT_IN_PATTERN_ID_FIELD);
            this.put("confidenceLevel", CONFIDENCE_LEVEL_FIELD);
            this.put("customPattern", CUSTOM_PATTERN_FIELD);
            this.put("enforcedUrls", ENFORCED_URLS_FIELD);
            this.put("exemptUrls", EXEMPT_URLS_FIELD);
            this.put("redactionPlaceHolder", REDACTION_PLACE_HOLDER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String builtInPatternId;
    private final Integer confidenceLevel;
    private final CustomPattern customPattern;
    private final List<String> enforcedUrls;
    private final List<String> exemptUrls;
    private final RedactionPlaceHolder redactionPlaceHolder;

    private InlineRedactionPattern(BuilderImpl builder) {
        this.builtInPatternId = builder.builtInPatternId;
        this.confidenceLevel = builder.confidenceLevel;
        this.customPattern = builder.customPattern;
        this.enforcedUrls = builder.enforcedUrls;
        this.exemptUrls = builder.exemptUrls;
        this.redactionPlaceHolder = builder.redactionPlaceHolder;
    }

    public final String builtInPatternId() {
        return this.builtInPatternId;
    }

    public final Integer confidenceLevel() {
        return this.confidenceLevel;
    }

    public final CustomPattern customPattern() {
        return this.customPattern;
    }

    public final boolean hasEnforcedUrls() {
        return this.enforcedUrls != null && !(this.enforcedUrls instanceof SdkAutoConstructList);
    }

    public final List<String> enforcedUrls() {
        return this.enforcedUrls;
    }

    public final boolean hasExemptUrls() {
        return this.exemptUrls != null && !(this.exemptUrls instanceof SdkAutoConstructList);
    }

    public final List<String> exemptUrls() {
        return this.exemptUrls;
    }

    public final RedactionPlaceHolder redactionPlaceHolder() {
        return this.redactionPlaceHolder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.builtInPatternId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnforcedUrls() ? this.enforcedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExemptUrls() ? this.exemptUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redactionPlaceHolder());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineRedactionPattern)) {
            return false;
        }
        InlineRedactionPattern other = (InlineRedactionPattern)obj;
        return Objects.equals(this.builtInPatternId(), other.builtInPatternId()) && Objects.equals(this.confidenceLevel(), other.confidenceLevel()) && Objects.equals(this.customPattern(), other.customPattern()) && this.hasEnforcedUrls() == other.hasEnforcedUrls() && Objects.equals(this.enforcedUrls(), other.enforcedUrls()) && this.hasExemptUrls() == other.hasExemptUrls() && Objects.equals(this.exemptUrls(), other.exemptUrls()) && Objects.equals(this.redactionPlaceHolder(), other.redactionPlaceHolder());
    }

    public final String toString() {
        return ToString.builder((String)"InlineRedactionPattern").add("BuiltInPatternId", (Object)(this.builtInPatternId() == null ? null : "*** Sensitive Data Redacted ***")).add("ConfidenceLevel", (Object)this.confidenceLevel()).add("CustomPattern", (Object)this.customPattern()).add("EnforcedUrls", (Object)(this.enforcedUrls() == null ? null : "*** Sensitive Data Redacted ***")).add("ExemptUrls", (Object)(this.exemptUrls() == null ? null : "*** Sensitive Data Redacted ***")).add("RedactionPlaceHolder", (Object)this.redactionPlaceHolder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "builtInPatternId": {
                return Optional.ofNullable(clazz.cast(this.builtInPatternId()));
            }
            case "confidenceLevel": {
                return Optional.ofNullable(clazz.cast(this.confidenceLevel()));
            }
            case "customPattern": {
                return Optional.ofNullable(clazz.cast(this.customPattern()));
            }
            case "enforcedUrls": {
                return Optional.ofNullable(clazz.cast(this.enforcedUrls()));
            }
            case "exemptUrls": {
                return Optional.ofNullable(clazz.cast(this.exemptUrls()));
            }
            case "redactionPlaceHolder": {
                return Optional.ofNullable(clazz.cast(this.redactionPlaceHolder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InlineRedactionPattern, T> g) {
        return obj -> g.apply((InlineRedactionPattern)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String builtInPatternId;
        private Integer confidenceLevel;
        private CustomPattern customPattern;
        private List<String> enforcedUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> exemptUrls = DefaultSdkAutoConstructList.getInstance();
        private RedactionPlaceHolder redactionPlaceHolder;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineRedactionPattern model) {
            this.builtInPatternId(model.builtInPatternId);
            this.confidenceLevel(model.confidenceLevel);
            this.customPattern(model.customPattern);
            this.enforcedUrls(model.enforcedUrls);
            this.exemptUrls(model.exemptUrls);
            this.redactionPlaceHolder(model.redactionPlaceHolder);
        }

        public final String getBuiltInPatternId() {
            return this.builtInPatternId;
        }

        public final void setBuiltInPatternId(String builtInPatternId) {
            this.builtInPatternId = builtInPatternId;
        }

        @Override
        public final Builder builtInPatternId(String builtInPatternId) {
            this.builtInPatternId = builtInPatternId;
            return this;
        }

        public final Integer getConfidenceLevel() {
            return this.confidenceLevel;
        }

        public final void setConfidenceLevel(Integer confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
        }

        @Override
        public final Builder confidenceLevel(Integer confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
            return this;
        }

        public final CustomPattern.Builder getCustomPattern() {
            return this.customPattern != null ? this.customPattern.toBuilder() : null;
        }

        public final void setCustomPattern(CustomPattern.BuilderImpl customPattern) {
            this.customPattern = customPattern != null ? customPattern.build() : null;
        }

        @Override
        public final Builder customPattern(CustomPattern customPattern) {
            this.customPattern = customPattern;
            return this;
        }

        public final Collection<String> getEnforcedUrls() {
            if (this.enforcedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enforcedUrls;
        }

        public final void setEnforcedUrls(Collection<String> enforcedUrls) {
            this.enforcedUrls = InlineRedactionUrlsCopier.copy(enforcedUrls);
        }

        @Override
        public final Builder enforcedUrls(Collection<String> enforcedUrls) {
            this.enforcedUrls = InlineRedactionUrlsCopier.copy(enforcedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enforcedUrls(String ... enforcedUrls) {
            this.enforcedUrls(Arrays.asList(enforcedUrls));
            return this;
        }

        public final Collection<String> getExemptUrls() {
            if (this.exemptUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exemptUrls;
        }

        public final void setExemptUrls(Collection<String> exemptUrls) {
            this.exemptUrls = InlineRedactionUrlsCopier.copy(exemptUrls);
        }

        @Override
        public final Builder exemptUrls(Collection<String> exemptUrls) {
            this.exemptUrls = InlineRedactionUrlsCopier.copy(exemptUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exemptUrls(String ... exemptUrls) {
            this.exemptUrls(Arrays.asList(exemptUrls));
            return this;
        }

        public final RedactionPlaceHolder.Builder getRedactionPlaceHolder() {
            return this.redactionPlaceHolder != null ? this.redactionPlaceHolder.toBuilder() : null;
        }

        public final void setRedactionPlaceHolder(RedactionPlaceHolder.BuilderImpl redactionPlaceHolder) {
            this.redactionPlaceHolder = redactionPlaceHolder != null ? redactionPlaceHolder.build() : null;
        }

        @Override
        public final Builder redactionPlaceHolder(RedactionPlaceHolder redactionPlaceHolder) {
            this.redactionPlaceHolder = redactionPlaceHolder;
            return this;
        }

        public InlineRedactionPattern build() {
            return new InlineRedactionPattern(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineRedactionPattern> {
        public Builder builtInPatternId(String var1);

        public Builder confidenceLevel(Integer var1);

        public Builder customPattern(CustomPattern var1);

        default public Builder customPattern(Consumer<CustomPattern.Builder> customPattern) {
            return this.customPattern((CustomPattern)((CustomPattern.Builder)CustomPattern.builder().applyMutation(customPattern)).build());
        }

        public Builder enforcedUrls(Collection<String> var1);

        public Builder enforcedUrls(String ... var1);

        public Builder exemptUrls(Collection<String> var1);

        public Builder exemptUrls(String ... var1);

        public Builder redactionPlaceHolder(RedactionPlaceHolder var1);

        default public Builder redactionPlaceHolder(Consumer<RedactionPlaceHolder.Builder> redactionPlaceHolder) {
            return this.redactionPlaceHolder((RedactionPlaceHolder)((RedactionPlaceHolder.Builder)RedactionPlaceHolder.builder().applyMutation(redactionPlaceHolder)).build());
        }
    }
}

