/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.Certificate;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrustStoreCertificateResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, GetTrustStoreCertificateResponse> {
    private static final SdkField<Certificate> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificate").getter(GetTrustStoreCertificateResponse.getter(GetTrustStoreCertificateResponse::certificate)).setter(GetTrustStoreCertificateResponse.setter(Builder::certificate)).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustStoreArn").getter(GetTrustStoreCertificateResponse.getter(GetTrustStoreCertificateResponse::trustStoreArn)).setter(GetTrustStoreCertificateResponse.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, TRUST_STORE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificate", CERTIFICATE_FIELD);
            this.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
        }
    });
    private final Certificate certificate;
    private final String trustStoreArn;

    private GetTrustStoreCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.trustStoreArn = builder.trustStoreArn;
    }

    public final Certificate certificate() {
        return this.certificate;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrustStoreCertificateResponse)) {
            return false;
        }
        GetTrustStoreCertificateResponse other = (GetTrustStoreCertificateResponse)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.trustStoreArn(), other.trustStoreArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrustStoreCertificateResponse").add("Certificate", (Object)this.certificate()).add("TrustStoreArn", (Object)this.trustStoreArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "trustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTrustStoreCertificateResponse, T> g) {
        return obj -> g.apply((GetTrustStoreCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private Certificate certificate;
        private String trustStoreArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrustStoreCertificateResponse model) {
            super(model);
            this.certificate(model.certificate);
            this.trustStoreArn(model.trustStoreArn);
        }

        public final Certificate.Builder getCertificate() {
            return this.certificate != null ? this.certificate.toBuilder() : null;
        }

        public final void setCertificate(Certificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        @Override
        public GetTrustStoreCertificateResponse build() {
            return new GetTrustStoreCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrustStoreCertificateResponse> {
        public Builder certificate(Certificate var1);

        default public Builder certificate(Consumer<Certificate.Builder> certificate) {
            return this.certificate((Certificate)((Certificate.Builder)Certificate.builder().applyMutation(certificate)).build());
        }

        public Builder trustStoreArn(String var1);
    }
}

