/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.AuthenticationType;
import software.amazon.awssdk.services.workspacesweb.model.BrowserType;
import software.amazon.awssdk.services.workspacesweb.model.InstanceType;
import software.amazon.awssdk.services.workspacesweb.model.PortalStatus;
import software.amazon.awssdk.services.workspacesweb.model.RendererType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortalSummary> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(PortalSummary.getter(PortalSummary::authenticationTypeAsString)).setter(PortalSummary.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserSettingsArn").getter(PortalSummary.getter(PortalSummary::browserSettingsArn)).setter(PortalSummary.setter(Builder::browserSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build()}).build();
    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserType").getter(PortalSummary.getter(PortalSummary::browserTypeAsString)).setter(PortalSummary.setter(Builder::browserType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserType").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(PortalSummary.getter(PortalSummary::creationDate)).setter(PortalSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(PortalSummary.getter(PortalSummary::displayName)).setter(PortalSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(PortalSummary.getter(PortalSummary::instanceTypeAsString)).setter(PortalSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAccessSettingsArn").getter(PortalSummary.getter(PortalSummary::ipAccessSettingsArn)).setter(PortalSummary.setter(Builder::ipAccessSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxConcurrentSessions").getter(PortalSummary.getter(PortalSummary::maxConcurrentSessions)).setter(PortalSummary.setter(Builder::maxConcurrentSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrentSessions").build()}).build();
    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSettingsArn").getter(PortalSummary.getter(PortalSummary::networkSettingsArn)).setter(PortalSummary.setter(Builder::networkSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettingsArn").build()}).build();
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalArn").getter(PortalSummary.getter(PortalSummary::portalArn)).setter(PortalSummary.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final SdkField<String> PORTAL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalEndpoint").getter(PortalSummary.getter(PortalSummary::portalEndpoint)).setter(PortalSummary.setter(Builder::portalEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalEndpoint").build()}).build();
    private static final SdkField<String> PORTAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalStatus").getter(PortalSummary.getter(PortalSummary::portalStatusAsString)).setter(PortalSummary.setter(Builder::portalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()}).build();
    private static final SdkField<String> RENDERER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rendererType").getter(PortalSummary.getter(PortalSummary::rendererTypeAsString)).setter(PortalSummary.setter(Builder::rendererType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rendererType").build()}).build();
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustStoreArn").getter(PortalSummary.getter(PortalSummary::trustStoreArn)).setter(PortalSummary.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()}).build();
    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAccessLoggingSettingsArn").getter(PortalSummary.getter(PortalSummary::userAccessLoggingSettingsArn)).setter(PortalSummary.setter(Builder::userAccessLoggingSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn").build()}).build();
    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userSettingsArn").getter(PortalSummary.getter(PortalSummary::userSettingsArn)).setter(PortalSummary.setter(Builder::userSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, BROWSER_SETTINGS_ARN_FIELD, BROWSER_TYPE_FIELD, CREATION_DATE_FIELD, DISPLAY_NAME_FIELD, INSTANCE_TYPE_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD, MAX_CONCURRENT_SESSIONS_FIELD, NETWORK_SETTINGS_ARN_FIELD, PORTAL_ARN_FIELD, PORTAL_ENDPOINT_FIELD, PORTAL_STATUS_FIELD, RENDERER_TYPE_FIELD, TRUST_STORE_ARN_FIELD, USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD, USER_SETTINGS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
            this.put("browserSettingsArn", BROWSER_SETTINGS_ARN_FIELD);
            this.put("browserType", BROWSER_TYPE_FIELD);
            this.put("creationDate", CREATION_DATE_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
            this.put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
            this.put("maxConcurrentSessions", MAX_CONCURRENT_SESSIONS_FIELD);
            this.put("networkSettingsArn", NETWORK_SETTINGS_ARN_FIELD);
            this.put("portalArn", PORTAL_ARN_FIELD);
            this.put("portalEndpoint", PORTAL_ENDPOINT_FIELD);
            this.put("portalStatus", PORTAL_STATUS_FIELD);
            this.put("rendererType", RENDERER_TYPE_FIELD);
            this.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
            this.put("userAccessLoggingSettingsArn", USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD);
            this.put("userSettingsArn", USER_SETTINGS_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final String browserSettingsArn;
    private final String browserType;
    private final Instant creationDate;
    private final String displayName;
    private final String instanceType;
    private final String ipAccessSettingsArn;
    private final Integer maxConcurrentSessions;
    private final String networkSettingsArn;
    private final String portalArn;
    private final String portalEndpoint;
    private final String portalStatus;
    private final String rendererType;
    private final String trustStoreArn;
    private final String userAccessLoggingSettingsArn;
    private final String userSettingsArn;

    private PortalSummary(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.browserSettingsArn = builder.browserSettingsArn;
        this.browserType = builder.browserType;
        this.creationDate = builder.creationDate;
        this.displayName = builder.displayName;
        this.instanceType = builder.instanceType;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
        this.networkSettingsArn = builder.networkSettingsArn;
        this.portalArn = builder.portalArn;
        this.portalEndpoint = builder.portalEndpoint;
        this.portalStatus = builder.portalStatus;
        this.rendererType = builder.rendererType;
        this.trustStoreArn = builder.trustStoreArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
        this.userSettingsArn = builder.userSettingsArn;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final String browserSettingsArn() {
        return this.browserSettingsArn;
    }

    public final BrowserType browserType() {
        return BrowserType.fromValue(this.browserType);
    }

    public final String browserTypeAsString() {
        return this.browserType;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String ipAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    public final Integer maxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public final String networkSettingsArn() {
        return this.networkSettingsArn;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    public final String portalEndpoint() {
        return this.portalEndpoint;
    }

    public final PortalStatus portalStatus() {
        return PortalStatus.fromValue(this.portalStatus);
    }

    public final String portalStatusAsString() {
        return this.portalStatus;
    }

    public final RendererType rendererType() {
        return RendererType.fromValue(this.rendererType);
    }

    public final String rendererTypeAsString() {
        return this.rendererType;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final String userAccessLoggingSettingsArn() {
        return this.userAccessLoggingSettingsArn;
    }

    public final String userSettingsArn() {
        return this.userSettingsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rendererTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAccessLoggingSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettingsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalSummary)) {
            return false;
        }
        PortalSummary other = (PortalSummary)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.browserSettingsArn(), other.browserSettingsArn()) && Objects.equals(this.browserTypeAsString(), other.browserTypeAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.ipAccessSettingsArn(), other.ipAccessSettingsArn()) && Objects.equals(this.maxConcurrentSessions(), other.maxConcurrentSessions()) && Objects.equals(this.networkSettingsArn(), other.networkSettingsArn()) && Objects.equals(this.portalArn(), other.portalArn()) && Objects.equals(this.portalEndpoint(), other.portalEndpoint()) && Objects.equals(this.portalStatusAsString(), other.portalStatusAsString()) && Objects.equals(this.rendererTypeAsString(), other.rendererTypeAsString()) && Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn()) && Objects.equals(this.userSettingsArn(), other.userSettingsArn());
    }

    public final String toString() {
        return ToString.builder((String)"PortalSummary").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("BrowserSettingsArn", (Object)this.browserSettingsArn()).add("BrowserType", (Object)this.browserTypeAsString()).add("CreationDate", (Object)this.creationDate()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("InstanceType", (Object)this.instanceTypeAsString()).add("IpAccessSettingsArn", (Object)this.ipAccessSettingsArn()).add("MaxConcurrentSessions", (Object)this.maxConcurrentSessions()).add("NetworkSettingsArn", (Object)this.networkSettingsArn()).add("PortalArn", (Object)this.portalArn()).add("PortalEndpoint", (Object)this.portalEndpoint()).add("PortalStatus", (Object)this.portalStatusAsString()).add("RendererType", (Object)this.rendererTypeAsString()).add("TrustStoreArn", (Object)this.trustStoreArn()).add("UserAccessLoggingSettingsArn", (Object)this.userAccessLoggingSettingsArn()).add("UserSettingsArn", (Object)this.userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "browserSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.browserSettingsArn()));
            }
            case "browserType": {
                return Optional.ofNullable(clazz.cast(this.browserTypeAsString()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "ipAccessSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.ipAccessSettingsArn()));
            }
            case "maxConcurrentSessions": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentSessions()));
            }
            case "networkSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.networkSettingsArn()));
            }
            case "portalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
            case "portalEndpoint": {
                return Optional.ofNullable(clazz.cast(this.portalEndpoint()));
            }
            case "portalStatus": {
                return Optional.ofNullable(clazz.cast(this.portalStatusAsString()));
            }
            case "rendererType": {
                return Optional.ofNullable(clazz.cast(this.rendererTypeAsString()));
            }
            case "trustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "userAccessLoggingSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.userAccessLoggingSettingsArn()));
            }
            case "userSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.userSettingsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PortalSummary, T> g) {
        return obj -> g.apply((PortalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private String browserSettingsArn;
        private String browserType;
        private Instant creationDate;
        private String displayName;
        private String instanceType;
        private String ipAccessSettingsArn;
        private Integer maxConcurrentSessions;
        private String networkSettingsArn;
        private String portalArn;
        private String portalEndpoint;
        private String portalStatus;
        private String rendererType;
        private String trustStoreArn;
        private String userAccessLoggingSettingsArn;
        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PortalSummary model) {
            this.authenticationType(model.authenticationType);
            this.browserSettingsArn(model.browserSettingsArn);
            this.browserType(model.browserType);
            this.creationDate(model.creationDate);
            this.displayName(model.displayName);
            this.instanceType(model.instanceType);
            this.ipAccessSettingsArn(model.ipAccessSettingsArn);
            this.maxConcurrentSessions(model.maxConcurrentSessions);
            this.networkSettingsArn(model.networkSettingsArn);
            this.portalArn(model.portalArn);
            this.portalEndpoint(model.portalEndpoint);
            this.portalStatus(model.portalStatus);
            this.rendererType(model.rendererType);
            this.trustStoreArn(model.trustStoreArn);
            this.userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
            this.userSettingsArn(model.userSettingsArn);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getBrowserSettingsArn() {
            return this.browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getBrowserType() {
            return this.browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return this.ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return this.maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public final String getNetworkSettingsArn() {
            return this.networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalEndpoint() {
            return this.portalEndpoint;
        }

        public final void setPortalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
        }

        @Override
        public final Builder portalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
            return this;
        }

        public final String getPortalStatus() {
            return this.portalStatus;
        }

        public final void setPortalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
        }

        @Override
        public final Builder portalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus(portalStatus == null ? null : portalStatus.toString());
            return this;
        }

        public final String getRendererType() {
            return this.rendererType;
        }

        public final void setRendererType(String rendererType) {
            this.rendererType = rendererType;
        }

        @Override
        public final Builder rendererType(String rendererType) {
            this.rendererType = rendererType;
            return this;
        }

        @Override
        public final Builder rendererType(RendererType rendererType) {
            this.rendererType(rendererType == null ? null : rendererType.toString());
            return this;
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return this.userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        public final String getUserSettingsArn() {
            return this.userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        public PortalSummary build() {
            return new PortalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortalSummary> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder browserSettingsArn(String var1);

        public Builder browserType(String var1);

        public Builder browserType(BrowserType var1);

        public Builder creationDate(Instant var1);

        public Builder displayName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder ipAccessSettingsArn(String var1);

        public Builder maxConcurrentSessions(Integer var1);

        public Builder networkSettingsArn(String var1);

        public Builder portalArn(String var1);

        public Builder portalEndpoint(String var1);

        public Builder portalStatus(String var1);

        public Builder portalStatus(PortalStatus var1);

        public Builder rendererType(String var1);

        public Builder rendererType(RendererType var1);

        public Builder trustStoreArn(String var1);

        public Builder userAccessLoggingSettingsArn(String var1);

        public Builder userSettingsArn(String var1);
    }
}

