/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.endpoints.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class RuleUrl {
    private final String scheme;
    private final String authority;
    private final String path;
    private final String normalizedPath;
    private final boolean isIp;

    RuleUrl(String scheme, String authority, String path, String normalizedPath, boolean isIp) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.normalizedPath = normalizedPath;
        this.isIp = isIp;
    }

    public String scheme() {
        return this.scheme;
    }

    public String authority() {
        return this.authority;
    }

    public String path() {
        return this.path;
    }

    public String normalizedPath() {
        return this.normalizedPath;
    }

    public boolean isIp() {
        return this.isIp;
    }

    public static RuleUrl parse(String url) throws MalformedURLException {
        String normalizedPath;
        String[] dottedParts;
        URL parsed = new URL(url);
        String path = parsed.getPath();
        if (parsed.getQuery() != null) {
            return null;
        }
        boolean isIpAddr = false;
        String host = parsed.getHost();
        if (host.startsWith("[") && host.endsWith("]")) {
            isIpAddr = true;
        }
        if ((dottedParts = host.split("\\.")).length == 4 && Arrays.stream(dottedParts).allMatch(part -> {
            try {
                int value = Integer.parseInt(part);
                return value >= 0 && value <= 255;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        })) {
            isIpAddr = true;
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            normalizedPath = "/";
        } else {
            StringBuilder builder = new StringBuilder();
            if (!path.startsWith("/")) {
                builder.append("/");
            }
            builder.append(path);
            if (!path.endsWith("/")) {
                builder.append("/");
            }
            normalizedPath = builder.toString();
        }
        return new RuleUrl(parsed.getProtocol(), parsed.getAuthority(), path, normalizedPath, isIpAddr);
    }
}

