/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.EnabledType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(UserSettings.getter(UserSettings::associatedPortalArns)).setter(UserSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COPY_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("copyAllowed").getter(UserSettings.getter(UserSettings::copyAllowedAsString)).setter(UserSettings.setter(Builder::copyAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAllowed").build()}).build();
    private static final SdkField<String> DOWNLOAD_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("downloadAllowed").getter(UserSettings.getter(UserSettings::downloadAllowedAsString)).setter(UserSettings.setter(Builder::downloadAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadAllowed").build()}).build();
    private static final SdkField<String> PASTE_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pasteAllowed").getter(UserSettings.getter(UserSettings::pasteAllowedAsString)).setter(UserSettings.setter(Builder::pasteAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pasteAllowed").build()}).build();
    private static final SdkField<String> PRINT_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("printAllowed").getter(UserSettings.getter(UserSettings::printAllowedAsString)).setter(UserSettings.setter(Builder::printAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("printAllowed").build()}).build();
    private static final SdkField<String> UPLOAD_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadAllowed").getter(UserSettings.getter(UserSettings::uploadAllowedAsString)).setter(UserSettings.setter(Builder::uploadAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadAllowed").build()}).build();
    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userSettingsArn").getter(UserSettings.getter(UserSettings::userSettingsArn)).setter(UserSettings.setter(Builder::userSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD, COPY_ALLOWED_FIELD, DOWNLOAD_ALLOWED_FIELD, PASTE_ALLOWED_FIELD, PRINT_ALLOWED_FIELD, UPLOAD_ALLOWED_FIELD, USER_SETTINGS_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> associatedPortalArns;
    private final String copyAllowed;
    private final String downloadAllowed;
    private final String pasteAllowed;
    private final String printAllowed;
    private final String uploadAllowed;
    private final String userSettingsArn;

    private UserSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.copyAllowed = builder.copyAllowed;
        this.downloadAllowed = builder.downloadAllowed;
        this.pasteAllowed = builder.pasteAllowed;
        this.printAllowed = builder.printAllowed;
        this.uploadAllowed = builder.uploadAllowed;
        this.userSettingsArn = builder.userSettingsArn;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final EnabledType copyAllowed() {
        return EnabledType.fromValue(this.copyAllowed);
    }

    public final String copyAllowedAsString() {
        return this.copyAllowed;
    }

    public final EnabledType downloadAllowed() {
        return EnabledType.fromValue(this.downloadAllowed);
    }

    public final String downloadAllowedAsString() {
        return this.downloadAllowed;
    }

    public final EnabledType pasteAllowed() {
        return EnabledType.fromValue(this.pasteAllowed);
    }

    public final String pasteAllowedAsString() {
        return this.pasteAllowed;
    }

    public final EnabledType printAllowed() {
        return EnabledType.fromValue(this.printAllowed);
    }

    public final String printAllowedAsString() {
        return this.printAllowed;
    }

    public final EnabledType uploadAllowed() {
        return EnabledType.fromValue(this.uploadAllowed);
    }

    public final String uploadAllowedAsString() {
        return this.uploadAllowed;
    }

    public final String userSettingsArn() {
        return this.userSettingsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.copyAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pasteAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.printAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettingsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)obj;
        return this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.copyAllowedAsString(), other.copyAllowedAsString()) && Objects.equals(this.downloadAllowedAsString(), other.downloadAllowedAsString()) && Objects.equals(this.pasteAllowedAsString(), other.pasteAllowedAsString()) && Objects.equals(this.printAllowedAsString(), other.printAllowedAsString()) && Objects.equals(this.uploadAllowedAsString(), other.uploadAllowedAsString()) && Objects.equals(this.userSettingsArn(), other.userSettingsArn());
    }

    public final String toString() {
        return ToString.builder((String)"UserSettings").add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("CopyAllowed", (Object)this.copyAllowedAsString()).add("DownloadAllowed", (Object)this.downloadAllowedAsString()).add("PasteAllowed", (Object)this.pasteAllowedAsString()).add("PrintAllowed", (Object)this.printAllowedAsString()).add("UploadAllowed", (Object)this.uploadAllowedAsString()).add("UserSettingsArn", (Object)this.userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "copyAllowed": {
                return Optional.ofNullable(clazz.cast(this.copyAllowedAsString()));
            }
            case "downloadAllowed": {
                return Optional.ofNullable(clazz.cast(this.downloadAllowedAsString()));
            }
            case "pasteAllowed": {
                return Optional.ofNullable(clazz.cast(this.pasteAllowedAsString()));
            }
            case "printAllowed": {
                return Optional.ofNullable(clazz.cast(this.printAllowedAsString()));
            }
            case "uploadAllowed": {
                return Optional.ofNullable(clazz.cast(this.uploadAllowedAsString()));
            }
            case "userSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.userSettingsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private String copyAllowed;
        private String downloadAllowed;
        private String pasteAllowed;
        private String printAllowed;
        private String uploadAllowed;
        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            this.associatedPortalArns(model.associatedPortalArns);
            this.copyAllowed(model.copyAllowed);
            this.downloadAllowed(model.downloadAllowed);
            this.pasteAllowed(model.pasteAllowed);
            this.printAllowed(model.printAllowed);
            this.uploadAllowed(model.uploadAllowed);
            this.userSettingsArn(model.userSettingsArn);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getCopyAllowed() {
            return this.copyAllowed;
        }

        public final void setCopyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
        }

        @Override
        public final Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        @Override
        public final Builder copyAllowed(EnabledType copyAllowed) {
            this.copyAllowed(copyAllowed == null ? null : copyAllowed.toString());
            return this;
        }

        public final String getDownloadAllowed() {
            return this.downloadAllowed;
        }

        public final void setDownloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        @Override
        public final Builder downloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        @Override
        public final Builder downloadAllowed(EnabledType downloadAllowed) {
            this.downloadAllowed(downloadAllowed == null ? null : downloadAllowed.toString());
            return this;
        }

        public final String getPasteAllowed() {
            return this.pasteAllowed;
        }

        public final void setPasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
        }

        @Override
        public final Builder pasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        @Override
        public final Builder pasteAllowed(EnabledType pasteAllowed) {
            this.pasteAllowed(pasteAllowed == null ? null : pasteAllowed.toString());
            return this;
        }

        public final String getPrintAllowed() {
            return this.printAllowed;
        }

        public final void setPrintAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
        }

        @Override
        public final Builder printAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        @Override
        public final Builder printAllowed(EnabledType printAllowed) {
            this.printAllowed(printAllowed == null ? null : printAllowed.toString());
            return this;
        }

        public final String getUploadAllowed() {
            return this.uploadAllowed;
        }

        public final void setUploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
        }

        @Override
        public final Builder uploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        @Override
        public final Builder uploadAllowed(EnabledType uploadAllowed) {
            this.uploadAllowed(uploadAllowed == null ? null : uploadAllowed.toString());
            return this;
        }

        public final String getUserSettingsArn() {
            return this.userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        public UserSettings build() {
            return new UserSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSettings> {
        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder copyAllowed(String var1);

        public Builder copyAllowed(EnabledType var1);

        public Builder downloadAllowed(String var1);

        public Builder downloadAllowed(EnabledType var1);

        public Builder pasteAllowed(String var1);

        public Builder pasteAllowed(EnabledType var1);

        public Builder printAllowed(String var1);

        public Builder printAllowed(EnabledType var1);

        public Builder uploadAllowed(String var1);

        public Builder uploadAllowed(EnabledType var1);

        public Builder userSettingsArn(String var1);
    }
}

