/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.Tag;
import software.amazon.awssdk.services.workspacesweb.model.TagListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePortalRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, CreatePortalRequest> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(CreatePortalRequest.getter(CreatePortalRequest::additionalEncryptionContext)).setter(CreatePortalRequest.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePortalRequest.getter(CreatePortalRequest::clientToken)).setter(CreatePortalRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(CreatePortalRequest.getter(CreatePortalRequest::customerManagedKey)).setter(CreatePortalRequest.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreatePortalRequest.getter(CreatePortalRequest::displayName)).setter(CreatePortalRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreatePortalRequest.getter(CreatePortalRequest::tags)).setter(CreatePortalRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, CLIENT_TOKEN_FIELD, CUSTOMER_MANAGED_KEY_FIELD, DISPLAY_NAME_FIELD, TAGS_FIELD));
    private final Map<String, String> additionalEncryptionContext;
    private final String clientToken;
    private final String customerManagedKey;
    private final String displayName;
    private final List<Tag> tags;

    private CreatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.clientToken = builder.clientToken;
        this.customerManagedKey = builder.customerManagedKey;
        this.displayName = builder.displayName;
        this.tags = builder.tags;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest)((Object)obj);
        return this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey()) && Objects.equals(this.displayName(), other.displayName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePortalRequest").add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("ClientToken", (Object)this.clientToken()).add("CustomerManagedKey", (Object)this.customerManagedKey()).add("DisplayName", (Object)this.displayName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalRequest, T> g) {
        return obj -> g.apply((CreatePortalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private String customerManagedKey;
        private String displayName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalRequest model) {
            super(model);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.clientToken(model.clientToken);
            this.customerManagedKey(model.customerManagedKey);
            this.displayName(model.displayName);
            this.tags(model.tags);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortalRequest build() {
            return new CreatePortalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePortalRequest> {
        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder customerManagedKey(String var1);

        public Builder displayName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

