/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesthinclient.model.Software;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareListCopier;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetValidationStatus;
import software.amazon.awssdk.services.workspacesthinclient.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwareSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwareSet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SoftwareSet.getter(SoftwareSet::id)).setter(SoftwareSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(SoftwareSet.getter(SoftwareSet::version)).setter(SoftwareSet.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> RELEASED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("releasedAt").getter(SoftwareSet.getter(SoftwareSet::releasedAt)).setter(SoftwareSet.setter(Builder::releasedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releasedAt").build()}).build();
    private static final SdkField<Instant> SUPPORTED_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("supportedUntil").getter(SoftwareSet.getter(SoftwareSet::supportedUntil)).setter(SoftwareSet.setter(Builder::supportedUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedUntil").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationStatus").getter(SoftwareSet.getter(SoftwareSet::validationStatusAsString)).setter(SoftwareSet.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()}).build();
    private static final SdkField<List<Software>> SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("software").getter(SoftwareSet.getter(SoftwareSet::software)).setter(SoftwareSet.setter(Builder::software)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("software").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Software::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SoftwareSet.getter(SoftwareSet::arn)).setter(SoftwareSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SoftwareSet.getter(SoftwareSet::tags)).setter(SoftwareSet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_FIELD, RELEASED_AT_FIELD, SUPPORTED_UNTIL_FIELD, VALIDATION_STATUS_FIELD, SOFTWARE_FIELD, ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SoftwareSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String version;
    private final Instant releasedAt;
    private final Instant supportedUntil;
    private final String validationStatus;
    private final List<Software> software;
    private final String arn;
    private final Map<String, String> tags;

    private SoftwareSet(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.releasedAt = builder.releasedAt;
        this.supportedUntil = builder.supportedUntil;
        this.validationStatus = builder.validationStatus;
        this.software = builder.software;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String version() {
        return this.version;
    }

    public final Instant releasedAt() {
        return this.releasedAt;
    }

    public final Instant supportedUntil() {
        return this.supportedUntil;
    }

    public final SoftwareSetValidationStatus validationStatus() {
        return SoftwareSetValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final boolean hasSoftware() {
        return this.software != null && !(this.software instanceof SdkAutoConstructList);
    }

    public final List<Software> software() {
        return this.software;
    }

    public final String arn() {
        return this.arn;
    }

    @Deprecated
    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    @Deprecated
    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releasedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSoftware() ? this.software() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareSet)) {
            return false;
        }
        SoftwareSet other = (SoftwareSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releasedAt(), other.releasedAt()) && Objects.equals(this.supportedUntil(), other.supportedUntil()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && this.hasSoftware() == other.hasSoftware() && Objects.equals(this.software(), other.software()) && Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwareSet").add("Id", (Object)this.id()).add("Version", (Object)this.version()).add("ReleasedAt", (Object)this.releasedAt()).add("SupportedUntil", (Object)this.supportedUntil()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("Software", this.hasSoftware() ? this.software() : null).add("Arn", (Object)this.arn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releasedAt": {
                return Optional.ofNullable(clazz.cast(this.releasedAt()));
            }
            case "supportedUntil": {
                return Optional.ofNullable(clazz.cast(this.supportedUntil()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "software": {
                return Optional.ofNullable(clazz.cast(this.software()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("releasedAt", RELEASED_AT_FIELD);
        map.put("supportedUntil", SUPPORTED_UNTIL_FIELD);
        map.put("validationStatus", VALIDATION_STATUS_FIELD);
        map.put("software", SOFTWARE_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwareSet, T> g) {
        return obj -> g.apply((SoftwareSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String version;
        private Instant releasedAt;
        private Instant supportedUntil;
        private String validationStatus;
        private List<Software> software = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareSet model) {
            this.id(model.id);
            this.version(model.version);
            this.releasedAt(model.releasedAt);
            this.supportedUntil(model.supportedUntil);
            this.validationStatus(model.validationStatus);
            this.software(model.software);
            this.arn(model.arn);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getReleasedAt() {
            return this.releasedAt;
        }

        public final void setReleasedAt(Instant releasedAt) {
            this.releasedAt = releasedAt;
        }

        @Override
        public final Builder releasedAt(Instant releasedAt) {
            this.releasedAt = releasedAt;
            return this;
        }

        public final Instant getSupportedUntil() {
            return this.supportedUntil;
        }

        public final void setSupportedUntil(Instant supportedUntil) {
            this.supportedUntil = supportedUntil;
        }

        @Override
        public final Builder supportedUntil(Instant supportedUntil) {
            this.supportedUntil = supportedUntil;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(SoftwareSetValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final List<Software.Builder> getSoftware() {
            List<Software.Builder> result = SoftwareListCopier.copyToBuilder(this.software);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSoftware(Collection<Software.BuilderImpl> software) {
            this.software = SoftwareListCopier.copyFromBuilder(software);
        }

        @Override
        public final Builder software(Collection<Software> software) {
            this.software = SoftwareListCopier.copy(software);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder software(Software ... software) {
            this.software(Arrays.asList(software));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder software(Consumer<Software.Builder> ... software) {
            this.software(Stream.of(software).map(c -> (Software)((Software.Builder)Software.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public SoftwareSet build() {
            return new SoftwareSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwareSet> {
        public Builder id(String var1);

        public Builder version(String var1);

        public Builder releasedAt(Instant var1);

        public Builder supportedUntil(Instant var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(SoftwareSetValidationStatus var1);

        public Builder software(Collection<Software> var1);

        public Builder software(Software ... var1);

        public Builder software(Consumer<Software.Builder> ... var1);

        public Builder arn(String var1);

        @Deprecated
        public Builder tags(Map<String, String> var1);
    }
}

