/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesthinclient.model.DeviceSoftwareSetComplianceStatus;
import software.amazon.awssdk.services.workspacesthinclient.model.DeviceStatus;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateSchedule;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateStatus;
import software.amazon.awssdk.services.workspacesthinclient.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Device.getter(Device::id)).setter(Device.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serialNumber").getter(Device.getter(Device::serialNumber)).setter(Device.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Device.getter(Device::name)).setter(Device.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(Device.getter(Device::model)).setter(Device.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(Device.getter(Device::environmentId)).setter(Device.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Device.getter(Device::statusAsString)).setter(Device.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CURRENT_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentSoftwareSetId").getter(Device.getter(Device::currentSoftwareSetId)).setter(Device.setter(Builder::currentSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSoftwareSetId").build()}).build();
    private static final SdkField<String> CURRENT_SOFTWARE_SET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentSoftwareSetVersion").getter(Device.getter(Device::currentSoftwareSetVersion)).setter(Device.setter(Builder::currentSoftwareSetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSoftwareSetVersion").build()}).build();
    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredSoftwareSetId").getter(Device.getter(Device::desiredSoftwareSetId)).setter(Device.setter(Builder::desiredSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build()}).build();
    private static final SdkField<String> PENDING_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pendingSoftwareSetId").getter(Device.getter(Device::pendingSoftwareSetId)).setter(Device.setter(Builder::pendingSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetId").build()}).build();
    private static final SdkField<String> PENDING_SOFTWARE_SET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pendingSoftwareSetVersion").getter(Device.getter(Device::pendingSoftwareSetVersion)).setter(Device.setter(Builder::pendingSoftwareSetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetVersion").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateSchedule").getter(Device.getter(Device::softwareSetUpdateScheduleAsString)).setter(Device.setter(Builder::softwareSetUpdateSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetComplianceStatus").getter(Device.getter(Device::softwareSetComplianceStatusAsString)).setter(Device.setter(Builder::softwareSetComplianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetComplianceStatus").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateStatus").getter(Device.getter(Device::softwareSetUpdateStatusAsString)).setter(Device.setter(Builder::softwareSetUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateStatus").build()}).build();
    private static final SdkField<Instant> LAST_CONNECTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastConnectedAt").getter(Device.getter(Device::lastConnectedAt)).setter(Device.setter(Builder::lastConnectedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastConnectedAt").build()}).build();
    private static final SdkField<Instant> LAST_POSTURE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastPostureAt").getter(Device.getter(Device::lastPostureAt)).setter(Device.setter(Builder::lastPostureAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastPostureAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Device.getter(Device::createdAt)).setter(Device.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Device.getter(Device::updatedAt)).setter(Device.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Device.getter(Device::arn)).setter(Device.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(Device.getter(Device::kmsKeyArn)).setter(Device.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Device.getter(Device::tags)).setter(Device.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SERIAL_NUMBER_FIELD, NAME_FIELD, MODEL_FIELD, ENVIRONMENT_ID_FIELD, STATUS_FIELD, CURRENT_SOFTWARE_SET_ID_FIELD, CURRENT_SOFTWARE_SET_VERSION_FIELD, DESIRED_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_VERSION_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, SOFTWARE_SET_COMPLIANCE_STATUS_FIELD, SOFTWARE_SET_UPDATE_STATUS_FIELD, LAST_CONNECTED_AT_FIELD, LAST_POSTURE_AT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ARN_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Device.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String serialNumber;
    private final String name;
    private final String model;
    private final String environmentId;
    private final String status;
    private final String currentSoftwareSetId;
    private final String currentSoftwareSetVersion;
    private final String desiredSoftwareSetId;
    private final String pendingSoftwareSetId;
    private final String pendingSoftwareSetVersion;
    private final String softwareSetUpdateSchedule;
    private final String softwareSetComplianceStatus;
    private final String softwareSetUpdateStatus;
    private final Instant lastConnectedAt;
    private final Instant lastPostureAt;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String arn;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private Device(BuilderImpl builder) {
        this.id = builder.id;
        this.serialNumber = builder.serialNumber;
        this.name = builder.name;
        this.model = builder.model;
        this.environmentId = builder.environmentId;
        this.status = builder.status;
        this.currentSoftwareSetId = builder.currentSoftwareSetId;
        this.currentSoftwareSetVersion = builder.currentSoftwareSetVersion;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.pendingSoftwareSetId = builder.pendingSoftwareSetId;
        this.pendingSoftwareSetVersion = builder.pendingSoftwareSetVersion;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.softwareSetComplianceStatus = builder.softwareSetComplianceStatus;
        this.softwareSetUpdateStatus = builder.softwareSetUpdateStatus;
        this.lastConnectedAt = builder.lastConnectedAt;
        this.lastPostureAt = builder.lastPostureAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.arn = builder.arn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String name() {
        return this.name;
    }

    public final String model() {
        return this.model;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final DeviceStatus status() {
        return DeviceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String currentSoftwareSetId() {
        return this.currentSoftwareSetId;
    }

    public final String currentSoftwareSetVersion() {
        return this.currentSoftwareSetVersion;
    }

    public final String desiredSoftwareSetId() {
        return this.desiredSoftwareSetId;
    }

    public final String pendingSoftwareSetId() {
        return this.pendingSoftwareSetId;
    }

    public final String pendingSoftwareSetVersion() {
        return this.pendingSoftwareSetVersion;
    }

    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(this.softwareSetUpdateSchedule);
    }

    public final String softwareSetUpdateScheduleAsString() {
        return this.softwareSetUpdateSchedule;
    }

    public final DeviceSoftwareSetComplianceStatus softwareSetComplianceStatus() {
        return DeviceSoftwareSetComplianceStatus.fromValue(this.softwareSetComplianceStatus);
    }

    public final String softwareSetComplianceStatusAsString() {
        return this.softwareSetComplianceStatus;
    }

    public final SoftwareSetUpdateStatus softwareSetUpdateStatus() {
        return SoftwareSetUpdateStatus.fromValue(this.softwareSetUpdateStatus);
    }

    public final String softwareSetUpdateStatusAsString() {
        return this.softwareSetUpdateStatus;
    }

    public final Instant lastConnectedAt() {
        return this.lastConnectedAt;
    }

    public final Instant lastPostureAt() {
        return this.lastPostureAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    @Deprecated
    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    @Deprecated
    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSoftwareSetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingSoftwareSetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetComplianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastConnectedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPostureAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.currentSoftwareSetId(), other.currentSoftwareSetId()) && Objects.equals(this.currentSoftwareSetVersion(), other.currentSoftwareSetVersion()) && Objects.equals(this.desiredSoftwareSetId(), other.desiredSoftwareSetId()) && Objects.equals(this.pendingSoftwareSetId(), other.pendingSoftwareSetId()) && Objects.equals(this.pendingSoftwareSetVersion(), other.pendingSoftwareSetVersion()) && Objects.equals(this.softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString()) && Objects.equals(this.softwareSetComplianceStatusAsString(), other.softwareSetComplianceStatusAsString()) && Objects.equals(this.softwareSetUpdateStatusAsString(), other.softwareSetUpdateStatusAsString()) && Objects.equals(this.lastConnectedAt(), other.lastConnectedAt()) && Objects.equals(this.lastPostureAt(), other.lastPostureAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Device").add("Id", (Object)this.id()).add("SerialNumber", (Object)this.serialNumber()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Model", (Object)this.model()).add("EnvironmentId", (Object)this.environmentId()).add("Status", (Object)this.statusAsString()).add("CurrentSoftwareSetId", (Object)this.currentSoftwareSetId()).add("CurrentSoftwareSetVersion", (Object)this.currentSoftwareSetVersion()).add("DesiredSoftwareSetId", (Object)this.desiredSoftwareSetId()).add("PendingSoftwareSetId", (Object)this.pendingSoftwareSetId()).add("PendingSoftwareSetVersion", (Object)this.pendingSoftwareSetVersion()).add("SoftwareSetUpdateSchedule", (Object)this.softwareSetUpdateScheduleAsString()).add("SoftwareSetComplianceStatus", (Object)this.softwareSetComplianceStatusAsString()).add("SoftwareSetUpdateStatus", (Object)this.softwareSetUpdateStatusAsString()).add("LastConnectedAt", (Object)this.lastConnectedAt()).add("LastPostureAt", (Object)this.lastPostureAt()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Arn", (Object)this.arn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "serialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "currentSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.currentSoftwareSetId()));
            }
            case "currentSoftwareSetVersion": {
                return Optional.ofNullable(clazz.cast(this.currentSoftwareSetVersion()));
            }
            case "desiredSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.desiredSoftwareSetId()));
            }
            case "pendingSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.pendingSoftwareSetId()));
            }
            case "pendingSoftwareSetVersion": {
                return Optional.ofNullable(clazz.cast(this.pendingSoftwareSetVersion()));
            }
            case "softwareSetUpdateSchedule": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateScheduleAsString()));
            }
            case "softwareSetComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.softwareSetComplianceStatusAsString()));
            }
            case "softwareSetUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateStatusAsString()));
            }
            case "lastConnectedAt": {
                return Optional.ofNullable(clazz.cast(this.lastConnectedAt()));
            }
            case "lastPostureAt": {
                return Optional.ofNullable(clazz.cast(this.lastPostureAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("serialNumber", SERIAL_NUMBER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("model", MODEL_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("currentSoftwareSetId", CURRENT_SOFTWARE_SET_ID_FIELD);
        map.put("currentSoftwareSetVersion", CURRENT_SOFTWARE_SET_VERSION_FIELD);
        map.put("desiredSoftwareSetId", DESIRED_SOFTWARE_SET_ID_FIELD);
        map.put("pendingSoftwareSetId", PENDING_SOFTWARE_SET_ID_FIELD);
        map.put("pendingSoftwareSetVersion", PENDING_SOFTWARE_SET_VERSION_FIELD);
        map.put("softwareSetUpdateSchedule", SOFTWARE_SET_UPDATE_SCHEDULE_FIELD);
        map.put("softwareSetComplianceStatus", SOFTWARE_SET_COMPLIANCE_STATUS_FIELD);
        map.put("softwareSetUpdateStatus", SOFTWARE_SET_UPDATE_STATUS_FIELD);
        map.put("lastConnectedAt", LAST_CONNECTED_AT_FIELD);
        map.put("lastPostureAt", LAST_POSTURE_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String serialNumber;
        private String name;
        private String model;
        private String environmentId;
        private String status;
        private String currentSoftwareSetId;
        private String currentSoftwareSetVersion;
        private String desiredSoftwareSetId;
        private String pendingSoftwareSetId;
        private String pendingSoftwareSetVersion;
        private String softwareSetUpdateSchedule;
        private String softwareSetComplianceStatus;
        private String softwareSetUpdateStatus;
        private Instant lastConnectedAt;
        private Instant lastPostureAt;
        private Instant createdAt;
        private Instant updatedAt;
        private String arn;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.id(model.id);
            this.serialNumber(model.serialNumber);
            this.name(model.name);
            this.model(model.model);
            this.environmentId(model.environmentId);
            this.status(model.status);
            this.currentSoftwareSetId(model.currentSoftwareSetId);
            this.currentSoftwareSetVersion(model.currentSoftwareSetVersion);
            this.desiredSoftwareSetId(model.desiredSoftwareSetId);
            this.pendingSoftwareSetId(model.pendingSoftwareSetId);
            this.pendingSoftwareSetVersion(model.pendingSoftwareSetVersion);
            this.softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            this.softwareSetComplianceStatus(model.softwareSetComplianceStatus);
            this.softwareSetUpdateStatus(model.softwareSetUpdateStatus);
            this.lastConnectedAt(model.lastConnectedAt);
            this.lastPostureAt(model.lastPostureAt);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.arn(model.arn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCurrentSoftwareSetId() {
            return this.currentSoftwareSetId;
        }

        public final void setCurrentSoftwareSetId(String currentSoftwareSetId) {
            this.currentSoftwareSetId = currentSoftwareSetId;
        }

        @Override
        public final Builder currentSoftwareSetId(String currentSoftwareSetId) {
            this.currentSoftwareSetId = currentSoftwareSetId;
            return this;
        }

        public final String getCurrentSoftwareSetVersion() {
            return this.currentSoftwareSetVersion;
        }

        public final void setCurrentSoftwareSetVersion(String currentSoftwareSetVersion) {
            this.currentSoftwareSetVersion = currentSoftwareSetVersion;
        }

        @Override
        public final Builder currentSoftwareSetVersion(String currentSoftwareSetVersion) {
            this.currentSoftwareSetVersion = currentSoftwareSetVersion;
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return this.desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetId() {
            return this.pendingSoftwareSetId;
        }

        public final void setPendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
        }

        @Override
        public final Builder pendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetVersion() {
            return this.pendingSoftwareSetVersion;
        }

        public final void setPendingSoftwareSetVersion(String pendingSoftwareSetVersion) {
            this.pendingSoftwareSetVersion = pendingSoftwareSetVersion;
        }

        @Override
        public final Builder pendingSoftwareSetVersion(String pendingSoftwareSetVersion) {
            this.pendingSoftwareSetVersion = pendingSoftwareSetVersion;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return this.softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final String getSoftwareSetComplianceStatus() {
            return this.softwareSetComplianceStatus;
        }

        public final void setSoftwareSetComplianceStatus(String softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus = softwareSetComplianceStatus;
        }

        @Override
        public final Builder softwareSetComplianceStatus(String softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus = softwareSetComplianceStatus;
            return this;
        }

        @Override
        public final Builder softwareSetComplianceStatus(DeviceSoftwareSetComplianceStatus softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus(softwareSetComplianceStatus == null ? null : softwareSetComplianceStatus.toString());
            return this;
        }

        public final String getSoftwareSetUpdateStatus() {
            return this.softwareSetUpdateStatus;
        }

        public final void setSoftwareSetUpdateStatus(String softwareSetUpdateStatus) {
            this.softwareSetUpdateStatus = softwareSetUpdateStatus;
        }

        @Override
        public final Builder softwareSetUpdateStatus(String softwareSetUpdateStatus) {
            this.softwareSetUpdateStatus = softwareSetUpdateStatus;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateStatus(SoftwareSetUpdateStatus softwareSetUpdateStatus) {
            this.softwareSetUpdateStatus(softwareSetUpdateStatus == null ? null : softwareSetUpdateStatus.toString());
            return this;
        }

        public final Instant getLastConnectedAt() {
            return this.lastConnectedAt;
        }

        public final void setLastConnectedAt(Instant lastConnectedAt) {
            this.lastConnectedAt = lastConnectedAt;
        }

        @Override
        public final Builder lastConnectedAt(Instant lastConnectedAt) {
            this.lastConnectedAt = lastConnectedAt;
            return this;
        }

        public final Instant getLastPostureAt() {
            return this.lastPostureAt;
        }

        public final void setLastPostureAt(Instant lastPostureAt) {
            this.lastPostureAt = lastPostureAt;
        }

        @Override
        public final Builder lastPostureAt(Instant lastPostureAt) {
            this.lastPostureAt = lastPostureAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder id(String var1);

        public Builder serialNumber(String var1);

        public Builder name(String var1);

        public Builder model(String var1);

        public Builder environmentId(String var1);

        public Builder status(String var1);

        public Builder status(DeviceStatus var1);

        public Builder currentSoftwareSetId(String var1);

        public Builder currentSoftwareSetVersion(String var1);

        public Builder desiredSoftwareSetId(String var1);

        public Builder pendingSoftwareSetId(String var1);

        public Builder pendingSoftwareSetVersion(String var1);

        public Builder softwareSetUpdateSchedule(String var1);

        public Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule var1);

        public Builder softwareSetComplianceStatus(String var1);

        public Builder softwareSetComplianceStatus(DeviceSoftwareSetComplianceStatus var1);

        public Builder softwareSetUpdateStatus(String var1);

        public Builder softwareSetUpdateStatus(SoftwareSetUpdateStatus var1);

        public Builder lastConnectedAt(Instant var1);

        public Builder lastPostureAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder arn(String var1);

        public Builder kmsKeyArn(String var1);

        @Deprecated
        public Builder tags(Map<String, String> var1);
    }
}

