/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateSchedule;
import software.amazon.awssdk.services.workspacesthinclient.model.WorkSpacesThinClientRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeviceRequest
extends WorkSpacesThinClientRequest
implements ToCopyableBuilder<Builder, UpdateDeviceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateDeviceRequest.getter(UpdateDeviceRequest::id)).setter(UpdateDeviceRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDeviceRequest.getter(UpdateDeviceRequest::name)).setter(UpdateDeviceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredSoftwareSetId").getter(UpdateDeviceRequest.getter(UpdateDeviceRequest::desiredSoftwareSetId)).setter(UpdateDeviceRequest.setter(Builder::desiredSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateSchedule").getter(UpdateDeviceRequest.getter(UpdateDeviceRequest::softwareSetUpdateScheduleAsString)).setter(UpdateDeviceRequest.setter(Builder::softwareSetUpdateSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESIRED_SOFTWARE_SET_ID_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDeviceRequest.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String desiredSoftwareSetId;
    private final String softwareSetUpdateSchedule;

    private UpdateDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String desiredSoftwareSetId() {
        return this.desiredSoftwareSetId;
    }

    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(this.softwareSetUpdateSchedule);
    }

    public final String softwareSetUpdateScheduleAsString() {
        return this.softwareSetUpdateSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateScheduleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceRequest)) {
            return false;
        }
        UpdateDeviceRequest other = (UpdateDeviceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.desiredSoftwareSetId(), other.desiredSoftwareSetId()) && Objects.equals(this.softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeviceRequest").add("Id", (Object)this.id()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("DesiredSoftwareSetId", (Object)this.desiredSoftwareSetId()).add("SoftwareSetUpdateSchedule", (Object)this.softwareSetUpdateScheduleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "desiredSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.desiredSoftwareSetId()));
            }
            case "softwareSetUpdateSchedule": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateScheduleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("desiredSoftwareSetId", DESIRED_SOFTWARE_SET_ID_FIELD);
        map.put("softwareSetUpdateSchedule", SOFTWARE_SET_UPDATE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceRequest, T> g) {
        return obj -> g.apply((UpdateDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesThinClientRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String desiredSoftwareSetId;
        private String softwareSetUpdateSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.desiredSoftwareSetId(model.desiredSoftwareSetId);
            this.softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return this.desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return this.softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceRequest build() {
            return new UpdateDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesThinClientRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeviceRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder desiredSoftwareSetId(String var1);

        public Builder softwareSetUpdateSchedule(String var1);

        public Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

