/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetValidationStatus;
import software.amazon.awssdk.services.workspacesthinclient.model.WorkSpacesThinClientRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSoftwareSetRequest
extends WorkSpacesThinClientRequest
implements ToCopyableBuilder<Builder, UpdateSoftwareSetRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateSoftwareSetRequest.getter(UpdateSoftwareSetRequest::id)).setter(UpdateSoftwareSetRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationStatus").getter(UpdateSoftwareSetRequest.getter(UpdateSoftwareSetRequest::validationStatusAsString)).setter(UpdateSoftwareSetRequest.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VALIDATION_STATUS_FIELD));
    private final String id;
    private final String validationStatus;

    private UpdateSoftwareSetRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.validationStatus = builder.validationStatus;
    }

    public final String id() {
        return this.id;
    }

    public final SoftwareSetValidationStatus validationStatus() {
        return SoftwareSetValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSoftwareSetRequest)) {
            return false;
        }
        UpdateSoftwareSetRequest other = (UpdateSoftwareSetRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSoftwareSetRequest").add("Id", (Object)this.id()).add("ValidationStatus", (Object)this.validationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSoftwareSetRequest, T> g) {
        return obj -> g.apply((UpdateSoftwareSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesThinClientRequest.BuilderImpl
    implements Builder {
        private String id;
        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSoftwareSetRequest model) {
            super(model);
            this.id(model.id);
            this.validationStatus(model.validationStatus);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(SoftwareSetValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSoftwareSetRequest build() {
            return new UpdateSoftwareSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesThinClientRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSoftwareSetRequest> {
        public Builder id(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(SoftwareSetValidationStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

