/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesthinclient.model.DesktopType;
import software.amazon.awssdk.services.workspacesthinclient.model.EnvironmentSoftwareSetComplianceStatus;
import software.amazon.awssdk.services.workspacesthinclient.model.MaintenanceWindow;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateMode;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateSchedule;
import software.amazon.awssdk.services.workspacesthinclient.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Environment.getter(Environment::id)).setter(Environment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Environment.getter(Environment::name)).setter(Environment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESKTOP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopArn").getter(Environment.getter(Environment::desktopArn)).setter(Environment.setter(Builder::desktopArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopArn").build()}).build();
    private static final SdkField<String> DESKTOP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopEndpoint").getter(Environment.getter(Environment::desktopEndpoint)).setter(Environment.setter(Builder::desktopEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopEndpoint").build()}).build();
    private static final SdkField<String> DESKTOP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopType").getter(Environment.getter(Environment::desktopTypeAsString)).setter(Environment.setter(Builder::desktopType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopType").build()}).build();
    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activationCode").getter(Environment.getter(Environment::activationCode)).setter(Environment.setter(Builder::activationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationCode").build()}).build();
    private static final SdkField<Integer> REGISTERED_DEVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("registeredDevicesCount").getter(Environment.getter(Environment::registeredDevicesCount)).setter(Environment.setter(Builder::registeredDevicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredDevicesCount").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateSchedule").getter(Environment.getter(Environment::softwareSetUpdateScheduleAsString)).setter(Environment.setter(Builder::softwareSetUpdateSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(Environment.getter(Environment::maintenanceWindow)).setter(Environment.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateMode").getter(Environment.getter(Environment::softwareSetUpdateModeAsString)).setter(Environment.setter(Builder::softwareSetUpdateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateMode").build()}).build();
    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredSoftwareSetId").getter(Environment.getter(Environment::desiredSoftwareSetId)).setter(Environment.setter(Builder::desiredSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build()}).build();
    private static final SdkField<String> PENDING_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pendingSoftwareSetId").getter(Environment.getter(Environment::pendingSoftwareSetId)).setter(Environment.setter(Builder::pendingSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetId").build()}).build();
    private static final SdkField<String> PENDING_SOFTWARE_SET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pendingSoftwareSetVersion").getter(Environment.getter(Environment::pendingSoftwareSetVersion)).setter(Environment.setter(Builder::pendingSoftwareSetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetVersion").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetComplianceStatus").getter(Environment.getter(Environment::softwareSetComplianceStatusAsString)).setter(Environment.setter(Builder::softwareSetComplianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetComplianceStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Environment.getter(Environment::createdAt)).setter(Environment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Environment.getter(Environment::updatedAt)).setter(Environment.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Environment.getter(Environment::arn)).setter(Environment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(Environment.getter(Environment::kmsKeyArn)).setter(Environment.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Environment.getter(Environment::tags)).setter(Environment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESKTOP_ARN_FIELD, DESKTOP_ENDPOINT_FIELD, DESKTOP_TYPE_FIELD, ACTIVATION_CODE_FIELD, REGISTERED_DEVICES_COUNT_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, MAINTENANCE_WINDOW_FIELD, SOFTWARE_SET_UPDATE_MODE_FIELD, DESIRED_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_VERSION_FIELD, SOFTWARE_SET_COMPLIANCE_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ARN_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String desktopArn;
    private final String desktopEndpoint;
    private final String desktopType;
    private final String activationCode;
    private final Integer registeredDevicesCount;
    private final String softwareSetUpdateSchedule;
    private final MaintenanceWindow maintenanceWindow;
    private final String softwareSetUpdateMode;
    private final String desiredSoftwareSetId;
    private final String pendingSoftwareSetId;
    private final String pendingSoftwareSetVersion;
    private final String softwareSetComplianceStatus;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String arn;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private Environment(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.desktopArn = builder.desktopArn;
        this.desktopEndpoint = builder.desktopEndpoint;
        this.desktopType = builder.desktopType;
        this.activationCode = builder.activationCode;
        this.registeredDevicesCount = builder.registeredDevicesCount;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.pendingSoftwareSetId = builder.pendingSoftwareSetId;
        this.pendingSoftwareSetVersion = builder.pendingSoftwareSetVersion;
        this.softwareSetComplianceStatus = builder.softwareSetComplianceStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.arn = builder.arn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String desktopArn() {
        return this.desktopArn;
    }

    public final String desktopEndpoint() {
        return this.desktopEndpoint;
    }

    public final DesktopType desktopType() {
        return DesktopType.fromValue(this.desktopType);
    }

    public final String desktopTypeAsString() {
        return this.desktopType;
    }

    public final String activationCode() {
        return this.activationCode;
    }

    public final Integer registeredDevicesCount() {
        return this.registeredDevicesCount;
    }

    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(this.softwareSetUpdateSchedule);
    }

    public final String softwareSetUpdateScheduleAsString() {
        return this.softwareSetUpdateSchedule;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final SoftwareSetUpdateMode softwareSetUpdateMode() {
        return SoftwareSetUpdateMode.fromValue(this.softwareSetUpdateMode);
    }

    public final String softwareSetUpdateModeAsString() {
        return this.softwareSetUpdateMode;
    }

    public final String desiredSoftwareSetId() {
        return this.desiredSoftwareSetId;
    }

    public final String pendingSoftwareSetId() {
        return this.pendingSoftwareSetId;
    }

    public final String pendingSoftwareSetVersion() {
        return this.pendingSoftwareSetVersion;
    }

    public final EnvironmentSoftwareSetComplianceStatus softwareSetComplianceStatus() {
        return EnvironmentSoftwareSetComplianceStatus.fromValue(this.softwareSetComplianceStatus);
    }

    public final String softwareSetComplianceStatusAsString() {
        return this.softwareSetComplianceStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredDevicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingSoftwareSetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetComplianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.desktopArn(), other.desktopArn()) && Objects.equals(this.desktopEndpoint(), other.desktopEndpoint()) && Objects.equals(this.desktopTypeAsString(), other.desktopTypeAsString()) && Objects.equals(this.activationCode(), other.activationCode()) && Objects.equals(this.registeredDevicesCount(), other.registeredDevicesCount()) && Objects.equals(this.softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.softwareSetUpdateModeAsString(), other.softwareSetUpdateModeAsString()) && Objects.equals(this.desiredSoftwareSetId(), other.desiredSoftwareSetId()) && Objects.equals(this.pendingSoftwareSetId(), other.pendingSoftwareSetId()) && Objects.equals(this.pendingSoftwareSetVersion(), other.pendingSoftwareSetVersion()) && Objects.equals(this.softwareSetComplianceStatusAsString(), other.softwareSetComplianceStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("Id", (Object)this.id()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("DesktopArn", (Object)this.desktopArn()).add("DesktopEndpoint", (Object)(this.desktopEndpoint() == null ? null : "*** Sensitive Data Redacted ***")).add("DesktopType", (Object)this.desktopTypeAsString()).add("ActivationCode", (Object)this.activationCode()).add("RegisteredDevicesCount", (Object)this.registeredDevicesCount()).add("SoftwareSetUpdateSchedule", (Object)this.softwareSetUpdateScheduleAsString()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("SoftwareSetUpdateMode", (Object)this.softwareSetUpdateModeAsString()).add("DesiredSoftwareSetId", (Object)this.desiredSoftwareSetId()).add("PendingSoftwareSetId", (Object)this.pendingSoftwareSetId()).add("PendingSoftwareSetVersion", (Object)this.pendingSoftwareSetVersion()).add("SoftwareSetComplianceStatus", (Object)this.softwareSetComplianceStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Arn", (Object)this.arn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "desktopArn": {
                return Optional.ofNullable(clazz.cast(this.desktopArn()));
            }
            case "desktopEndpoint": {
                return Optional.ofNullable(clazz.cast(this.desktopEndpoint()));
            }
            case "desktopType": {
                return Optional.ofNullable(clazz.cast(this.desktopTypeAsString()));
            }
            case "activationCode": {
                return Optional.ofNullable(clazz.cast(this.activationCode()));
            }
            case "registeredDevicesCount": {
                return Optional.ofNullable(clazz.cast(this.registeredDevicesCount()));
            }
            case "softwareSetUpdateSchedule": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateScheduleAsString()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "softwareSetUpdateMode": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateModeAsString()));
            }
            case "desiredSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.desiredSoftwareSetId()));
            }
            case "pendingSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.pendingSoftwareSetId()));
            }
            case "pendingSoftwareSetVersion": {
                return Optional.ofNullable(clazz.cast(this.pendingSoftwareSetVersion()));
            }
            case "softwareSetComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.softwareSetComplianceStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String desktopArn;
        private String desktopEndpoint;
        private String desktopType;
        private String activationCode;
        private Integer registeredDevicesCount;
        private String softwareSetUpdateSchedule;
        private MaintenanceWindow maintenanceWindow;
        private String softwareSetUpdateMode;
        private String desiredSoftwareSetId;
        private String pendingSoftwareSetId;
        private String pendingSoftwareSetVersion;
        private String softwareSetComplianceStatus;
        private Instant createdAt;
        private Instant updatedAt;
        private String arn;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.id(model.id);
            this.name(model.name);
            this.desktopArn(model.desktopArn);
            this.desktopEndpoint(model.desktopEndpoint);
            this.desktopType(model.desktopType);
            this.activationCode(model.activationCode);
            this.registeredDevicesCount(model.registeredDevicesCount);
            this.softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            this.maintenanceWindow(model.maintenanceWindow);
            this.softwareSetUpdateMode(model.softwareSetUpdateMode);
            this.desiredSoftwareSetId(model.desiredSoftwareSetId);
            this.pendingSoftwareSetId(model.pendingSoftwareSetId);
            this.pendingSoftwareSetVersion(model.pendingSoftwareSetVersion);
            this.softwareSetComplianceStatus(model.softwareSetComplianceStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.arn(model.arn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesktopArn() {
            return this.desktopArn;
        }

        public final void setDesktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
        }

        @Override
        public final Builder desktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        public final String getDesktopEndpoint() {
            return this.desktopEndpoint;
        }

        public final void setDesktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
        }

        @Override
        public final Builder desktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        public final String getDesktopType() {
            return this.desktopType;
        }

        public final void setDesktopType(String desktopType) {
            this.desktopType = desktopType;
        }

        @Override
        public final Builder desktopType(String desktopType) {
            this.desktopType = desktopType;
            return this;
        }

        @Override
        public final Builder desktopType(DesktopType desktopType) {
            this.desktopType(desktopType == null ? null : desktopType.toString());
            return this;
        }

        public final String getActivationCode() {
            return this.activationCode;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final Integer getRegisteredDevicesCount() {
            return this.registeredDevicesCount;
        }

        public final void setRegisteredDevicesCount(Integer registeredDevicesCount) {
            this.registeredDevicesCount = registeredDevicesCount;
        }

        @Override
        public final Builder registeredDevicesCount(Integer registeredDevicesCount) {
            this.registeredDevicesCount = registeredDevicesCount;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return this.softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSoftwareSetUpdateMode() {
            return this.softwareSetUpdateMode;
        }

        public final void setSoftwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
        }

        @Override
        public final Builder softwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode) {
            this.softwareSetUpdateMode(softwareSetUpdateMode == null ? null : softwareSetUpdateMode.toString());
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return this.desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetId() {
            return this.pendingSoftwareSetId;
        }

        public final void setPendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
        }

        @Override
        public final Builder pendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetVersion() {
            return this.pendingSoftwareSetVersion;
        }

        public final void setPendingSoftwareSetVersion(String pendingSoftwareSetVersion) {
            this.pendingSoftwareSetVersion = pendingSoftwareSetVersion;
        }

        @Override
        public final Builder pendingSoftwareSetVersion(String pendingSoftwareSetVersion) {
            this.pendingSoftwareSetVersion = pendingSoftwareSetVersion;
            return this;
        }

        public final String getSoftwareSetComplianceStatus() {
            return this.softwareSetComplianceStatus;
        }

        public final void setSoftwareSetComplianceStatus(String softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus = softwareSetComplianceStatus;
        }

        @Override
        public final Builder softwareSetComplianceStatus(String softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus = softwareSetComplianceStatus;
            return this;
        }

        @Override
        public final Builder softwareSetComplianceStatus(EnvironmentSoftwareSetComplianceStatus softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus(softwareSetComplianceStatus == null ? null : softwareSetComplianceStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder desktopArn(String var1);

        public Builder desktopEndpoint(String var1);

        public Builder desktopType(String var1);

        public Builder desktopType(DesktopType var1);

        public Builder activationCode(String var1);

        public Builder registeredDevicesCount(Integer var1);

        public Builder softwareSetUpdateSchedule(String var1);

        public Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder softwareSetUpdateMode(String var1);

        public Builder softwareSetUpdateMode(SoftwareSetUpdateMode var1);

        public Builder desiredSoftwareSetId(String var1);

        public Builder pendingSoftwareSetId(String var1);

        public Builder pendingSoftwareSetVersion(String var1);

        public Builder softwareSetComplianceStatus(String var1);

        public Builder softwareSetComplianceStatus(EnvironmentSoftwareSetComplianceStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder arn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

