/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesthinclient.model.DeviceCreationTagsMapCopier;
import software.amazon.awssdk.services.workspacesthinclient.model.MaintenanceWindow;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateMode;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetUpdateSchedule;
import software.amazon.awssdk.services.workspacesthinclient.model.TagsMapCopier;
import software.amazon.awssdk.services.workspacesthinclient.model.WorkSpacesThinClientRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentRequest
extends WorkSpacesThinClientRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::name)).setter(CreateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESKTOP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopArn").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::desktopArn)).setter(CreateEnvironmentRequest.setter(Builder::desktopArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopArn").build()}).build();
    private static final SdkField<String> DESKTOP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desktopEndpoint").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::desktopEndpoint)).setter(CreateEnvironmentRequest.setter(Builder::desktopEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopEndpoint").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateSchedule").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::softwareSetUpdateScheduleAsString)).setter(CreateEnvironmentRequest.setter(Builder::softwareSetUpdateSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::maintenanceWindow)).setter(CreateEnvironmentRequest.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<String> SOFTWARE_SET_UPDATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("softwareSetUpdateMode").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::softwareSetUpdateModeAsString)).setter(CreateEnvironmentRequest.setter(Builder::softwareSetUpdateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateMode").build()}).build();
    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredSoftwareSetId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::desiredSoftwareSetId)).setter(CreateEnvironmentRequest.setter(Builder::desiredSoftwareSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::kmsKeyArn)).setter(CreateEnvironmentRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::clientToken)).setter(CreateEnvironmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::tags)).setter(CreateEnvironmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> DEVICE_CREATION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("deviceCreationTags").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::deviceCreationTags)).setter(CreateEnvironmentRequest.setter(Builder::deviceCreationTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCreationTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESKTOP_ARN_FIELD, DESKTOP_ENDPOINT_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, MAINTENANCE_WINDOW_FIELD, SOFTWARE_SET_UPDATE_MODE_FIELD, DESIRED_SOFTWARE_SET_ID_FIELD, KMS_KEY_ARN_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, DEVICE_CREATION_TAGS_FIELD));
    private final String name;
    private final String desktopArn;
    private final String desktopEndpoint;
    private final String softwareSetUpdateSchedule;
    private final MaintenanceWindow maintenanceWindow;
    private final String softwareSetUpdateMode;
    private final String desiredSoftwareSetId;
    private final String kmsKeyArn;
    private final String clientToken;
    private final Map<String, String> tags;
    private final Map<String, String> deviceCreationTags;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.desktopArn = builder.desktopArn;
        this.desktopEndpoint = builder.desktopEndpoint;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.deviceCreationTags = builder.deviceCreationTags;
    }

    public final String name() {
        return this.name;
    }

    public final String desktopArn() {
        return this.desktopArn;
    }

    public final String desktopEndpoint() {
        return this.desktopEndpoint;
    }

    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(this.softwareSetUpdateSchedule);
    }

    public final String softwareSetUpdateScheduleAsString() {
        return this.softwareSetUpdateSchedule;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final SoftwareSetUpdateMode softwareSetUpdateMode() {
        return SoftwareSetUpdateMode.fromValue(this.softwareSetUpdateMode);
    }

    public final String softwareSetUpdateModeAsString() {
        return this.softwareSetUpdateMode;
    }

    public final String desiredSoftwareSetId() {
        return this.desiredSoftwareSetId;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasDeviceCreationTags() {
        return this.deviceCreationTags != null && !(this.deviceCreationTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> deviceCreationTags() {
        return this.deviceCreationTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desktopEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareSetUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceCreationTags() ? this.deviceCreationTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.desktopArn(), other.desktopArn()) && Objects.equals(this.desktopEndpoint(), other.desktopEndpoint()) && Objects.equals(this.softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.softwareSetUpdateModeAsString(), other.softwareSetUpdateModeAsString()) && Objects.equals(this.desiredSoftwareSetId(), other.desiredSoftwareSetId()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasDeviceCreationTags() == other.hasDeviceCreationTags() && Objects.equals(this.deviceCreationTags(), other.deviceCreationTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("DesktopArn", (Object)this.desktopArn()).add("DesktopEndpoint", (Object)(this.desktopEndpoint() == null ? null : "*** Sensitive Data Redacted ***")).add("SoftwareSetUpdateSchedule", (Object)this.softwareSetUpdateScheduleAsString()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("SoftwareSetUpdateMode", (Object)this.softwareSetUpdateModeAsString()).add("DesiredSoftwareSetId", (Object)this.desiredSoftwareSetId()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("ClientToken", (Object)this.clientToken()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("DeviceCreationTags", (Object)(this.deviceCreationTags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "desktopArn": {
                return Optional.ofNullable(clazz.cast(this.desktopArn()));
            }
            case "desktopEndpoint": {
                return Optional.ofNullable(clazz.cast(this.desktopEndpoint()));
            }
            case "softwareSetUpdateSchedule": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateScheduleAsString()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "softwareSetUpdateMode": {
                return Optional.ofNullable(clazz.cast(this.softwareSetUpdateModeAsString()));
            }
            case "desiredSoftwareSetId": {
                return Optional.ofNullable(clazz.cast(this.desiredSoftwareSetId()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "deviceCreationTags": {
                return Optional.ofNullable(clazz.cast(this.deviceCreationTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesThinClientRequest.BuilderImpl
    implements Builder {
        private String name;
        private String desktopArn;
        private String desktopEndpoint;
        private String softwareSetUpdateSchedule;
        private MaintenanceWindow maintenanceWindow;
        private String softwareSetUpdateMode;
        private String desiredSoftwareSetId;
        private String kmsKeyArn;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> deviceCreationTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            this.name(model.name);
            this.desktopArn(model.desktopArn);
            this.desktopEndpoint(model.desktopEndpoint);
            this.softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            this.maintenanceWindow(model.maintenanceWindow);
            this.softwareSetUpdateMode(model.softwareSetUpdateMode);
            this.desiredSoftwareSetId(model.desiredSoftwareSetId);
            this.kmsKeyArn(model.kmsKeyArn);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.deviceCreationTags(model.deviceCreationTags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesktopArn() {
            return this.desktopArn;
        }

        public final void setDesktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
        }

        @Override
        public final Builder desktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        public final String getDesktopEndpoint() {
            return this.desktopEndpoint;
        }

        public final void setDesktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
        }

        @Override
        public final Builder desktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return this.softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSoftwareSetUpdateMode() {
            return this.softwareSetUpdateMode;
        }

        public final void setSoftwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
        }

        @Override
        public final Builder softwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode) {
            this.softwareSetUpdateMode(softwareSetUpdateMode == null ? null : softwareSetUpdateMode.toString());
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return this.desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getDeviceCreationTags() {
            if (this.deviceCreationTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.deviceCreationTags;
        }

        public final void setDeviceCreationTags(Map<String, String> deviceCreationTags) {
            this.deviceCreationTags = DeviceCreationTagsMapCopier.copy(deviceCreationTags);
        }

        @Override
        public final Builder deviceCreationTags(Map<String, String> deviceCreationTags) {
            this.deviceCreationTags = DeviceCreationTagsMapCopier.copy(deviceCreationTags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesThinClientRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder name(String var1);

        public Builder desktopArn(String var1);

        public Builder desktopEndpoint(String var1);

        public Builder softwareSetUpdateSchedule(String var1);

        public Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder softwareSetUpdateMode(String var1);

        public Builder softwareSetUpdateMode(SoftwareSetUpdateMode var1);

        public Builder desiredSoftwareSetId(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder deviceCreationTags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

