/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DesktopType {
    WORKSPACES("workspaces"),
    APPSTREAM("appstream"),
    WORKSPACES_WEB("workspaces-web"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DesktopType> VALUE_MAP;
    private final String value;

    private DesktopType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DesktopType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DesktopType> knownValues() {
        EnumSet<DesktopType> knownValues = EnumSet.allOf(DesktopType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DesktopType.class, DesktopType::toString);
    }
}

