/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesinstances.model.ProvisionStateEnum;
import software.amazon.awssdk.services.workspacesinstances.model.ProvisionStatesCopier;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspacesInstancesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspaceInstancesRequest
extends WorkspacesInstancesRequest
implements ToCopyableBuilder<Builder, ListWorkspaceInstancesRequest> {
    private static final SdkField<List<String>> PROVISION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionStates").getter(ListWorkspaceInstancesRequest.getter(ListWorkspaceInstancesRequest::provisionStatesAsStrings)).setter(ListWorkspaceInstancesRequest.setter(Builder::provisionStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListWorkspaceInstancesRequest.getter(ListWorkspaceInstancesRequest::maxResults)).setter(ListWorkspaceInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkspaceInstancesRequest.getter(ListWorkspaceInstancesRequest::nextToken)).setter(ListWorkspaceInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISION_STATES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkspaceInstancesRequest.memberNameToFieldInitializer();
    private final List<String> provisionStates;
    private final Integer maxResults;
    private final String nextToken;

    private ListWorkspaceInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.provisionStates = builder.provisionStates;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final List<ProvisionStateEnum> provisionStates() {
        return ProvisionStatesCopier.copyStringToEnum(this.provisionStates);
    }

    public final boolean hasProvisionStates() {
        return this.provisionStates != null && !(this.provisionStates instanceof SdkAutoConstructList);
    }

    public final List<String> provisionStatesAsStrings() {
        return this.provisionStates;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionStates() ? this.provisionStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceInstancesRequest)) {
            return false;
        }
        ListWorkspaceInstancesRequest other = (ListWorkspaceInstancesRequest)((Object)obj);
        return this.hasProvisionStates() == other.hasProvisionStates() && Objects.equals(this.provisionStatesAsStrings(), other.provisionStatesAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspaceInstancesRequest").add("ProvisionStates", this.hasProvisionStates() ? this.provisionStatesAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionStates": {
                return Optional.ofNullable(clazz.cast(this.provisionStatesAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisionStates", PROVISION_STATES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceInstancesRequest, T> g) {
        return obj -> g.apply((ListWorkspaceInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkspacesInstancesRequest.BuilderImpl
    implements Builder {
        private List<String> provisionStates = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceInstancesRequest model) {
            super(model);
            this.provisionStatesWithStrings(model.provisionStates);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProvisionStates() {
            if (this.provisionStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.provisionStates;
        }

        public final void setProvisionStates(Collection<String> provisionStates) {
            this.provisionStates = ProvisionStatesCopier.copy(provisionStates);
        }

        @Override
        public final Builder provisionStatesWithStrings(Collection<String> provisionStates) {
            this.provisionStates = ProvisionStatesCopier.copy(provisionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionStatesWithStrings(String ... provisionStates) {
            this.provisionStatesWithStrings(Arrays.asList(provisionStates));
            return this;
        }

        @Override
        public final Builder provisionStates(Collection<ProvisionStateEnum> provisionStates) {
            this.provisionStates = ProvisionStatesCopier.copyEnumToString(provisionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionStates(ProvisionStateEnum ... provisionStates) {
            this.provisionStates(Arrays.asList(provisionStates));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkspaceInstancesRequest build() {
            return new ListWorkspaceInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkspacesInstancesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspaceInstancesRequest> {
        public Builder provisionStatesWithStrings(Collection<String> var1);

        public Builder provisionStatesWithStrings(String ... var1);

        public Builder provisionStates(Collection<ProvisionStateEnum> var1);

        public Builder provisionStates(ProvisionStateEnum ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

