/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides comprehensive details about the requested WorkSpaces Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkspaceInstanceResponse extends WorkspacesInstancesResponse implements
        ToCopyableBuilder<GetWorkspaceInstanceResponse.Builder, GetWorkspaceInstanceResponse> {
    private static final SdkField<List<WorkspaceInstanceError>> WORKSPACE_INSTANCE_ERRORS_FIELD = SdkField
            .<List<WorkspaceInstanceError>> builder(MarshallingType.LIST)
            .memberName("WorkspaceInstanceErrors")
            .getter(getter(GetWorkspaceInstanceResponse::workspaceInstanceErrors))
            .setter(setter(Builder::workspaceInstanceErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceInstanceError> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceInstanceError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EC2InstanceError>> EC2_INSTANCE_ERRORS_FIELD = SdkField
            .<List<EC2InstanceError>> builder(MarshallingType.LIST)
            .memberName("EC2InstanceErrors")
            .getter(getter(GetWorkspaceInstanceResponse::ec2InstanceErrors))
            .setter(setter(Builder::ec2InstanceErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2InstanceError> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2InstanceError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVISION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionState").getter(getter(GetWorkspaceInstanceResponse::provisionStateAsString))
            .setter(setter(Builder::provisionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionState").build()).build();

    private static final SdkField<String> WORKSPACE_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceInstanceId").getter(getter(GetWorkspaceInstanceResponse::workspaceInstanceId))
            .setter(setter(Builder::workspaceInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceId").build())
            .build();

    private static final SdkField<EC2ManagedInstance> EC2_MANAGED_INSTANCE_FIELD = SdkField
            .<EC2ManagedInstance> builder(MarshallingType.SDK_POJO).memberName("EC2ManagedInstance")
            .getter(getter(GetWorkspaceInstanceResponse::ec2ManagedInstance)).setter(setter(Builder::ec2ManagedInstance))
            .constructor(EC2ManagedInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ManagedInstance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WORKSPACE_INSTANCE_ERRORS_FIELD, EC2_INSTANCE_ERRORS_FIELD, PROVISION_STATE_FIELD, WORKSPACE_INSTANCE_ID_FIELD,
            EC2_MANAGED_INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkspaceInstanceError> workspaceInstanceErrors;

    private final List<EC2InstanceError> ec2InstanceErrors;

    private final String provisionState;

    private final String workspaceInstanceId;

    private final EC2ManagedInstance ec2ManagedInstance;

    private GetWorkspaceInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceInstanceErrors = builder.workspaceInstanceErrors;
        this.ec2InstanceErrors = builder.ec2InstanceErrors;
        this.provisionState = builder.provisionState;
        this.workspaceInstanceId = builder.workspaceInstanceId;
        this.ec2ManagedInstance = builder.ec2ManagedInstance;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceInstanceErrors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkspaceInstanceErrors() {
        return workspaceInstanceErrors != null && !(workspaceInstanceErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Captures any errors specific to the WorkSpace Instance lifecycle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceInstanceErrors} method.
     * </p>
     * 
     * @return Captures any errors specific to the WorkSpace Instance lifecycle.
     */
    public final List<WorkspaceInstanceError> workspaceInstanceErrors() {
        return workspaceInstanceErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2InstanceErrors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceErrors() {
        return ec2InstanceErrors != null && !(ec2InstanceErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Includes any underlying EC2 instance errors encountered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceErrors} method.
     * </p>
     * 
     * @return Includes any underlying EC2 instance errors encountered.
     */
    public final List<EC2InstanceError> ec2InstanceErrors() {
        return ec2InstanceErrors;
    }

    /**
     * <p>
     * Current provisioning state of the WorkSpaces Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisionState}
     * will return {@link ProvisionStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisionStateAsString}.
     * </p>
     * 
     * @return Current provisioning state of the WorkSpaces Instance.
     * @see ProvisionStateEnum
     */
    public final ProvisionStateEnum provisionState() {
        return ProvisionStateEnum.fromValue(provisionState);
    }

    /**
     * <p>
     * Current provisioning state of the WorkSpaces Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisionState}
     * will return {@link ProvisionStateEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisionStateAsString}.
     * </p>
     * 
     * @return Current provisioning state of the WorkSpaces Instance.
     * @see ProvisionStateEnum
     */
    public final String provisionStateAsString() {
        return provisionState;
    }

    /**
     * <p>
     * Unique identifier of the retrieved WorkSpaces Instance.
     * </p>
     * 
     * @return Unique identifier of the retrieved WorkSpaces Instance.
     */
    public final String workspaceInstanceId() {
        return workspaceInstanceId;
    }

    /**
     * <p>
     * Details of the associated EC2 managed instance.
     * </p>
     * 
     * @return Details of the associated EC2 managed instance.
     */
    public final EC2ManagedInstance ec2ManagedInstance() {
        return ec2ManagedInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceInstanceErrors() ? workspaceInstanceErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceErrors() ? ec2InstanceErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ManagedInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkspaceInstanceResponse)) {
            return false;
        }
        GetWorkspaceInstanceResponse other = (GetWorkspaceInstanceResponse) obj;
        return hasWorkspaceInstanceErrors() == other.hasWorkspaceInstanceErrors()
                && Objects.equals(workspaceInstanceErrors(), other.workspaceInstanceErrors())
                && hasEc2InstanceErrors() == other.hasEc2InstanceErrors()
                && Objects.equals(ec2InstanceErrors(), other.ec2InstanceErrors())
                && Objects.equals(provisionStateAsString(), other.provisionStateAsString())
                && Objects.equals(workspaceInstanceId(), other.workspaceInstanceId())
                && Objects.equals(ec2ManagedInstance(), other.ec2ManagedInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkspaceInstanceResponse")
                .add("WorkspaceInstanceErrors", hasWorkspaceInstanceErrors() ? workspaceInstanceErrors() : null)
                .add("EC2InstanceErrors", hasEc2InstanceErrors() ? ec2InstanceErrors() : null)
                .add("ProvisionState", provisionStateAsString()).add("WorkspaceInstanceId", workspaceInstanceId())
                .add("EC2ManagedInstance", ec2ManagedInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceInstanceErrors":
            return Optional.ofNullable(clazz.cast(workspaceInstanceErrors()));
        case "EC2InstanceErrors":
            return Optional.ofNullable(clazz.cast(ec2InstanceErrors()));
        case "ProvisionState":
            return Optional.ofNullable(clazz.cast(provisionStateAsString()));
        case "WorkspaceInstanceId":
            return Optional.ofNullable(clazz.cast(workspaceInstanceId()));
        case "EC2ManagedInstance":
            return Optional.ofNullable(clazz.cast(ec2ManagedInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceInstanceErrors", WORKSPACE_INSTANCE_ERRORS_FIELD);
        map.put("EC2InstanceErrors", EC2_INSTANCE_ERRORS_FIELD);
        map.put("ProvisionState", PROVISION_STATE_FIELD);
        map.put("WorkspaceInstanceId", WORKSPACE_INSTANCE_ID_FIELD);
        map.put("EC2ManagedInstance", EC2_MANAGED_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkspaceInstanceResponse, T> g) {
        return obj -> g.apply((GetWorkspaceInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkspacesInstancesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkspaceInstanceResponse> {
        /**
         * <p>
         * Captures any errors specific to the WorkSpace Instance lifecycle.
         * </p>
         * 
         * @param workspaceInstanceErrors
         *        Captures any errors specific to the WorkSpace Instance lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceInstanceErrors(Collection<WorkspaceInstanceError> workspaceInstanceErrors);

        /**
         * <p>
         * Captures any errors specific to the WorkSpace Instance lifecycle.
         * </p>
         * 
         * @param workspaceInstanceErrors
         *        Captures any errors specific to the WorkSpace Instance lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceInstanceErrors(WorkspaceInstanceError... workspaceInstanceErrors);

        /**
         * <p>
         * Captures any errors specific to the WorkSpace Instance lifecycle.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstanceError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstanceError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstanceError.Builder#build()} is
         * called immediately and its result is passed to {@link #workspaceInstanceErrors(List<WorkspaceInstanceError>)}.
         * 
         * @param workspaceInstanceErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstanceError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceInstanceErrors(java.util.Collection<WorkspaceInstanceError>)
         */
        Builder workspaceInstanceErrors(Consumer<WorkspaceInstanceError.Builder>... workspaceInstanceErrors);

        /**
         * <p>
         * Includes any underlying EC2 instance errors encountered.
         * </p>
         * 
         * @param ec2InstanceErrors
         *        Includes any underlying EC2 instance errors encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceErrors(Collection<EC2InstanceError> ec2InstanceErrors);

        /**
         * <p>
         * Includes any underlying EC2 instance errors encountered.
         * </p>
         * 
         * @param ec2InstanceErrors
         *        Includes any underlying EC2 instance errors encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceErrors(EC2InstanceError... ec2InstanceErrors);

        /**
         * <p>
         * Includes any underlying EC2 instance errors encountered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesinstances.model.EC2InstanceError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workspacesinstances.model.EC2InstanceError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesinstances.model.EC2InstanceError.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2InstanceErrors(List<EC2InstanceError>)}.
         * 
         * @param ec2InstanceErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesinstances.model.EC2InstanceError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceErrors(java.util.Collection<EC2InstanceError>)
         */
        Builder ec2InstanceErrors(Consumer<EC2InstanceError.Builder>... ec2InstanceErrors);

        /**
         * <p>
         * Current provisioning state of the WorkSpaces Instance.
         * </p>
         * 
         * @param provisionState
         *        Current provisioning state of the WorkSpaces Instance.
         * @see ProvisionStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionStateEnum
         */
        Builder provisionState(String provisionState);

        /**
         * <p>
         * Current provisioning state of the WorkSpaces Instance.
         * </p>
         * 
         * @param provisionState
         *        Current provisioning state of the WorkSpaces Instance.
         * @see ProvisionStateEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionStateEnum
         */
        Builder provisionState(ProvisionStateEnum provisionState);

        /**
         * <p>
         * Unique identifier of the retrieved WorkSpaces Instance.
         * </p>
         * 
         * @param workspaceInstanceId
         *        Unique identifier of the retrieved WorkSpaces Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceInstanceId(String workspaceInstanceId);

        /**
         * <p>
         * Details of the associated EC2 managed instance.
         * </p>
         * 
         * @param ec2ManagedInstance
         *        Details of the associated EC2 managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ManagedInstance(EC2ManagedInstance ec2ManagedInstance);

        /**
         * <p>
         * Details of the associated EC2 managed instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link EC2ManagedInstance.Builder} avoiding the
         * need to create one manually via {@link EC2ManagedInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EC2ManagedInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2ManagedInstance(EC2ManagedInstance)}.
         * 
         * @param ec2ManagedInstance
         *        a consumer that will call methods on {@link EC2ManagedInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2ManagedInstance(EC2ManagedInstance)
         */
        default Builder ec2ManagedInstance(Consumer<EC2ManagedInstance.Builder> ec2ManagedInstance) {
            return ec2ManagedInstance(EC2ManagedInstance.builder().applyMutation(ec2ManagedInstance).build());
        }
    }

    static final class BuilderImpl extends WorkspacesInstancesResponse.BuilderImpl implements Builder {
        private List<WorkspaceInstanceError> workspaceInstanceErrors = DefaultSdkAutoConstructList.getInstance();

        private List<EC2InstanceError> ec2InstanceErrors = DefaultSdkAutoConstructList.getInstance();

        private String provisionState;

        private String workspaceInstanceId;

        private EC2ManagedInstance ec2ManagedInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkspaceInstanceResponse model) {
            super(model);
            workspaceInstanceErrors(model.workspaceInstanceErrors);
            ec2InstanceErrors(model.ec2InstanceErrors);
            provisionState(model.provisionState);
            workspaceInstanceId(model.workspaceInstanceId);
            ec2ManagedInstance(model.ec2ManagedInstance);
        }

        public final List<WorkspaceInstanceError.Builder> getWorkspaceInstanceErrors() {
            List<WorkspaceInstanceError.Builder> result = WorkspaceInstanceErrorsCopier
                    .copyToBuilder(this.workspaceInstanceErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaceInstanceErrors(Collection<WorkspaceInstanceError.BuilderImpl> workspaceInstanceErrors) {
            this.workspaceInstanceErrors = WorkspaceInstanceErrorsCopier.copyFromBuilder(workspaceInstanceErrors);
        }

        @Override
        public final Builder workspaceInstanceErrors(Collection<WorkspaceInstanceError> workspaceInstanceErrors) {
            this.workspaceInstanceErrors = WorkspaceInstanceErrorsCopier.copy(workspaceInstanceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceInstanceErrors(WorkspaceInstanceError... workspaceInstanceErrors) {
            workspaceInstanceErrors(Arrays.asList(workspaceInstanceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceInstanceErrors(Consumer<WorkspaceInstanceError.Builder>... workspaceInstanceErrors) {
            workspaceInstanceErrors(Stream.of(workspaceInstanceErrors)
                    .map(c -> WorkspaceInstanceError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EC2InstanceError.Builder> getEc2InstanceErrors() {
            List<EC2InstanceError.Builder> result = EC2InstanceErrorsCopier.copyToBuilder(this.ec2InstanceErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceErrors(Collection<EC2InstanceError.BuilderImpl> ec2InstanceErrors) {
            this.ec2InstanceErrors = EC2InstanceErrorsCopier.copyFromBuilder(ec2InstanceErrors);
        }

        @Override
        public final Builder ec2InstanceErrors(Collection<EC2InstanceError> ec2InstanceErrors) {
            this.ec2InstanceErrors = EC2InstanceErrorsCopier.copy(ec2InstanceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceErrors(EC2InstanceError... ec2InstanceErrors) {
            ec2InstanceErrors(Arrays.asList(ec2InstanceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceErrors(Consumer<EC2InstanceError.Builder>... ec2InstanceErrors) {
            ec2InstanceErrors(Stream.of(ec2InstanceErrors).map(c -> EC2InstanceError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProvisionState() {
            return provisionState;
        }

        public final void setProvisionState(String provisionState) {
            this.provisionState = provisionState;
        }

        @Override
        public final Builder provisionState(String provisionState) {
            this.provisionState = provisionState;
            return this;
        }

        @Override
        public final Builder provisionState(ProvisionStateEnum provisionState) {
            this.provisionState(provisionState == null ? null : provisionState.toString());
            return this;
        }

        public final String getWorkspaceInstanceId() {
            return workspaceInstanceId;
        }

        public final void setWorkspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
        }

        @Override
        public final Builder workspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        public final EC2ManagedInstance.Builder getEc2ManagedInstance() {
            return ec2ManagedInstance != null ? ec2ManagedInstance.toBuilder() : null;
        }

        public final void setEc2ManagedInstance(EC2ManagedInstance.BuilderImpl ec2ManagedInstance) {
            this.ec2ManagedInstance = ec2ManagedInstance != null ? ec2ManagedInstance.build() : null;
        }

        @Override
        public final Builder ec2ManagedInstance(EC2ManagedInstance ec2ManagedInstance) {
            this.ec2ManagedInstance = ec2ManagedInstance;
            return this;
        }

        @Override
        public GetWorkspaceInstanceResponse build() {
            return new GetWorkspaceInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
