/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines CPU credit configuration for burstable instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreditSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreditSpecificationRequest.Builder, CreditSpecificationRequest> {
    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CpuCredits").getter(getter(CreditSpecificationRequest::cpuCreditsAsString))
            .setter(setter(Builder::cpuCredits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_CREDITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cpuCredits;

    private CreditSpecificationRequest(BuilderImpl builder) {
        this.cpuCredits = builder.cpuCredits;
    }

    /**
     * <p>
     * CPU credit specification mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cpuCredits} will
     * return {@link CpuCreditsEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cpuCreditsAsString}.
     * </p>
     * 
     * @return CPU credit specification mode.
     * @see CpuCreditsEnum
     */
    public final CpuCreditsEnum cpuCredits() {
        return CpuCreditsEnum.fromValue(cpuCredits);
    }

    /**
     * <p>
     * CPU credit specification mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cpuCredits} will
     * return {@link CpuCreditsEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cpuCreditsAsString}.
     * </p>
     * 
     * @return CPU credit specification mode.
     * @see CpuCreditsEnum
     */
    public final String cpuCreditsAsString() {
        return cpuCredits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpuCreditsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreditSpecificationRequest)) {
            return false;
        }
        CreditSpecificationRequest other = (CreditSpecificationRequest) obj;
        return Objects.equals(cpuCreditsAsString(), other.cpuCreditsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreditSpecificationRequest").add("CpuCredits", cpuCreditsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CpuCredits":
            return Optional.ofNullable(clazz.cast(cpuCreditsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CpuCredits", CPU_CREDITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreditSpecificationRequest, T> g) {
        return obj -> g.apply((CreditSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreditSpecificationRequest> {
        /**
         * <p>
         * CPU credit specification mode.
         * </p>
         * 
         * @param cpuCredits
         *        CPU credit specification mode.
         * @see CpuCreditsEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CpuCreditsEnum
         */
        Builder cpuCredits(String cpuCredits);

        /**
         * <p>
         * CPU credit specification mode.
         * </p>
         * 
         * @param cpuCredits
         *        CPU credit specification mode.
         * @see CpuCreditsEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CpuCreditsEnum
         */
        Builder cpuCredits(CpuCreditsEnum cpuCredits);
    }

    static final class BuilderImpl implements Builder {
        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(CreditSpecificationRequest model) {
            cpuCredits(model.cpuCredits);
        }

        public final String getCpuCredits() {
            return cpuCredits;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        @Override
        public final Builder cpuCredits(CpuCreditsEnum cpuCredits) {
            this.cpuCredits(cpuCredits == null ? null : cpuCredits.toString());
            return this;
        }

        @Override
        public CreditSpecificationRequest build() {
            return new CreditSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
