/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the unique identifier for the newly created WorkSpaces Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceInstanceResponse extends WorkspacesInstancesResponse implements
        ToCopyableBuilder<CreateWorkspaceInstanceResponse.Builder, CreateWorkspaceInstanceResponse> {
    private static final SdkField<String> WORKSPACE_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceInstanceId").getter(getter(CreateWorkspaceInstanceResponse::workspaceInstanceId))
            .setter(setter(Builder::workspaceInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceInstanceId;

    private CreateWorkspaceInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceInstanceId = builder.workspaceInstanceId;
    }

    /**
     * <p>
     * Unique identifier assigned to the newly created WorkSpaces Instance.
     * </p>
     * 
     * @return Unique identifier assigned to the newly created WorkSpaces Instance.
     */
    public final String workspaceInstanceId() {
        return workspaceInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceInstanceResponse)) {
            return false;
        }
        CreateWorkspaceInstanceResponse other = (CreateWorkspaceInstanceResponse) obj;
        return Objects.equals(workspaceInstanceId(), other.workspaceInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceInstanceResponse").add("WorkspaceInstanceId", workspaceInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceInstanceId":
            return Optional.ofNullable(clazz.cast(workspaceInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceInstanceId", WORKSPACE_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceInstanceResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkspacesInstancesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkspaceInstanceResponse> {
        /**
         * <p>
         * Unique identifier assigned to the newly created WorkSpaces Instance.
         * </p>
         * 
         * @param workspaceInstanceId
         *        Unique identifier assigned to the newly created WorkSpaces Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceInstanceId(String workspaceInstanceId);
    }

    static final class BuilderImpl extends WorkspacesInstancesResponse.BuilderImpl implements Builder {
        private String workspaceInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceInstanceResponse model) {
            super(model);
            workspaceInstanceId(model.workspaceInstanceId);
        }

        public final String getWorkspaceInstanceId() {
            return workspaceInstanceId;
        }

        public final void setWorkspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
        }

        @Override
        public final Builder workspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        @Override
        public CreateWorkspaceInstanceResponse build() {
            return new CreateWorkspaceInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
