/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines instance placement configuration for WorkSpace Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Placement implements SdkPojo, Serializable, ToCopyableBuilder<Placement.Builder, Placement> {
    private static final SdkField<String> AFFINITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Affinity").getter(getter(Placement::affinity)).setter(setter(Builder::affinity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Placement::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(Placement::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(Placement::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HostId")
            .getter(getter(Placement::hostId)).setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").build()).build();

    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostResourceGroupArn").getter(getter(Placement::hostResourceGroupArn))
            .setter(setter(Builder::hostResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn").build())
            .build();

    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionNumber").getter(getter(Placement::partitionNumber)).setter(setter(Builder::partitionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(Placement::tenancyAsString)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFINITY_FIELD,
            AVAILABILITY_ZONE_FIELD, GROUP_ID_FIELD, GROUP_NAME_FIELD, HOST_ID_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD,
            PARTITION_NUMBER_FIELD, TENANCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String affinity;

    private final String availabilityZone;

    private final String groupId;

    private final String groupName;

    private final String hostId;

    private final String hostResourceGroupArn;

    private final Integer partitionNumber;

    private final String tenancy;

    private Placement(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.availabilityZone = builder.availabilityZone;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
        this.partitionNumber = builder.partitionNumber;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * Specifies host affinity for dedicated instances.
     * </p>
     * 
     * @return Specifies host affinity for dedicated instances.
     */
    public final String affinity() {
        return affinity;
    }

    /**
     * <p>
     * Identifies the specific AWS availability zone.
     * </p>
     * 
     * @return Identifies the specific AWS availability zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Unique identifier for placement group.
     * </p>
     * 
     * @return Unique identifier for placement group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * Name of the placement group.
     * </p>
     * 
     * @return Name of the placement group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Identifies the specific dedicated host.
     * </p>
     * 
     * @return Identifies the specific dedicated host.
     */
    public final String hostId() {
        return hostId;
    }

    /**
     * <p>
     * ARN of the host resource group.
     * </p>
     * 
     * @return ARN of the host resource group.
     */
    public final String hostResourceGroupArn() {
        return hostResourceGroupArn;
    }

    /**
     * <p>
     * Specifies partition number for partition placement groups.
     * </p>
     * 
     * @return Specifies partition number for partition placement groups.
     */
    public final Integer partitionNumber() {
        return partitionNumber;
    }

    /**
     * <p>
     * Defines instance tenancy configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link TenancyEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Defines instance tenancy configuration.
     * @see TenancyEnum
     */
    public final TenancyEnum tenancy() {
        return TenancyEnum.fromValue(tenancy);
    }

    /**
     * <p>
     * Defines instance tenancy configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link TenancyEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Defines instance tenancy configuration.
     * @see TenancyEnum
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(affinity());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(hostResourceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement) obj;
        return Objects.equals(affinity(), other.affinity()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(hostId(), other.hostId())
                && Objects.equals(hostResourceGroupArn(), other.hostResourceGroupArn())
                && Objects.equals(partitionNumber(), other.partitionNumber())
                && Objects.equals(tenancyAsString(), other.tenancyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Placement").add("Affinity", affinity()).add("AvailabilityZone", availabilityZone())
                .add("GroupId", groupId()).add("GroupName", groupName()).add("HostId", hostId())
                .add("HostResourceGroupArn", hostResourceGroupArn()).add("PartitionNumber", partitionNumber())
                .add("Tenancy", tenancyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Affinity":
            return Optional.ofNullable(clazz.cast(affinity()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "HostResourceGroupArn":
            return Optional.ofNullable(clazz.cast(hostResourceGroupArn()));
        case "PartitionNumber":
            return Optional.ofNullable(clazz.cast(partitionNumber()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Affinity", AFFINITY_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("HostId", HOST_ID_FIELD);
        map.put("HostResourceGroupArn", HOST_RESOURCE_GROUP_ARN_FIELD);
        map.put("PartitionNumber", PARTITION_NUMBER_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Placement, T> g) {
        return obj -> g.apply((Placement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Placement> {
        /**
         * <p>
         * Specifies host affinity for dedicated instances.
         * </p>
         * 
         * @param affinity
         *        Specifies host affinity for dedicated instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * Identifies the specific AWS availability zone.
         * </p>
         * 
         * @param availabilityZone
         *        Identifies the specific AWS availability zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Unique identifier for placement group.
         * </p>
         * 
         * @param groupId
         *        Unique identifier for placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Name of the placement group.
         * </p>
         * 
         * @param groupName
         *        Name of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Identifies the specific dedicated host.
         * </p>
         * 
         * @param hostId
         *        Identifies the specific dedicated host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * ARN of the host resource group.
         * </p>
         * 
         * @param hostResourceGroupArn
         *        ARN of the host resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostResourceGroupArn(String hostResourceGroupArn);

        /**
         * <p>
         * Specifies partition number for partition placement groups.
         * </p>
         * 
         * @param partitionNumber
         *        Specifies partition number for partition placement groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionNumber(Integer partitionNumber);

        /**
         * <p>
         * Defines instance tenancy configuration.
         * </p>
         * 
         * @param tenancy
         *        Defines instance tenancy configuration.
         * @see TenancyEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TenancyEnum
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Defines instance tenancy configuration.
         * </p>
         * 
         * @param tenancy
         *        Defines instance tenancy configuration.
         * @see TenancyEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TenancyEnum
         */
        Builder tenancy(TenancyEnum tenancy);
    }

    static final class BuilderImpl implements Builder {
        private String affinity;

        private String availabilityZone;

        private String groupId;

        private String groupName;

        private String hostId;

        private String hostResourceGroupArn;

        private Integer partitionNumber;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            affinity(model.affinity);
            availabilityZone(model.availabilityZone);
            groupId(model.groupId);
            groupName(model.groupName);
            hostId(model.hostId);
            hostResourceGroupArn(model.hostResourceGroupArn);
            partitionNumber(model.partitionNumber);
            tenancy(model.tenancy);
        }

        public final String getAffinity() {
            return affinity;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getHostId() {
            return hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final Integer getPartitionNumber() {
            return partitionNumber;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(TenancyEnum tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        @Override
        public Placement build() {
            return new Placement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
