/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines hibernation configuration for the WorkSpace Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HibernationOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<HibernationOptionsRequest.Builder, HibernationOptionsRequest> {
    private static final SdkField<Boolean> CONFIGURED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Configured").getter(getter(HibernationOptionsRequest::configured)).setter(setter(Builder::configured))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configured").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean configured;

    private HibernationOptionsRequest(BuilderImpl builder) {
        this.configured = builder.configured;
    }

    /**
     * <p>
     * Enables or disables instance hibernation capability.
     * </p>
     * 
     * @return Enables or disables instance hibernation capability.
     */
    public final Boolean configured() {
        return configured;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configured());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HibernationOptionsRequest)) {
            return false;
        }
        HibernationOptionsRequest other = (HibernationOptionsRequest) obj;
        return Objects.equals(configured(), other.configured());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HibernationOptionsRequest").add("Configured", configured()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configured":
            return Optional.ofNullable(clazz.cast(configured()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Configured", CONFIGURED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HibernationOptionsRequest, T> g) {
        return obj -> g.apply((HibernationOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HibernationOptionsRequest> {
        /**
         * <p>
         * Enables or disables instance hibernation capability.
         * </p>
         * 
         * @param configured
         *        Enables or disables instance hibernation capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configured(Boolean configured);
    }

    static final class BuilderImpl implements Builder {
        private Boolean configured;

        private BuilderImpl() {
        }

        private BuilderImpl(HibernationOptionsRequest model) {
            configured(model.configured);
        }

        public final Boolean getConfigured() {
            return configured;
        }

        public final void setConfigured(Boolean configured) {
            this.configured = configured;
        }

        @Override
        public final Builder configured(Boolean configured) {
            this.configured = configured;
            return this;
        }

        @Override
        public HibernationOptionsRequest build() {
            return new HibernationOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
