/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesinstances.WorkspacesInstancesClient;
import software.amazon.awssdk.services.workspacesinstances.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceTypeInfo;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse;

public class ListInstanceTypesIterable
implements SdkIterable<ListInstanceTypesResponse> {
    private final WorkspacesInstancesClient client;
    private final ListInstanceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceTypesIterable(WorkspacesInstancesClient client, ListInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstanceTypesResponseFetcher();
    }

    public Iterator<ListInstanceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceTypeInfo> instanceTypes() {
        Function<ListInstanceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstanceTypesResponseFetcher
    implements SyncPageFetcher<ListInstanceTypesResponse> {
        private ListInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInstanceTypesResponse nextPage(ListInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceTypesIterable.this.client.listInstanceTypes(ListInstanceTypesIterable.this.firstRequest);
            }
            return ListInstanceTypesIterable.this.client.listInstanceTypes((ListInstanceTypesRequest)((Object)ListInstanceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

