/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesinstances.model.EC2InstanceError;
import software.amazon.awssdk.services.workspacesinstances.model.EC2InstanceErrorsCopier;
import software.amazon.awssdk.services.workspacesinstances.model.EC2ManagedInstance;
import software.amazon.awssdk.services.workspacesinstances.model.ProvisionStateEnum;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstanceError;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstanceErrorsCopier;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspacesInstancesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkspaceInstanceResponse
extends WorkspacesInstancesResponse
implements ToCopyableBuilder<Builder, GetWorkspaceInstanceResponse> {
    private static final SdkField<List<WorkspaceInstanceError>> WORKSPACE_INSTANCE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspaceInstanceErrors").getter(GetWorkspaceInstanceResponse.getter(GetWorkspaceInstanceResponse::workspaceInstanceErrors)).setter(GetWorkspaceInstanceResponse.setter(Builder::workspaceInstanceErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceInstanceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EC2InstanceError>> EC2_INSTANCE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2InstanceErrors").getter(GetWorkspaceInstanceResponse.getter(GetWorkspaceInstanceResponse::ec2InstanceErrors)).setter(GetWorkspaceInstanceResponse.setter(Builder::ec2InstanceErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2InstanceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVISION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionState").getter(GetWorkspaceInstanceResponse.getter(GetWorkspaceInstanceResponse::provisionStateAsString)).setter(GetWorkspaceInstanceResponse.setter(Builder::provisionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionState").build()}).build();
    private static final SdkField<String> WORKSPACE_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceInstanceId").getter(GetWorkspaceInstanceResponse.getter(GetWorkspaceInstanceResponse::workspaceInstanceId)).setter(GetWorkspaceInstanceResponse.setter(Builder::workspaceInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceId").build()}).build();
    private static final SdkField<EC2ManagedInstance> EC2_MANAGED_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2ManagedInstance").getter(GetWorkspaceInstanceResponse.getter(GetWorkspaceInstanceResponse::ec2ManagedInstance)).setter(GetWorkspaceInstanceResponse.setter(Builder::ec2ManagedInstance)).constructor(EC2ManagedInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ManagedInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_INSTANCE_ERRORS_FIELD, EC2_INSTANCE_ERRORS_FIELD, PROVISION_STATE_FIELD, WORKSPACE_INSTANCE_ID_FIELD, EC2_MANAGED_INSTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkspaceInstanceResponse.memberNameToFieldInitializer();
    private final List<WorkspaceInstanceError> workspaceInstanceErrors;
    private final List<EC2InstanceError> ec2InstanceErrors;
    private final String provisionState;
    private final String workspaceInstanceId;
    private final EC2ManagedInstance ec2ManagedInstance;

    private GetWorkspaceInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceInstanceErrors = builder.workspaceInstanceErrors;
        this.ec2InstanceErrors = builder.ec2InstanceErrors;
        this.provisionState = builder.provisionState;
        this.workspaceInstanceId = builder.workspaceInstanceId;
        this.ec2ManagedInstance = builder.ec2ManagedInstance;
    }

    public final boolean hasWorkspaceInstanceErrors() {
        return this.workspaceInstanceErrors != null && !(this.workspaceInstanceErrors instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceInstanceError> workspaceInstanceErrors() {
        return this.workspaceInstanceErrors;
    }

    public final boolean hasEc2InstanceErrors() {
        return this.ec2InstanceErrors != null && !(this.ec2InstanceErrors instanceof SdkAutoConstructList);
    }

    public final List<EC2InstanceError> ec2InstanceErrors() {
        return this.ec2InstanceErrors;
    }

    public final ProvisionStateEnum provisionState() {
        return ProvisionStateEnum.fromValue(this.provisionState);
    }

    public final String provisionStateAsString() {
        return this.provisionState;
    }

    public final String workspaceInstanceId() {
        return this.workspaceInstanceId;
    }

    public final EC2ManagedInstance ec2ManagedInstance() {
        return this.ec2ManagedInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceInstanceErrors() ? this.workspaceInstanceErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceErrors() ? this.ec2InstanceErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ManagedInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkspaceInstanceResponse)) {
            return false;
        }
        GetWorkspaceInstanceResponse other = (GetWorkspaceInstanceResponse)((Object)obj);
        return this.hasWorkspaceInstanceErrors() == other.hasWorkspaceInstanceErrors() && Objects.equals(this.workspaceInstanceErrors(), other.workspaceInstanceErrors()) && this.hasEc2InstanceErrors() == other.hasEc2InstanceErrors() && Objects.equals(this.ec2InstanceErrors(), other.ec2InstanceErrors()) && Objects.equals(this.provisionStateAsString(), other.provisionStateAsString()) && Objects.equals(this.workspaceInstanceId(), other.workspaceInstanceId()) && Objects.equals(this.ec2ManagedInstance(), other.ec2ManagedInstance());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkspaceInstanceResponse").add("WorkspaceInstanceErrors", this.hasWorkspaceInstanceErrors() ? this.workspaceInstanceErrors() : null).add("EC2InstanceErrors", this.hasEc2InstanceErrors() ? this.ec2InstanceErrors() : null).add("ProvisionState", (Object)this.provisionStateAsString()).add("WorkspaceInstanceId", (Object)this.workspaceInstanceId()).add("EC2ManagedInstance", (Object)this.ec2ManagedInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceInstanceErrors": {
                return Optional.ofNullable(clazz.cast(this.workspaceInstanceErrors()));
            }
            case "EC2InstanceErrors": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceErrors()));
            }
            case "ProvisionState": {
                return Optional.ofNullable(clazz.cast(this.provisionStateAsString()));
            }
            case "WorkspaceInstanceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceInstanceId()));
            }
            case "EC2ManagedInstance": {
                return Optional.ofNullable(clazz.cast(this.ec2ManagedInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspaceInstanceErrors", WORKSPACE_INSTANCE_ERRORS_FIELD);
        map.put("EC2InstanceErrors", EC2_INSTANCE_ERRORS_FIELD);
        map.put("ProvisionState", PROVISION_STATE_FIELD);
        map.put("WorkspaceInstanceId", WORKSPACE_INSTANCE_ID_FIELD);
        map.put("EC2ManagedInstance", EC2_MANAGED_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkspaceInstanceResponse, T> g) {
        return obj -> g.apply((GetWorkspaceInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkspacesInstancesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceInstanceError> workspaceInstanceErrors = DefaultSdkAutoConstructList.getInstance();
        private List<EC2InstanceError> ec2InstanceErrors = DefaultSdkAutoConstructList.getInstance();
        private String provisionState;
        private String workspaceInstanceId;
        private EC2ManagedInstance ec2ManagedInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkspaceInstanceResponse model) {
            super(model);
            this.workspaceInstanceErrors(model.workspaceInstanceErrors);
            this.ec2InstanceErrors(model.ec2InstanceErrors);
            this.provisionState(model.provisionState);
            this.workspaceInstanceId(model.workspaceInstanceId);
            this.ec2ManagedInstance(model.ec2ManagedInstance);
        }

        public final List<WorkspaceInstanceError.Builder> getWorkspaceInstanceErrors() {
            List<WorkspaceInstanceError.Builder> result = WorkspaceInstanceErrorsCopier.copyToBuilder(this.workspaceInstanceErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaceInstanceErrors(Collection<WorkspaceInstanceError.BuilderImpl> workspaceInstanceErrors) {
            this.workspaceInstanceErrors = WorkspaceInstanceErrorsCopier.copyFromBuilder(workspaceInstanceErrors);
        }

        @Override
        public final Builder workspaceInstanceErrors(Collection<WorkspaceInstanceError> workspaceInstanceErrors) {
            this.workspaceInstanceErrors = WorkspaceInstanceErrorsCopier.copy(workspaceInstanceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceInstanceErrors(WorkspaceInstanceError ... workspaceInstanceErrors) {
            this.workspaceInstanceErrors(Arrays.asList(workspaceInstanceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceInstanceErrors(Consumer<WorkspaceInstanceError.Builder> ... workspaceInstanceErrors) {
            this.workspaceInstanceErrors(Stream.of(workspaceInstanceErrors).map(c -> (WorkspaceInstanceError)((WorkspaceInstanceError.Builder)WorkspaceInstanceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EC2InstanceError.Builder> getEc2InstanceErrors() {
            List<EC2InstanceError.Builder> result = EC2InstanceErrorsCopier.copyToBuilder(this.ec2InstanceErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceErrors(Collection<EC2InstanceError.BuilderImpl> ec2InstanceErrors) {
            this.ec2InstanceErrors = EC2InstanceErrorsCopier.copyFromBuilder(ec2InstanceErrors);
        }

        @Override
        public final Builder ec2InstanceErrors(Collection<EC2InstanceError> ec2InstanceErrors) {
            this.ec2InstanceErrors = EC2InstanceErrorsCopier.copy(ec2InstanceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceErrors(EC2InstanceError ... ec2InstanceErrors) {
            this.ec2InstanceErrors(Arrays.asList(ec2InstanceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceErrors(Consumer<EC2InstanceError.Builder> ... ec2InstanceErrors) {
            this.ec2InstanceErrors(Stream.of(ec2InstanceErrors).map(c -> (EC2InstanceError)((EC2InstanceError.Builder)EC2InstanceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProvisionState() {
            return this.provisionState;
        }

        public final void setProvisionState(String provisionState) {
            this.provisionState = provisionState;
        }

        @Override
        public final Builder provisionState(String provisionState) {
            this.provisionState = provisionState;
            return this;
        }

        @Override
        public final Builder provisionState(ProvisionStateEnum provisionState) {
            this.provisionState(provisionState == null ? null : provisionState.toString());
            return this;
        }

        public final String getWorkspaceInstanceId() {
            return this.workspaceInstanceId;
        }

        public final void setWorkspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
        }

        @Override
        public final Builder workspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        public final EC2ManagedInstance.Builder getEc2ManagedInstance() {
            return this.ec2ManagedInstance != null ? this.ec2ManagedInstance.toBuilder() : null;
        }

        public final void setEc2ManagedInstance(EC2ManagedInstance.BuilderImpl ec2ManagedInstance) {
            this.ec2ManagedInstance = ec2ManagedInstance != null ? ec2ManagedInstance.build() : null;
        }

        @Override
        public final Builder ec2ManagedInstance(EC2ManagedInstance ec2ManagedInstance) {
            this.ec2ManagedInstance = ec2ManagedInstance;
            return this;
        }

        @Override
        public GetWorkspaceInstanceResponse build() {
            return new GetWorkspaceInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkspacesInstancesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkspaceInstanceResponse> {
        public Builder workspaceInstanceErrors(Collection<WorkspaceInstanceError> var1);

        public Builder workspaceInstanceErrors(WorkspaceInstanceError ... var1);

        public Builder workspaceInstanceErrors(Consumer<WorkspaceInstanceError.Builder> ... var1);

        public Builder ec2InstanceErrors(Collection<EC2InstanceError> var1);

        public Builder ec2InstanceErrors(EC2InstanceError ... var1);

        public Builder ec2InstanceErrors(Consumer<EC2InstanceError.Builder> ... var1);

        public Builder provisionState(String var1);

        public Builder provisionState(ProvisionStateEnum var1);

        public Builder workspaceInstanceId(String var1);

        public Builder ec2ManagedInstance(EC2ManagedInstance var1);

        default public Builder ec2ManagedInstance(Consumer<EC2ManagedInstance.Builder> ec2ManagedInstance) {
            return this.ec2ManagedInstance((EC2ManagedInstance)((EC2ManagedInstance.Builder)EC2ManagedInstance.builder().applyMutation(ec2ManagedInstance)).build());
        }
    }
}

