/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OSVersion {
    WINDOWS_10("Windows_10"),
    WINDOWS_11("Windows_11"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OSVersion> VALUE_MAP;
    private final String value;

    private OSVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OSVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OSVersion> knownValues() {
        EnumSet<OSVersion> knownValues = EnumSet.allOf(OSVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OSVersion.class, OSVersion::toString);
    }
}

