/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssociationErrorCode {
    VALIDATION_ERROR_INSUFFICIENT_DISK_SPACE("ValidationError.InsufficientDiskSpace"),
    VALIDATION_ERROR_INSUFFICIENT_MEMORY("ValidationError.InsufficientMemory"),
    VALIDATION_ERROR_UNSUPPORTED_OPERATING_SYSTEM("ValidationError.UnsupportedOperatingSystem"),
    DEPLOYMENT_ERROR_INTERNAL_SERVER_ERROR("DeploymentError.InternalServerError"),
    DEPLOYMENT_ERROR_WORKSPACE_UNREACHABLE("DeploymentError.WorkspaceUnreachable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssociationErrorCode> VALUE_MAP;
    private final String value;

    private AssociationErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationErrorCode> knownValues() {
        EnumSet<AssociationErrorCode> knownValues = EnumSet.allOf(AssociationErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssociationErrorCode.class, AssociationErrorCode::toString);
    }
}

