/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ApplicationSettingsStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSettingsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSettingsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ApplicationSettingsResponse.getter(ApplicationSettingsResponse::statusAsString)).setter(ApplicationSettingsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SETTINGS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SettingsGroup").getter(ApplicationSettingsResponse.getter(ApplicationSettingsResponse::settingsGroup)).setter(ApplicationSettingsResponse.setter(Builder::settingsGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsGroup").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(ApplicationSettingsResponse.getter(ApplicationSettingsResponse::s3BucketName)).setter(ApplicationSettingsResponse.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SETTINGS_GROUP_FIELD, S3_BUCKET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationSettingsResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String settingsGroup;
    private final String s3BucketName;

    private ApplicationSettingsResponse(BuilderImpl builder) {
        this.status = builder.status;
        this.settingsGroup = builder.settingsGroup;
        this.s3BucketName = builder.s3BucketName;
    }

    public final ApplicationSettingsStatusEnum status() {
        return ApplicationSettingsStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String settingsGroup() {
        return this.settingsGroup;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingsGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsResponse)) {
            return false;
        }
        ApplicationSettingsResponse other = (ApplicationSettingsResponse)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.settingsGroup(), other.settingsGroup()) && Objects.equals(this.s3BucketName(), other.s3BucketName());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSettingsResponse").add("Status", (Object)this.statusAsString()).add("SettingsGroup", (Object)this.settingsGroup()).add("S3BucketName", (Object)this.s3BucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SettingsGroup": {
                return Optional.ofNullable(clazz.cast(this.settingsGroup()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Status", STATUS_FIELD);
        map.put("SettingsGroup", SETTINGS_GROUP_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsResponse, T> g) {
        return obj -> g.apply((ApplicationSettingsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String settingsGroup;
        private String s3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsResponse model) {
            this.status(model.status);
            this.settingsGroup(model.settingsGroup);
            this.s3BucketName(model.s3BucketName);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationSettingsStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSettingsGroup() {
            return this.settingsGroup;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        @Override
        @Transient
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public ApplicationSettingsResponse build() {
            return new ApplicationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSettingsResponse> {
        public Builder status(String var1);

        public Builder status(ApplicationSettingsStatusEnum var1);

        public Builder settingsGroup(String var1);

        public Builder s3BucketName(String var1);
    }
}

