/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a directory that is used with Amazon WorkSpaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceDirectory implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceDirectory.Builder, WorkspaceDirectory> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(WorkspaceDirectory::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(WorkspaceDirectory::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryName").getter(getter(WorkspaceDirectory::directoryName)).setter(setter(Builder::directoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()).build();

    private static final SdkField<String> REGISTRATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationCode").getter(getter(WorkspaceDirectory::registrationCode))
            .setter(setter(Builder::registrationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationCode").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(WorkspaceDirectory::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DNS_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsIpAddresses")
            .getter(getter(WorkspaceDirectory::dnsIpAddresses))
            .setter(setter(Builder::dnsIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DNS_IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsIpv6Addresses")
            .getter(getter(WorkspaceDirectory::dnsIpv6Addresses))
            .setter(setter(Builder::dnsIpv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerUserName").getter(getter(WorkspaceDirectory::customerUserName))
            .setter(setter(Builder::customerUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUserName").build()).build();

    private static final SdkField<String> IAM_ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleId").getter(getter(WorkspaceDirectory::iamRoleId)).setter(setter(Builder::iamRoleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleId").build()).build();

    private static final SdkField<String> DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryType").getter(getter(WorkspaceDirectory::directoryTypeAsString))
            .setter(setter(Builder::directoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryType").build()).build();

    private static final SdkField<String> WORKSPACE_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceSecurityGroupId").getter(getter(WorkspaceDirectory::workspaceSecurityGroupId))
            .setter(setter(Builder::workspaceSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSecurityGroupId").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(WorkspaceDirectory::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<DefaultWorkspaceCreationProperties> WORKSPACE_CREATION_PROPERTIES_FIELD = SdkField
            .<DefaultWorkspaceCreationProperties> builder(MarshallingType.SDK_POJO)
            .memberName("WorkspaceCreationProperties")
            .getter(getter(WorkspaceDirectory::workspaceCreationProperties))
            .setter(setter(Builder::workspaceCreationProperties))
            .constructor(DefaultWorkspaceCreationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceCreationProperties")
                    .build()).build();

    private static final SdkField<List<String>> IP_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipGroupIds")
            .getter(getter(WorkspaceDirectory::ipGroupIds))
            .setter(setter(Builder::ipGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WorkspaceAccessProperties> WORKSPACE_ACCESS_PROPERTIES_FIELD = SdkField
            .<WorkspaceAccessProperties> builder(MarshallingType.SDK_POJO).memberName("WorkspaceAccessProperties")
            .getter(getter(WorkspaceDirectory::workspaceAccessProperties)).setter(setter(Builder::workspaceAccessProperties))
            .constructor(WorkspaceAccessProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceAccessProperties").build())
            .build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(WorkspaceDirectory::tenancyAsString)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final SdkField<SelfservicePermissions> SELFSERVICE_PERMISSIONS_FIELD = SdkField
            .<SelfservicePermissions> builder(MarshallingType.SDK_POJO).memberName("SelfservicePermissions")
            .getter(getter(WorkspaceDirectory::selfservicePermissions)).setter(setter(Builder::selfservicePermissions))
            .constructor(SelfservicePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfservicePermissions").build())
            .build();

    private static final SdkField<SamlProperties> SAML_PROPERTIES_FIELD = SdkField
            .<SamlProperties> builder(MarshallingType.SDK_POJO).memberName("SamlProperties")
            .getter(getter(WorkspaceDirectory::samlProperties)).setter(setter(Builder::samlProperties))
            .constructor(SamlProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlProperties").build()).build();

    private static final SdkField<CertificateBasedAuthProperties> CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD = SdkField
            .<CertificateBasedAuthProperties> builder(MarshallingType.SDK_POJO)
            .memberName("CertificateBasedAuthProperties")
            .getter(getter(WorkspaceDirectory::certificateBasedAuthProperties))
            .setter(setter(Builder::certificateBasedAuthProperties))
            .constructor(CertificateBasedAuthProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBasedAuthProperties")
                    .build()).build();

    private static final SdkField<String> ENDPOINT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointEncryptionMode").getter(getter(WorkspaceDirectory::endpointEncryptionModeAsString))
            .setter(setter(Builder::endpointEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointEncryptionMode").build())
            .build();

    private static final SdkField<MicrosoftEntraConfig> MICROSOFT_ENTRA_CONFIG_FIELD = SdkField
            .<MicrosoftEntraConfig> builder(MarshallingType.SDK_POJO).memberName("MicrosoftEntraConfig")
            .getter(getter(WorkspaceDirectory::microsoftEntraConfig)).setter(setter(Builder::microsoftEntraConfig))
            .constructor(MicrosoftEntraConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftEntraConfig").build())
            .build();

    private static final SdkField<String> WORKSPACE_DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceDirectoryName").getter(getter(WorkspaceDirectory::workspaceDirectoryName))
            .setter(setter(Builder::workspaceDirectoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryName").build())
            .build();

    private static final SdkField<String> WORKSPACE_DIRECTORY_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceDirectoryDescription")
            .getter(getter(WorkspaceDirectory::workspaceDirectoryDescription))
            .setter(setter(Builder::workspaceDirectoryDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryDescription")
                    .build()).build();

    private static final SdkField<String> USER_IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserIdentityType").getter(getter(WorkspaceDirectory::userIdentityTypeAsString))
            .setter(setter(Builder::userIdentityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdentityType").build()).build();

    private static final SdkField<String> WORKSPACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceType").getter(getter(WorkspaceDirectory::workspaceTypeAsString))
            .setter(setter(Builder::workspaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceType").build()).build();

    private static final SdkField<IDCConfig> IDC_CONFIG_FIELD = SdkField.<IDCConfig> builder(MarshallingType.SDK_POJO)
            .memberName("IDCConfig").getter(getter(WorkspaceDirectory::idcConfig)).setter(setter(Builder::idcConfig))
            .constructor(IDCConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IDCConfig").build()).build();

    private static final SdkField<ActiveDirectoryConfig> ACTIVE_DIRECTORY_CONFIG_FIELD = SdkField
            .<ActiveDirectoryConfig> builder(MarshallingType.SDK_POJO).memberName("ActiveDirectoryConfig")
            .getter(getter(WorkspaceDirectory::activeDirectoryConfig)).setter(setter(Builder::activeDirectoryConfig))
            .constructor(ActiveDirectoryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfig").build())
            .build();

    private static final SdkField<StreamingProperties> STREAMING_PROPERTIES_FIELD = SdkField
            .<StreamingProperties> builder(MarshallingType.SDK_POJO).memberName("StreamingProperties")
            .getter(getter(WorkspaceDirectory::streamingProperties)).setter(setter(Builder::streamingProperties))
            .constructor(StreamingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingProperties").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(WorkspaceDirectory::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            ALIAS_FIELD, DIRECTORY_NAME_FIELD, REGISTRATION_CODE_FIELD, SUBNET_IDS_FIELD, DNS_IP_ADDRESSES_FIELD,
            DNS_IPV6_ADDRESSES_FIELD, CUSTOMER_USER_NAME_FIELD, IAM_ROLE_ID_FIELD, DIRECTORY_TYPE_FIELD,
            WORKSPACE_SECURITY_GROUP_ID_FIELD, STATE_FIELD, WORKSPACE_CREATION_PROPERTIES_FIELD, IP_GROUP_IDS_FIELD,
            WORKSPACE_ACCESS_PROPERTIES_FIELD, TENANCY_FIELD, SELFSERVICE_PERMISSIONS_FIELD, SAML_PROPERTIES_FIELD,
            CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD, ENDPOINT_ENCRYPTION_MODE_FIELD, MICROSOFT_ENTRA_CONFIG_FIELD,
            WORKSPACE_DIRECTORY_NAME_FIELD, WORKSPACE_DIRECTORY_DESCRIPTION_FIELD, USER_IDENTITY_TYPE_FIELD,
            WORKSPACE_TYPE_FIELD, IDC_CONFIG_FIELD, ACTIVE_DIRECTORY_CONFIG_FIELD, STREAMING_PROPERTIES_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String alias;

    private final String directoryName;

    private final String registrationCode;

    private final List<String> subnetIds;

    private final List<String> dnsIpAddresses;

    private final List<String> dnsIpv6Addresses;

    private final String customerUserName;

    private final String iamRoleId;

    private final String directoryType;

    private final String workspaceSecurityGroupId;

    private final String state;

    private final DefaultWorkspaceCreationProperties workspaceCreationProperties;

    private final List<String> ipGroupIds;

    private final WorkspaceAccessProperties workspaceAccessProperties;

    private final String tenancy;

    private final SelfservicePermissions selfservicePermissions;

    private final SamlProperties samlProperties;

    private final CertificateBasedAuthProperties certificateBasedAuthProperties;

    private final String endpointEncryptionMode;

    private final MicrosoftEntraConfig microsoftEntraConfig;

    private final String workspaceDirectoryName;

    private final String workspaceDirectoryDescription;

    private final String userIdentityType;

    private final String workspaceType;

    private final IDCConfig idcConfig;

    private final ActiveDirectoryConfig activeDirectoryConfig;

    private final StreamingProperties streamingProperties;

    private final String errorMessage;

    private WorkspaceDirectory(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.alias = builder.alias;
        this.directoryName = builder.directoryName;
        this.registrationCode = builder.registrationCode;
        this.subnetIds = builder.subnetIds;
        this.dnsIpAddresses = builder.dnsIpAddresses;
        this.dnsIpv6Addresses = builder.dnsIpv6Addresses;
        this.customerUserName = builder.customerUserName;
        this.iamRoleId = builder.iamRoleId;
        this.directoryType = builder.directoryType;
        this.workspaceSecurityGroupId = builder.workspaceSecurityGroupId;
        this.state = builder.state;
        this.workspaceCreationProperties = builder.workspaceCreationProperties;
        this.ipGroupIds = builder.ipGroupIds;
        this.workspaceAccessProperties = builder.workspaceAccessProperties;
        this.tenancy = builder.tenancy;
        this.selfservicePermissions = builder.selfservicePermissions;
        this.samlProperties = builder.samlProperties;
        this.certificateBasedAuthProperties = builder.certificateBasedAuthProperties;
        this.endpointEncryptionMode = builder.endpointEncryptionMode;
        this.microsoftEntraConfig = builder.microsoftEntraConfig;
        this.workspaceDirectoryName = builder.workspaceDirectoryName;
        this.workspaceDirectoryDescription = builder.workspaceDirectoryDescription;
        this.userIdentityType = builder.userIdentityType;
        this.workspaceType = builder.workspaceType;
        this.idcConfig = builder.idcConfig;
        this.activeDirectoryConfig = builder.activeDirectoryConfig;
        this.streamingProperties = builder.streamingProperties;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The directory identifier.
     * </p>
     * 
     * @return The directory identifier.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The directory alias.
     * </p>
     * 
     * @return The directory alias.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The name of the directory.
     * </p>
     * 
     * @return The name of the directory.
     */
    public final String directoryName() {
        return directoryName;
    }

    /**
     * <p>
     * The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client
     * application to connect to the directory.
     * </p>
     * 
     * @return The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces
     *         client application to connect to the directory.
     */
    public final String registrationCode() {
        return registrationCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the subnets used with the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The identifiers of the subnets used with the directory.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsIpAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDnsIpAddresses() {
        return dnsIpAddresses != null && !(dnsIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses of the DNS servers for the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsIpAddresses} method.
     * </p>
     * 
     * @return The IP addresses of the DNS servers for the directory.
     */
    public final List<String> dnsIpAddresses() {
        return dnsIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsIpv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDnsIpv6Addresses() {
        return dnsIpv6Addresses != null && !(dnsIpv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses of the DNS servers for the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsIpv6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses of the DNS servers for the directory.
     */
    public final List<String> dnsIpv6Addresses() {
        return dnsIpv6Addresses;
    }

    /**
     * <p>
     * The user name for the service account.
     * </p>
     * 
     * @return The user name for the service account.
     */
    public final String customerUserName() {
        return customerUserName;
    }

    /**
     * <p>
     * The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services,
     * such as Amazon EC2, on your behalf.
     * </p>
     * 
     * @return The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other
     *         services, such as Amazon EC2, on your behalf.
     */
    public final String iamRoleId() {
        return iamRoleId;
    }

    /**
     * <p>
     * The directory type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #directoryType}
     * will return {@link WorkspaceDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directoryTypeAsString}.
     * </p>
     * 
     * @return The directory type.
     * @see WorkspaceDirectoryType
     */
    public final WorkspaceDirectoryType directoryType() {
        return WorkspaceDirectoryType.fromValue(directoryType);
    }

    /**
     * <p>
     * The directory type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #directoryType}
     * will return {@link WorkspaceDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directoryTypeAsString}.
     * </p>
     * 
     * @return The directory type.
     * @see WorkspaceDirectoryType
     */
    public final String directoryTypeAsString() {
        return directoryType;
    }

    /**
     * <p>
     * The identifier of the security group that is assigned to new WorkSpaces.
     * </p>
     * 
     * @return The identifier of the security group that is assigned to new WorkSpaces.
     */
    public final String workspaceSecurityGroupId() {
        return workspaceSecurityGroupId;
    }

    /**
     * <p>
     * The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the
     * <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so this
     * state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
     * DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been successfully
     * deregistered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceDirectoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the
     *         <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so
     *         this state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by
     *         using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
     *         DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
     *         successfully deregistered.
     * @see WorkspaceDirectoryState
     */
    public final WorkspaceDirectoryState state() {
        return WorkspaceDirectoryState.fromValue(state);
    }

    /**
     * <p>
     * The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the
     * <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so this
     * state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
     * DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been successfully
     * deregistered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceDirectoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the
     *         <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so
     *         this state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by
     *         using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
     *         DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
     *         successfully deregistered.
     * @see WorkspaceDirectoryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The default creation properties for all WorkSpaces in the directory.
     * </p>
     * 
     * @return The default creation properties for all WorkSpaces in the directory.
     */
    public final DefaultWorkspaceCreationProperties workspaceCreationProperties() {
        return workspaceCreationProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpGroupIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpGroupIds() {
        return ipGroupIds != null && !(ipGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the IP access control groups associated with the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpGroupIds} method.
     * </p>
     * 
     * @return The identifiers of the IP access control groups associated with the directory.
     */
    public final List<String> ipGroupIds() {
        return ipGroupIds;
    }

    /**
     * <p>
     * The devices and operating systems that users can use to access WorkSpaces.
     * </p>
     * 
     * @return The devices and operating systems that users can use to access WorkSpaces.
     */
    public final WorkspaceAccessProperties workspaceAccessProperties() {
        return workspaceAccessProperties;
    }

    /**
     * <p>
     * Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must be
     * set to <code>DEDICATED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
     * Desktop Images</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value
     *         must be set to <code>DEDICATED</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
     *         Windows Desktop Images</a>.
     * @see Tenancy
     */
    public final Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must be
     * set to <code>DEDICATED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows
     * Desktop Images</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value
     *         must be set to <code>DEDICATED</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
     *         Windows Desktop Images</a>.
     * @see Tenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The default self-service permissions for WorkSpaces in the directory.
     * </p>
     * 
     * @return The default self-service permissions for WorkSpaces in the directory.
     */
    public final SelfservicePermissions selfservicePermissions() {
        return selfservicePermissions;
    }

    /**
     * <p>
     * Describes the enablement status, user access URL, and relay state parameter name that are used for configuring
     * federation with an SAML 2.0 identity provider.
     * </p>
     * 
     * @return Describes the enablement status, user access URL, and relay state parameter name that are used for
     *         configuring federation with an SAML 2.0 identity provider.
     */
    public final SamlProperties samlProperties() {
        return samlProperties;
    }

    /**
     * <p>
     * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user
     * identities to Active Directory for WorkSpaces login.
     * </p>
     * 
     * @return The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP)
     *         user identities to Active Directory for WorkSpaces login.
     */
    public final CertificateBasedAuthProperties certificateBasedAuthProperties() {
        return certificateBasedAuthProperties;
    }

    /**
     * <p>
     * Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and FIPS 140-2
     * validated mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointEncryptionMode} will return {@link EndpointEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #endpointEncryptionModeAsString}.
     * </p>
     * 
     * @return Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and
     *         FIPS 140-2 validated mode.
     * @see EndpointEncryptionMode
     */
    public final EndpointEncryptionMode endpointEncryptionMode() {
        return EndpointEncryptionMode.fromValue(endpointEncryptionMode);
    }

    /**
     * <p>
     * Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and FIPS 140-2
     * validated mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointEncryptionMode} will return {@link EndpointEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #endpointEncryptionModeAsString}.
     * </p>
     * 
     * @return Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and
     *         FIPS 140-2 validated mode.
     * @see EndpointEncryptionMode
     */
    public final String endpointEncryptionModeAsString() {
        return endpointEncryptionMode;
    }

    /**
     * <p>
     * Specifies details about Microsoft Entra configurations.
     * </p>
     * 
     * @return Specifies details about Microsoft Entra configurations.
     */
    public final MicrosoftEntraConfig microsoftEntraConfig() {
        return microsoftEntraConfig;
    }

    /**
     * <p>
     * The name fo the WorkSpace directory.
     * </p>
     * 
     * @return The name fo the WorkSpace directory.
     */
    public final String workspaceDirectoryName() {
        return workspaceDirectoryName;
    }

    /**
     * <p>
     * The description of the WorkSpace directory
     * </p>
     * 
     * @return The description of the WorkSpace directory
     */
    public final String workspaceDirectoryDescription() {
        return workspaceDirectoryDescription;
    }

    /**
     * <p>
     * Indicates the identity type of the specifired user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userIdentityType}
     * will return {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userIdentityTypeAsString}.
     * </p>
     * 
     * @return Indicates the identity type of the specifired user.
     * @see UserIdentityType
     */
    public final UserIdentityType userIdentityType() {
        return UserIdentityType.fromValue(userIdentityType);
    }

    /**
     * <p>
     * Indicates the identity type of the specifired user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userIdentityType}
     * will return {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #userIdentityTypeAsString}.
     * </p>
     * 
     * @return Indicates the identity type of the specifired user.
     * @see UserIdentityType
     */
    public final String userIdentityTypeAsString() {
        return userIdentityType;
    }

    /**
     * <p>
     * Indicates whether the directory's WorkSpace type is personal or pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workspaceType}
     * will return {@link WorkspaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workspaceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the directory's WorkSpace type is personal or pools.
     * @see WorkspaceType
     */
    public final WorkspaceType workspaceType() {
        return WorkspaceType.fromValue(workspaceType);
    }

    /**
     * <p>
     * Indicates whether the directory's WorkSpace type is personal or pools.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workspaceType}
     * will return {@link WorkspaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workspaceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the directory's WorkSpace type is personal or pools.
     * @see WorkspaceType
     */
    public final String workspaceTypeAsString() {
        return workspaceType;
    }

    /**
     * <p>
     * Specifies details about identity center configurations.
     * </p>
     * 
     * @return Specifies details about identity center configurations.
     */
    public final IDCConfig idcConfig() {
        return idcConfig;
    }

    /**
     * <p>
     * Information about the Active Directory config.
     * </p>
     * 
     * @return Information about the Active Directory config.
     */
    public final ActiveDirectoryConfig activeDirectoryConfig() {
        return activeDirectoryConfig;
    }

    /**
     * <p>
     * The streaming properties to configure.
     * </p>
     * 
     * @return The streaming properties to configure.
     */
    public final StreamingProperties streamingProperties() {
        return streamingProperties;
    }

    /**
     * <p>
     * The error message returned.
     * </p>
     * 
     * @return The error message returned.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsIpAddresses() ? dnsIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsIpv6Addresses() ? dnsIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerUserName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceCreationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpGroupIds() ? ipGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceAccessProperties());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selfservicePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(samlProperties());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBasedAuthProperties());
        hashCode = 31 * hashCode + Objects.hashCode(endpointEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(microsoftEntraConfig());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceDirectoryName());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceDirectoryDescription());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(streamingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDirectory)) {
            return false;
        }
        WorkspaceDirectory other = (WorkspaceDirectory) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(alias(), other.alias())
                && Objects.equals(directoryName(), other.directoryName())
                && Objects.equals(registrationCode(), other.registrationCode()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasDnsIpAddresses() == other.hasDnsIpAddresses()
                && Objects.equals(dnsIpAddresses(), other.dnsIpAddresses())
                && hasDnsIpv6Addresses() == other.hasDnsIpv6Addresses()
                && Objects.equals(dnsIpv6Addresses(), other.dnsIpv6Addresses())
                && Objects.equals(customerUserName(), other.customerUserName()) && Objects.equals(iamRoleId(), other.iamRoleId())
                && Objects.equals(directoryTypeAsString(), other.directoryTypeAsString())
                && Objects.equals(workspaceSecurityGroupId(), other.workspaceSecurityGroupId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(workspaceCreationProperties(), other.workspaceCreationProperties())
                && hasIpGroupIds() == other.hasIpGroupIds() && Objects.equals(ipGroupIds(), other.ipGroupIds())
                && Objects.equals(workspaceAccessProperties(), other.workspaceAccessProperties())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(selfservicePermissions(), other.selfservicePermissions())
                && Objects.equals(samlProperties(), other.samlProperties())
                && Objects.equals(certificateBasedAuthProperties(), other.certificateBasedAuthProperties())
                && Objects.equals(endpointEncryptionModeAsString(), other.endpointEncryptionModeAsString())
                && Objects.equals(microsoftEntraConfig(), other.microsoftEntraConfig())
                && Objects.equals(workspaceDirectoryName(), other.workspaceDirectoryName())
                && Objects.equals(workspaceDirectoryDescription(), other.workspaceDirectoryDescription())
                && Objects.equals(userIdentityTypeAsString(), other.userIdentityTypeAsString())
                && Objects.equals(workspaceTypeAsString(), other.workspaceTypeAsString())
                && Objects.equals(idcConfig(), other.idcConfig())
                && Objects.equals(activeDirectoryConfig(), other.activeDirectoryConfig())
                && Objects.equals(streamingProperties(), other.streamingProperties())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceDirectory").add("DirectoryId", directoryId()).add("Alias", alias())
                .add("DirectoryName", directoryName()).add("RegistrationCode", registrationCode())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("DnsIpAddresses", hasDnsIpAddresses() ? dnsIpAddresses() : null)
                .add("DnsIpv6Addresses", hasDnsIpv6Addresses() ? dnsIpv6Addresses() : null)
                .add("CustomerUserName", customerUserName()).add("IamRoleId", iamRoleId())
                .add("DirectoryType", directoryTypeAsString()).add("WorkspaceSecurityGroupId", workspaceSecurityGroupId())
                .add("State", stateAsString()).add("WorkspaceCreationProperties", workspaceCreationProperties())
                .add("IpGroupIds", hasIpGroupIds() ? ipGroupIds() : null)
                .add("WorkspaceAccessProperties", workspaceAccessProperties()).add("Tenancy", tenancyAsString())
                .add("SelfservicePermissions", selfservicePermissions()).add("SamlProperties", samlProperties())
                .add("CertificateBasedAuthProperties", certificateBasedAuthProperties())
                .add("EndpointEncryptionMode", endpointEncryptionModeAsString())
                .add("MicrosoftEntraConfig", microsoftEntraConfig()).add("WorkspaceDirectoryName", workspaceDirectoryName())
                .add("WorkspaceDirectoryDescription", workspaceDirectoryDescription())
                .add("UserIdentityType", userIdentityTypeAsString()).add("WorkspaceType", workspaceTypeAsString())
                .add("IDCConfig", idcConfig()).add("ActiveDirectoryConfig", activeDirectoryConfig())
                .add("StreamingProperties", streamingProperties()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "DirectoryName":
            return Optional.ofNullable(clazz.cast(directoryName()));
        case "RegistrationCode":
            return Optional.ofNullable(clazz.cast(registrationCode()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "DnsIpAddresses":
            return Optional.ofNullable(clazz.cast(dnsIpAddresses()));
        case "DnsIpv6Addresses":
            return Optional.ofNullable(clazz.cast(dnsIpv6Addresses()));
        case "CustomerUserName":
            return Optional.ofNullable(clazz.cast(customerUserName()));
        case "IamRoleId":
            return Optional.ofNullable(clazz.cast(iamRoleId()));
        case "DirectoryType":
            return Optional.ofNullable(clazz.cast(directoryTypeAsString()));
        case "WorkspaceSecurityGroupId":
            return Optional.ofNullable(clazz.cast(workspaceSecurityGroupId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "WorkspaceCreationProperties":
            return Optional.ofNullable(clazz.cast(workspaceCreationProperties()));
        case "ipGroupIds":
            return Optional.ofNullable(clazz.cast(ipGroupIds()));
        case "WorkspaceAccessProperties":
            return Optional.ofNullable(clazz.cast(workspaceAccessProperties()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "SelfservicePermissions":
            return Optional.ofNullable(clazz.cast(selfservicePermissions()));
        case "SamlProperties":
            return Optional.ofNullable(clazz.cast(samlProperties()));
        case "CertificateBasedAuthProperties":
            return Optional.ofNullable(clazz.cast(certificateBasedAuthProperties()));
        case "EndpointEncryptionMode":
            return Optional.ofNullable(clazz.cast(endpointEncryptionModeAsString()));
        case "MicrosoftEntraConfig":
            return Optional.ofNullable(clazz.cast(microsoftEntraConfig()));
        case "WorkspaceDirectoryName":
            return Optional.ofNullable(clazz.cast(workspaceDirectoryName()));
        case "WorkspaceDirectoryDescription":
            return Optional.ofNullable(clazz.cast(workspaceDirectoryDescription()));
        case "UserIdentityType":
            return Optional.ofNullable(clazz.cast(userIdentityTypeAsString()));
        case "WorkspaceType":
            return Optional.ofNullable(clazz.cast(workspaceTypeAsString()));
        case "IDCConfig":
            return Optional.ofNullable(clazz.cast(idcConfig()));
        case "ActiveDirectoryConfig":
            return Optional.ofNullable(clazz.cast(activeDirectoryConfig()));
        case "StreamingProperties":
            return Optional.ofNullable(clazz.cast(streamingProperties()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("DirectoryName", DIRECTORY_NAME_FIELD);
        map.put("RegistrationCode", REGISTRATION_CODE_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("DnsIpAddresses", DNS_IP_ADDRESSES_FIELD);
        map.put("DnsIpv6Addresses", DNS_IPV6_ADDRESSES_FIELD);
        map.put("CustomerUserName", CUSTOMER_USER_NAME_FIELD);
        map.put("IamRoleId", IAM_ROLE_ID_FIELD);
        map.put("DirectoryType", DIRECTORY_TYPE_FIELD);
        map.put("WorkspaceSecurityGroupId", WORKSPACE_SECURITY_GROUP_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("WorkspaceCreationProperties", WORKSPACE_CREATION_PROPERTIES_FIELD);
        map.put("ipGroupIds", IP_GROUP_IDS_FIELD);
        map.put("WorkspaceAccessProperties", WORKSPACE_ACCESS_PROPERTIES_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("SelfservicePermissions", SELFSERVICE_PERMISSIONS_FIELD);
        map.put("SamlProperties", SAML_PROPERTIES_FIELD);
        map.put("CertificateBasedAuthProperties", CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD);
        map.put("EndpointEncryptionMode", ENDPOINT_ENCRYPTION_MODE_FIELD);
        map.put("MicrosoftEntraConfig", MICROSOFT_ENTRA_CONFIG_FIELD);
        map.put("WorkspaceDirectoryName", WORKSPACE_DIRECTORY_NAME_FIELD);
        map.put("WorkspaceDirectoryDescription", WORKSPACE_DIRECTORY_DESCRIPTION_FIELD);
        map.put("UserIdentityType", USER_IDENTITY_TYPE_FIELD);
        map.put("WorkspaceType", WORKSPACE_TYPE_FIELD);
        map.put("IDCConfig", IDC_CONFIG_FIELD);
        map.put("ActiveDirectoryConfig", ACTIVE_DIRECTORY_CONFIG_FIELD);
        map.put("StreamingProperties", STREAMING_PROPERTIES_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceDirectory, T> g) {
        return obj -> g.apply((WorkspaceDirectory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceDirectory> {
        /**
         * <p>
         * The directory identifier.
         * </p>
         * 
         * @param directoryId
         *        The directory identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The directory alias.
         * </p>
         * 
         * @param alias
         *        The directory alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The name of the directory.
         * </p>
         * 
         * @param directoryName
         *        The name of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client
         * application to connect to the directory.
         * </p>
         * 
         * @param registrationCode
         *        The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces
         *        client application to connect to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationCode(String registrationCode);

        /**
         * <p>
         * The identifiers of the subnets used with the directory.
         * </p>
         * 
         * @param subnetIds
         *        The identifiers of the subnets used with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The identifiers of the subnets used with the directory.
         * </p>
         * 
         * @param subnetIds
         *        The identifiers of the subnets used with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The IP addresses of the DNS servers for the directory.
         * </p>
         * 
         * @param dnsIpAddresses
         *        The IP addresses of the DNS servers for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpAddresses(Collection<String> dnsIpAddresses);

        /**
         * <p>
         * The IP addresses of the DNS servers for the directory.
         * </p>
         * 
         * @param dnsIpAddresses
         *        The IP addresses of the DNS servers for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpAddresses(String... dnsIpAddresses);

        /**
         * <p>
         * The IPv6 addresses of the DNS servers for the directory.
         * </p>
         * 
         * @param dnsIpv6Addresses
         *        The IPv6 addresses of the DNS servers for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpv6Addresses(Collection<String> dnsIpv6Addresses);

        /**
         * <p>
         * The IPv6 addresses of the DNS servers for the directory.
         * </p>
         * 
         * @param dnsIpv6Addresses
         *        The IPv6 addresses of the DNS servers for the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpv6Addresses(String... dnsIpv6Addresses);

        /**
         * <p>
         * The user name for the service account.
         * </p>
         * 
         * @param customerUserName
         *        The user name for the service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerUserName(String customerUserName);

        /**
         * <p>
         * The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other
         * services, such as Amazon EC2, on your behalf.
         * </p>
         * 
         * @param iamRoleId
         *        The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other
         *        services, such as Amazon EC2, on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleId(String iamRoleId);

        /**
         * <p>
         * The directory type.
         * </p>
         * 
         * @param directoryType
         *        The directory type.
         * @see WorkspaceDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceDirectoryType
         */
        Builder directoryType(String directoryType);

        /**
         * <p>
         * The directory type.
         * </p>
         * 
         * @param directoryType
         *        The directory type.
         * @see WorkspaceDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceDirectoryType
         */
        Builder directoryType(WorkspaceDirectoryType directoryType);

        /**
         * <p>
         * The identifier of the security group that is assigned to new WorkSpaces.
         * </p>
         * 
         * @param workspaceSecurityGroupId
         *        The identifier of the security group that is assigned to new WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceSecurityGroupId(String workspaceSecurityGroupId);

        /**
         * <p>
         * The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the
         * <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so this
         * state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using <a
         * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
         * DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
         * successfully deregistered.
         * </p>
         * 
         * @param state
         *        The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered,
         *        the <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned
         *        up, so this state is rarely returned. To confirm that a directory is deregistered, check for the
         *        directory ID by using <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
         *        DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
         *        successfully deregistered.
         * @see WorkspaceDirectoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceDirectoryState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered, the
         * <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so this
         * state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using <a
         * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
         * DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
         * successfully deregistered.
         * </p>
         * 
         * @param state
         *        The state of the directory's registration with Amazon WorkSpaces. After a directory is deregistered,
         *        the <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned
         *        up, so this state is rarely returned. To confirm that a directory is deregistered, check for the
         *        directory ID by using <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html">
         *        DescribeWorkspaceDirectories</a>. If the directory ID isn't returned, then the directory has been
         *        successfully deregistered.
         * @see WorkspaceDirectoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceDirectoryState
         */
        Builder state(WorkspaceDirectoryState state);

        /**
         * <p>
         * The default creation properties for all WorkSpaces in the directory.
         * </p>
         * 
         * @param workspaceCreationProperties
         *        The default creation properties for all WorkSpaces in the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties);

        /**
         * <p>
         * The default creation properties for all WorkSpaces in the directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultWorkspaceCreationProperties.Builder} avoiding the need to create one manually via
         * {@link DefaultWorkspaceCreationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultWorkspaceCreationProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #workspaceCreationProperties(DefaultWorkspaceCreationProperties)}.
         * 
         * @param workspaceCreationProperties
         *        a consumer that will call methods on {@link DefaultWorkspaceCreationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceCreationProperties(DefaultWorkspaceCreationProperties)
         */
        default Builder workspaceCreationProperties(
                Consumer<DefaultWorkspaceCreationProperties.Builder> workspaceCreationProperties) {
            return workspaceCreationProperties(DefaultWorkspaceCreationProperties.builder()
                    .applyMutation(workspaceCreationProperties).build());
        }

        /**
         * <p>
         * The identifiers of the IP access control groups associated with the directory.
         * </p>
         * 
         * @param ipGroupIds
         *        The identifiers of the IP access control groups associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipGroupIds(Collection<String> ipGroupIds);

        /**
         * <p>
         * The identifiers of the IP access control groups associated with the directory.
         * </p>
         * 
         * @param ipGroupIds
         *        The identifiers of the IP access control groups associated with the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipGroupIds(String... ipGroupIds);

        /**
         * <p>
         * The devices and operating systems that users can use to access WorkSpaces.
         * </p>
         * 
         * @param workspaceAccessProperties
         *        The devices and operating systems that users can use to access WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceAccessProperties(WorkspaceAccessProperties workspaceAccessProperties);

        /**
         * <p>
         * The devices and operating systems that users can use to access WorkSpaces.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceAccessProperties.Builder}
         * avoiding the need to create one manually via {@link WorkspaceAccessProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceAccessProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #workspaceAccessProperties(WorkspaceAccessProperties)}.
         * 
         * @param workspaceAccessProperties
         *        a consumer that will call methods on {@link WorkspaceAccessProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceAccessProperties(WorkspaceAccessProperties)
         */
        default Builder workspaceAccessProperties(Consumer<WorkspaceAccessProperties.Builder> workspaceAccessProperties) {
            return workspaceAccessProperties(WorkspaceAccessProperties.builder().applyMutation(workspaceAccessProperties).build());
        }

        /**
         * <p>
         * Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must
         * be set to <code>DEDICATED</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
         * Windows Desktop Images</a>.
         * </p>
         * 
         * @param tenancy
         *        Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this
         *        value must be set to <code>DEDICATED</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your
         *        Own Windows Desktop Images</a>.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must
         * be set to <code>DEDICATED</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own
         * Windows Desktop Images</a>.
         * </p>
         * 
         * @param tenancy
         *        Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this
         *        value must be set to <code>DEDICATED</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your
         *        Own Windows Desktop Images</a>.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * The default self-service permissions for WorkSpaces in the directory.
         * </p>
         * 
         * @param selfservicePermissions
         *        The default self-service permissions for WorkSpaces in the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfservicePermissions(SelfservicePermissions selfservicePermissions);

        /**
         * <p>
         * The default self-service permissions for WorkSpaces in the directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelfservicePermissions.Builder} avoiding
         * the need to create one manually via {@link SelfservicePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfservicePermissions.Builder#build()} is called immediately and
         * its result is passed to {@link #selfservicePermissions(SelfservicePermissions)}.
         * 
         * @param selfservicePermissions
         *        a consumer that will call methods on {@link SelfservicePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfservicePermissions(SelfservicePermissions)
         */
        default Builder selfservicePermissions(Consumer<SelfservicePermissions.Builder> selfservicePermissions) {
            return selfservicePermissions(SelfservicePermissions.builder().applyMutation(selfservicePermissions).build());
        }

        /**
         * <p>
         * Describes the enablement status, user access URL, and relay state parameter name that are used for
         * configuring federation with an SAML 2.0 identity provider.
         * </p>
         * 
         * @param samlProperties
         *        Describes the enablement status, user access URL, and relay state parameter name that are used for
         *        configuring federation with an SAML 2.0 identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProperties(SamlProperties samlProperties);

        /**
         * <p>
         * Describes the enablement status, user access URL, and relay state parameter name that are used for
         * configuring federation with an SAML 2.0 identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlProperties.Builder} avoiding the need
         * to create one manually via {@link SamlProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #samlProperties(SamlProperties)}.
         * 
         * @param samlProperties
         *        a consumer that will call methods on {@link SamlProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlProperties(SamlProperties)
         */
        default Builder samlProperties(Consumer<SamlProperties.Builder> samlProperties) {
            return samlProperties(SamlProperties.builder().applyMutation(samlProperties).build());
        }

        /**
         * <p>
         * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user
         * identities to Active Directory for WorkSpaces login.
         * </p>
         * 
         * @param certificateBasedAuthProperties
         *        The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP)
         *        user identities to Active Directory for WorkSpaces login.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties);

        /**
         * <p>
         * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user
         * identities to Active Directory for WorkSpaces login.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateBasedAuthProperties.Builder}
         * avoiding the need to create one manually via {@link CertificateBasedAuthProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateBasedAuthProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #certificateBasedAuthProperties(CertificateBasedAuthProperties)}.
         * 
         * @param certificateBasedAuthProperties
         *        a consumer that will call methods on {@link CertificateBasedAuthProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateBasedAuthProperties(CertificateBasedAuthProperties)
         */
        default Builder certificateBasedAuthProperties(
                Consumer<CertificateBasedAuthProperties.Builder> certificateBasedAuthProperties) {
            return certificateBasedAuthProperties(CertificateBasedAuthProperties.builder()
                    .applyMutation(certificateBasedAuthProperties).build());
        }

        /**
         * <p>
         * Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and FIPS
         * 140-2 validated mode.
         * </p>
         * 
         * @param endpointEncryptionMode
         *        Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and
         *        FIPS 140-2 validated mode.
         * @see EndpointEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointEncryptionMode
         */
        Builder endpointEncryptionMode(String endpointEncryptionMode);

        /**
         * <p>
         * Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and FIPS
         * 140-2 validated mode.
         * </p>
         * 
         * @param endpointEncryptionMode
         *        Endpoint encryption mode that allows you to configure the specified directory between Standard TLS and
         *        FIPS 140-2 validated mode.
         * @see EndpointEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointEncryptionMode
         */
        Builder endpointEncryptionMode(EndpointEncryptionMode endpointEncryptionMode);

        /**
         * <p>
         * Specifies details about Microsoft Entra configurations.
         * </p>
         * 
         * @param microsoftEntraConfig
         *        Specifies details about Microsoft Entra configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microsoftEntraConfig(MicrosoftEntraConfig microsoftEntraConfig);

        /**
         * <p>
         * Specifies details about Microsoft Entra configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link MicrosoftEntraConfig.Builder} avoiding
         * the need to create one manually via {@link MicrosoftEntraConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MicrosoftEntraConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #microsoftEntraConfig(MicrosoftEntraConfig)}.
         * 
         * @param microsoftEntraConfig
         *        a consumer that will call methods on {@link MicrosoftEntraConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #microsoftEntraConfig(MicrosoftEntraConfig)
         */
        default Builder microsoftEntraConfig(Consumer<MicrosoftEntraConfig.Builder> microsoftEntraConfig) {
            return microsoftEntraConfig(MicrosoftEntraConfig.builder().applyMutation(microsoftEntraConfig).build());
        }

        /**
         * <p>
         * The name fo the WorkSpace directory.
         * </p>
         * 
         * @param workspaceDirectoryName
         *        The name fo the WorkSpace directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDirectoryName(String workspaceDirectoryName);

        /**
         * <p>
         * The description of the WorkSpace directory
         * </p>
         * 
         * @param workspaceDirectoryDescription
         *        The description of the WorkSpace directory
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDirectoryDescription(String workspaceDirectoryDescription);

        /**
         * <p>
         * Indicates the identity type of the specifired user.
         * </p>
         * 
         * @param userIdentityType
         *        Indicates the identity type of the specifired user.
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder userIdentityType(String userIdentityType);

        /**
         * <p>
         * Indicates the identity type of the specifired user.
         * </p>
         * 
         * @param userIdentityType
         *        Indicates the identity type of the specifired user.
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder userIdentityType(UserIdentityType userIdentityType);

        /**
         * <p>
         * Indicates whether the directory's WorkSpace type is personal or pools.
         * </p>
         * 
         * @param workspaceType
         *        Indicates whether the directory's WorkSpace type is personal or pools.
         * @see WorkspaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceType
         */
        Builder workspaceType(String workspaceType);

        /**
         * <p>
         * Indicates whether the directory's WorkSpace type is personal or pools.
         * </p>
         * 
         * @param workspaceType
         *        Indicates whether the directory's WorkSpace type is personal or pools.
         * @see WorkspaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceType
         */
        Builder workspaceType(WorkspaceType workspaceType);

        /**
         * <p>
         * Specifies details about identity center configurations.
         * </p>
         * 
         * @param idcConfig
         *        Specifies details about identity center configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcConfig(IDCConfig idcConfig);

        /**
         * <p>
         * Specifies details about identity center configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link IDCConfig.Builder} avoiding the need to
         * create one manually via {@link IDCConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IDCConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #idcConfig(IDCConfig)}.
         * 
         * @param idcConfig
         *        a consumer that will call methods on {@link IDCConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idcConfig(IDCConfig)
         */
        default Builder idcConfig(Consumer<IDCConfig.Builder> idcConfig) {
            return idcConfig(IDCConfig.builder().applyMutation(idcConfig).build());
        }

        /**
         * <p>
         * Information about the Active Directory config.
         * </p>
         * 
         * @param activeDirectoryConfig
         *        Information about the Active Directory config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryConfig(ActiveDirectoryConfig activeDirectoryConfig);

        /**
         * <p>
         * Information about the Active Directory config.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveDirectoryConfig.Builder} avoiding
         * the need to create one manually via {@link ActiveDirectoryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveDirectoryConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #activeDirectoryConfig(ActiveDirectoryConfig)}.
         * 
         * @param activeDirectoryConfig
         *        a consumer that will call methods on {@link ActiveDirectoryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectoryConfig(ActiveDirectoryConfig)
         */
        default Builder activeDirectoryConfig(Consumer<ActiveDirectoryConfig.Builder> activeDirectoryConfig) {
            return activeDirectoryConfig(ActiveDirectoryConfig.builder().applyMutation(activeDirectoryConfig).build());
        }

        /**
         * <p>
         * The streaming properties to configure.
         * </p>
         * 
         * @param streamingProperties
         *        The streaming properties to configure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingProperties(StreamingProperties streamingProperties);

        /**
         * <p>
         * The streaming properties to configure.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingProperties.Builder} avoiding the
         * need to create one manually via {@link StreamingProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingProperties(StreamingProperties)}.
         * 
         * @param streamingProperties
         *        a consumer that will call methods on {@link StreamingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingProperties(StreamingProperties)
         */
        default Builder streamingProperties(Consumer<StreamingProperties.Builder> streamingProperties) {
            return streamingProperties(StreamingProperties.builder().applyMutation(streamingProperties).build());
        }

        /**
         * <p>
         * The error message returned.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String alias;

        private String directoryName;

        private String registrationCode;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> dnsIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> dnsIpv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String customerUserName;

        private String iamRoleId;

        private String directoryType;

        private String workspaceSecurityGroupId;

        private String state;

        private DefaultWorkspaceCreationProperties workspaceCreationProperties;

        private List<String> ipGroupIds = DefaultSdkAutoConstructList.getInstance();

        private WorkspaceAccessProperties workspaceAccessProperties;

        private String tenancy;

        private SelfservicePermissions selfservicePermissions;

        private SamlProperties samlProperties;

        private CertificateBasedAuthProperties certificateBasedAuthProperties;

        private String endpointEncryptionMode;

        private MicrosoftEntraConfig microsoftEntraConfig;

        private String workspaceDirectoryName;

        private String workspaceDirectoryDescription;

        private String userIdentityType;

        private String workspaceType;

        private IDCConfig idcConfig;

        private ActiveDirectoryConfig activeDirectoryConfig;

        private StreamingProperties streamingProperties;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceDirectory model) {
            directoryId(model.directoryId);
            alias(model.alias);
            directoryName(model.directoryName);
            registrationCode(model.registrationCode);
            subnetIds(model.subnetIds);
            dnsIpAddresses(model.dnsIpAddresses);
            dnsIpv6Addresses(model.dnsIpv6Addresses);
            customerUserName(model.customerUserName);
            iamRoleId(model.iamRoleId);
            directoryType(model.directoryType);
            workspaceSecurityGroupId(model.workspaceSecurityGroupId);
            state(model.state);
            workspaceCreationProperties(model.workspaceCreationProperties);
            ipGroupIds(model.ipGroupIds);
            workspaceAccessProperties(model.workspaceAccessProperties);
            tenancy(model.tenancy);
            selfservicePermissions(model.selfservicePermissions);
            samlProperties(model.samlProperties);
            certificateBasedAuthProperties(model.certificateBasedAuthProperties);
            endpointEncryptionMode(model.endpointEncryptionMode);
            microsoftEntraConfig(model.microsoftEntraConfig);
            workspaceDirectoryName(model.workspaceDirectoryName);
            workspaceDirectoryDescription(model.workspaceDirectoryDescription);
            userIdentityType(model.userIdentityType);
            workspaceType(model.workspaceType);
            idcConfig(model.idcConfig);
            activeDirectoryConfig(model.activeDirectoryConfig);
            streamingProperties(model.streamingProperties);
            errorMessage(model.errorMessage);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final String getRegistrationCode() {
            return registrationCode;
        }

        public final void setRegistrationCode(String registrationCode) {
            this.registrationCode = registrationCode;
        }

        @Override
        public final Builder registrationCode(String registrationCode) {
            this.registrationCode = registrationCode;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getDnsIpAddresses() {
            if (dnsIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsIpAddresses;
        }

        public final void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = DnsIpAddressesCopier.copy(dnsIpAddresses);
        }

        @Override
        public final Builder dnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = DnsIpAddressesCopier.copy(dnsIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddresses(String... dnsIpAddresses) {
            dnsIpAddresses(Arrays.asList(dnsIpAddresses));
            return this;
        }

        public final Collection<String> getDnsIpv6Addresses() {
            if (dnsIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsIpv6Addresses;
        }

        public final void setDnsIpv6Addresses(Collection<String> dnsIpv6Addresses) {
            this.dnsIpv6Addresses = DnsIpv6AddressesCopier.copy(dnsIpv6Addresses);
        }

        @Override
        public final Builder dnsIpv6Addresses(Collection<String> dnsIpv6Addresses) {
            this.dnsIpv6Addresses = DnsIpv6AddressesCopier.copy(dnsIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpv6Addresses(String... dnsIpv6Addresses) {
            dnsIpv6Addresses(Arrays.asList(dnsIpv6Addresses));
            return this;
        }

        public final String getCustomerUserName() {
            return customerUserName;
        }

        public final void setCustomerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
        }

        @Override
        public final Builder customerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
            return this;
        }

        public final String getIamRoleId() {
            return iamRoleId;
        }

        public final void setIamRoleId(String iamRoleId) {
            this.iamRoleId = iamRoleId;
        }

        @Override
        public final Builder iamRoleId(String iamRoleId) {
            this.iamRoleId = iamRoleId;
            return this;
        }

        public final String getDirectoryType() {
            return directoryType;
        }

        public final void setDirectoryType(String directoryType) {
            this.directoryType = directoryType;
        }

        @Override
        public final Builder directoryType(String directoryType) {
            this.directoryType = directoryType;
            return this;
        }

        @Override
        public final Builder directoryType(WorkspaceDirectoryType directoryType) {
            this.directoryType(directoryType == null ? null : directoryType.toString());
            return this;
        }

        public final String getWorkspaceSecurityGroupId() {
            return workspaceSecurityGroupId;
        }

        public final void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
        }

        @Override
        public final Builder workspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceDirectoryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final DefaultWorkspaceCreationProperties.Builder getWorkspaceCreationProperties() {
            return workspaceCreationProperties != null ? workspaceCreationProperties.toBuilder() : null;
        }

        public final void setWorkspaceCreationProperties(
                DefaultWorkspaceCreationProperties.BuilderImpl workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties != null ? workspaceCreationProperties.build() : null;
        }

        @Override
        public final Builder workspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties;
            return this;
        }

        public final Collection<String> getIpGroupIds() {
            if (ipGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ipGroupIds;
        }

        public final void setIpGroupIds(Collection<String> ipGroupIds) {
            this.ipGroupIds = IpGroupIdListCopier.copy(ipGroupIds);
        }

        @Override
        public final Builder ipGroupIds(Collection<String> ipGroupIds) {
            this.ipGroupIds = IpGroupIdListCopier.copy(ipGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipGroupIds(String... ipGroupIds) {
            ipGroupIds(Arrays.asList(ipGroupIds));
            return this;
        }

        public final WorkspaceAccessProperties.Builder getWorkspaceAccessProperties() {
            return workspaceAccessProperties != null ? workspaceAccessProperties.toBuilder() : null;
        }

        public final void setWorkspaceAccessProperties(WorkspaceAccessProperties.BuilderImpl workspaceAccessProperties) {
            this.workspaceAccessProperties = workspaceAccessProperties != null ? workspaceAccessProperties.build() : null;
        }

        @Override
        public final Builder workspaceAccessProperties(WorkspaceAccessProperties workspaceAccessProperties) {
            this.workspaceAccessProperties = workspaceAccessProperties;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final SelfservicePermissions.Builder getSelfservicePermissions() {
            return selfservicePermissions != null ? selfservicePermissions.toBuilder() : null;
        }

        public final void setSelfservicePermissions(SelfservicePermissions.BuilderImpl selfservicePermissions) {
            this.selfservicePermissions = selfservicePermissions != null ? selfservicePermissions.build() : null;
        }

        @Override
        public final Builder selfservicePermissions(SelfservicePermissions selfservicePermissions) {
            this.selfservicePermissions = selfservicePermissions;
            return this;
        }

        public final SamlProperties.Builder getSamlProperties() {
            return samlProperties != null ? samlProperties.toBuilder() : null;
        }

        public final void setSamlProperties(SamlProperties.BuilderImpl samlProperties) {
            this.samlProperties = samlProperties != null ? samlProperties.build() : null;
        }

        @Override
        public final Builder samlProperties(SamlProperties samlProperties) {
            this.samlProperties = samlProperties;
            return this;
        }

        public final CertificateBasedAuthProperties.Builder getCertificateBasedAuthProperties() {
            return certificateBasedAuthProperties != null ? certificateBasedAuthProperties.toBuilder() : null;
        }

        public final void setCertificateBasedAuthProperties(
                CertificateBasedAuthProperties.BuilderImpl certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties != null ? certificateBasedAuthProperties.build()
                    : null;
        }

        @Override
        public final Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        public final String getEndpointEncryptionMode() {
            return endpointEncryptionMode;
        }

        public final void setEndpointEncryptionMode(String endpointEncryptionMode) {
            this.endpointEncryptionMode = endpointEncryptionMode;
        }

        @Override
        public final Builder endpointEncryptionMode(String endpointEncryptionMode) {
            this.endpointEncryptionMode = endpointEncryptionMode;
            return this;
        }

        @Override
        public final Builder endpointEncryptionMode(EndpointEncryptionMode endpointEncryptionMode) {
            this.endpointEncryptionMode(endpointEncryptionMode == null ? null : endpointEncryptionMode.toString());
            return this;
        }

        public final MicrosoftEntraConfig.Builder getMicrosoftEntraConfig() {
            return microsoftEntraConfig != null ? microsoftEntraConfig.toBuilder() : null;
        }

        public final void setMicrosoftEntraConfig(MicrosoftEntraConfig.BuilderImpl microsoftEntraConfig) {
            this.microsoftEntraConfig = microsoftEntraConfig != null ? microsoftEntraConfig.build() : null;
        }

        @Override
        public final Builder microsoftEntraConfig(MicrosoftEntraConfig microsoftEntraConfig) {
            this.microsoftEntraConfig = microsoftEntraConfig;
            return this;
        }

        public final String getWorkspaceDirectoryName() {
            return workspaceDirectoryName;
        }

        public final void setWorkspaceDirectoryName(String workspaceDirectoryName) {
            this.workspaceDirectoryName = workspaceDirectoryName;
        }

        @Override
        public final Builder workspaceDirectoryName(String workspaceDirectoryName) {
            this.workspaceDirectoryName = workspaceDirectoryName;
            return this;
        }

        public final String getWorkspaceDirectoryDescription() {
            return workspaceDirectoryDescription;
        }

        public final void setWorkspaceDirectoryDescription(String workspaceDirectoryDescription) {
            this.workspaceDirectoryDescription = workspaceDirectoryDescription;
        }

        @Override
        public final Builder workspaceDirectoryDescription(String workspaceDirectoryDescription) {
            this.workspaceDirectoryDescription = workspaceDirectoryDescription;
            return this;
        }

        public final String getUserIdentityType() {
            return userIdentityType;
        }

        public final void setUserIdentityType(String userIdentityType) {
            this.userIdentityType = userIdentityType;
        }

        @Override
        public final Builder userIdentityType(String userIdentityType) {
            this.userIdentityType = userIdentityType;
            return this;
        }

        @Override
        public final Builder userIdentityType(UserIdentityType userIdentityType) {
            this.userIdentityType(userIdentityType == null ? null : userIdentityType.toString());
            return this;
        }

        public final String getWorkspaceType() {
            return workspaceType;
        }

        public final void setWorkspaceType(String workspaceType) {
            this.workspaceType = workspaceType;
        }

        @Override
        public final Builder workspaceType(String workspaceType) {
            this.workspaceType = workspaceType;
            return this;
        }

        @Override
        public final Builder workspaceType(WorkspaceType workspaceType) {
            this.workspaceType(workspaceType == null ? null : workspaceType.toString());
            return this;
        }

        public final IDCConfig.Builder getIdcConfig() {
            return idcConfig != null ? idcConfig.toBuilder() : null;
        }

        public final void setIdcConfig(IDCConfig.BuilderImpl idcConfig) {
            this.idcConfig = idcConfig != null ? idcConfig.build() : null;
        }

        @Override
        public final Builder idcConfig(IDCConfig idcConfig) {
            this.idcConfig = idcConfig;
            return this;
        }

        public final ActiveDirectoryConfig.Builder getActiveDirectoryConfig() {
            return activeDirectoryConfig != null ? activeDirectoryConfig.toBuilder() : null;
        }

        public final void setActiveDirectoryConfig(ActiveDirectoryConfig.BuilderImpl activeDirectoryConfig) {
            this.activeDirectoryConfig = activeDirectoryConfig != null ? activeDirectoryConfig.build() : null;
        }

        @Override
        public final Builder activeDirectoryConfig(ActiveDirectoryConfig activeDirectoryConfig) {
            this.activeDirectoryConfig = activeDirectoryConfig;
            return this;
        }

        public final StreamingProperties.Builder getStreamingProperties() {
            return streamingProperties != null ? streamingProperties.toBuilder() : null;
        }

        public final void setStreamingProperties(StreamingProperties.BuilderImpl streamingProperties) {
            this.streamingProperties = streamingProperties != null ? streamingProperties.build() : null;
        }

        @Override
        public final Builder streamingProperties(StreamingProperties streamingProperties) {
            this.streamingProperties = streamingProperties;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public WorkspaceDirectory build() {
            return new WorkspaceDirectory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
