/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether a WorkSpace image needs to be updated with the latest drivers and other components required by
 * Amazon WorkSpaces.
 * </p>
 * <note>
 * <p>
 * Only Windows 10 WorkSpace images can be programmatically updated at this time.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResult implements SdkPojo, Serializable, ToCopyableBuilder<UpdateResult.Builder, UpdateResult> {
    private static final SdkField<Boolean> UPDATE_AVAILABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UpdateAvailable").getter(getter(UpdateResult::updateAvailable)).setter(setter(Builder::updateAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAvailable").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateResult::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_AVAILABLE_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean updateAvailable;

    private final String description;

    private UpdateResult(BuilderImpl builder) {
        this.updateAvailable = builder.updateAvailable;
        this.description = builder.description;
    }

    /**
     * <p>
     * Indicates whether updated drivers or other components are available for the specified WorkSpace image.
     * </p>
     * 
     * @return Indicates whether updated drivers or other components are available for the specified WorkSpace image.
     */
    public final Boolean updateAvailable() {
        return updateAvailable;
    }

    /**
     * <p>
     * A description of whether updates for the WorkSpace image are pending or available.
     * </p>
     * 
     * @return A description of whether updates for the WorkSpace image are pending or available.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResult)) {
            return false;
        }
        UpdateResult other = (UpdateResult) obj;
        return Objects.equals(updateAvailable(), other.updateAvailable()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResult").add("UpdateAvailable", updateAvailable()).add("Description", description())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateAvailable":
            return Optional.ofNullable(clazz.cast(updateAvailable()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdateAvailable", UPDATE_AVAILABLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResult, T> g) {
        return obj -> g.apply((UpdateResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateResult> {
        /**
         * <p>
         * Indicates whether updated drivers or other components are available for the specified WorkSpace image.
         * </p>
         * 
         * @param updateAvailable
         *        Indicates whether updated drivers or other components are available for the specified WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateAvailable(Boolean updateAvailable);

        /**
         * <p>
         * A description of whether updates for the WorkSpace image are pending or available.
         * </p>
         * 
         * @param description
         *        A description of whether updates for the WorkSpace image are pending or available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private Boolean updateAvailable;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResult model) {
            updateAvailable(model.updateAvailable);
            description(model.description);
        }

        public final Boolean getUpdateAvailable() {
            return updateAvailable;
        }

        public final void setUpdateAvailable(Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
        }

        @Override
        public final Builder updateAvailable(Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public UpdateResult build() {
            return new UpdateResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
