/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageConnector implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageConnector.Builder, StorageConnector> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorType").getter(getter(StorageConnector::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StorageConnector::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorType;

    private final String status;

    private StorageConnector(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.status = builder.status;
    }

    /**
     * <p>
     * The type of connector used to save user files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link StorageConnectorTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector used to save user files.
     * @see StorageConnectorTypeEnum
     */
    public final StorageConnectorTypeEnum connectorType() {
        return StorageConnectorTypeEnum.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector used to save user files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link StorageConnectorTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector used to save user files.
     * @see StorageConnectorTypeEnum
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * Indicates if the storage connetor is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StorageConnectorStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates if the storage connetor is enabled or disabled.
     * @see StorageConnectorStatusEnum
     */
    public final StorageConnectorStatusEnum status() {
        return StorageConnectorStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * Indicates if the storage connetor is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StorageConnectorStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates if the storage connetor is enabled or disabled.
     * @see StorageConnectorStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConnector)) {
            return false;
        }
        StorageConnector other = (StorageConnector) obj;
        return Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageConnector").add("ConnectorType", connectorTypeAsString()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorType", CONNECTOR_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageConnector, T> g) {
        return obj -> g.apply((StorageConnector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageConnector> {
        /**
         * <p>
         * The type of connector used to save user files.
         * </p>
         * 
         * @param connectorType
         *        The type of connector used to save user files.
         * @see StorageConnectorTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorTypeEnum
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector used to save user files.
         * </p>
         * 
         * @param connectorType
         *        The type of connector used to save user files.
         * @see StorageConnectorTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorTypeEnum
         */
        Builder connectorType(StorageConnectorTypeEnum connectorType);

        /**
         * <p>
         * Indicates if the storage connetor is enabled or disabled.
         * </p>
         * 
         * @param status
         *        Indicates if the storage connetor is enabled or disabled.
         * @see StorageConnectorStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates if the storage connetor is enabled or disabled.
         * </p>
         * 
         * @param status
         *        Indicates if the storage connetor is enabled or disabled.
         * @see StorageConnectorStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorStatusEnum
         */
        Builder status(StorageConnectorStatusEnum status);
    }

    static final class BuilderImpl implements Builder {
        private String connectorType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConnector model) {
            connectorType(model.connectorType);
            status(model.status);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(StorageConnectorTypeEnum connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StorageConnectorStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StorageConnector build() {
            return new StorageConnector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
