/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class StartWorkspaceRequestsCopier {
    static List<StartRequest> copy(Collection<? extends StartRequest> startWorkspaceRequestsParam) {
        List<StartRequest> list;
        if (startWorkspaceRequestsParam == null || startWorkspaceRequestsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StartRequest> modifiableList = new ArrayList<>(startWorkspaceRequestsParam.size());
            startWorkspaceRequestsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<StartRequest> copyFromBuilder(Collection<? extends StartRequest.Builder> startWorkspaceRequestsParam) {
        List<StartRequest> list;
        if (startWorkspaceRequestsParam == null || startWorkspaceRequestsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StartRequest> modifiableList = new ArrayList<>(startWorkspaceRequestsParam.size());
            startWorkspaceRequestsParam.forEach(entry -> {
                StartRequest member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<StartRequest.Builder> copyToBuilder(Collection<? extends StartRequest> startWorkspaceRequestsParam) {
        List<StartRequest.Builder> list;
        if (startWorkspaceRequestsParam == null || startWorkspaceRequestsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<StartRequest.Builder> modifiableList = new ArrayList<>(startWorkspaceRequestsParam.size());
            startWorkspaceRequestsParam.forEach(entry -> {
                StartRequest.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
