/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the related standby WorkSpaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandbyWorkspacesProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<StandbyWorkspacesProperties.Builder, StandbyWorkspacesProperties> {
    private static final SdkField<String> STANDBY_WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandbyWorkspaceId").getter(getter(StandbyWorkspacesProperties::standbyWorkspaceId))
            .setter(setter(Builder::standbyWorkspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyWorkspaceId").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataReplication").getter(getter(StandbyWorkspacesProperties::dataReplicationAsString))
            .setter(setter(Builder::dataReplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataReplication").build()).build();

    private static final SdkField<Instant> RECOVERY_SNAPSHOT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecoverySnapshotTime").getter(getter(StandbyWorkspacesProperties::recoverySnapshotTime))
            .setter(setter(Builder::recoverySnapshotTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoverySnapshotTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDBY_WORKSPACE_ID_FIELD,
            DATA_REPLICATION_FIELD, RECOVERY_SNAPSHOT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String standbyWorkspaceId;

    private final String dataReplication;

    private final Instant recoverySnapshotTime;

    private StandbyWorkspacesProperties(BuilderImpl builder) {
        this.standbyWorkspaceId = builder.standbyWorkspaceId;
        this.dataReplication = builder.dataReplication;
        this.recoverySnapshotTime = builder.recoverySnapshotTime;
    }

    /**
     * <p>
     * The identifier of the standby WorkSpace
     * </p>
     * 
     * @return The identifier of the standby WorkSpace
     */
    public final String standbyWorkspaceId() {
        return standbyWorkspaceId;
    }

    /**
     * <p>
     * Indicates whether data replication is enabled, and if enabled, the type of data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataReplication}
     * will return {@link DataReplication#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataReplicationAsString}.
     * </p>
     * 
     * @return Indicates whether data replication is enabled, and if enabled, the type of data replication.
     * @see DataReplication
     */
    public final DataReplication dataReplication() {
        return DataReplication.fromValue(dataReplication);
    }

    /**
     * <p>
     * Indicates whether data replication is enabled, and if enabled, the type of data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataReplication}
     * will return {@link DataReplication#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataReplicationAsString}.
     * </p>
     * 
     * @return Indicates whether data replication is enabled, and if enabled, the type of data replication.
     * @see DataReplication
     */
    public final String dataReplicationAsString() {
        return dataReplication;
    }

    /**
     * <p>
     * The date and time at which the last successful snapshot was taken of the primary WorkSpace used for replicating
     * data.
     * </p>
     * 
     * @return The date and time at which the last successful snapshot was taken of the primary WorkSpace used for
     *         replicating data.
     */
    public final Instant recoverySnapshotTime() {
        return recoverySnapshotTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standbyWorkspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recoverySnapshotTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandbyWorkspacesProperties)) {
            return false;
        }
        StandbyWorkspacesProperties other = (StandbyWorkspacesProperties) obj;
        return Objects.equals(standbyWorkspaceId(), other.standbyWorkspaceId())
                && Objects.equals(dataReplicationAsString(), other.dataReplicationAsString())
                && Objects.equals(recoverySnapshotTime(), other.recoverySnapshotTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandbyWorkspacesProperties").add("StandbyWorkspaceId", standbyWorkspaceId())
                .add("DataReplication", dataReplicationAsString()).add("RecoverySnapshotTime", recoverySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandbyWorkspaceId":
            return Optional.ofNullable(clazz.cast(standbyWorkspaceId()));
        case "DataReplication":
            return Optional.ofNullable(clazz.cast(dataReplicationAsString()));
        case "RecoverySnapshotTime":
            return Optional.ofNullable(clazz.cast(recoverySnapshotTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StandbyWorkspaceId", STANDBY_WORKSPACE_ID_FIELD);
        map.put("DataReplication", DATA_REPLICATION_FIELD);
        map.put("RecoverySnapshotTime", RECOVERY_SNAPSHOT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandbyWorkspacesProperties, T> g) {
        return obj -> g.apply((StandbyWorkspacesProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandbyWorkspacesProperties> {
        /**
         * <p>
         * The identifier of the standby WorkSpace
         * </p>
         * 
         * @param standbyWorkspaceId
         *        The identifier of the standby WorkSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standbyWorkspaceId(String standbyWorkspaceId);

        /**
         * <p>
         * Indicates whether data replication is enabled, and if enabled, the type of data replication.
         * </p>
         * 
         * @param dataReplication
         *        Indicates whether data replication is enabled, and if enabled, the type of data replication.
         * @see DataReplication
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplication
         */
        Builder dataReplication(String dataReplication);

        /**
         * <p>
         * Indicates whether data replication is enabled, and if enabled, the type of data replication.
         * </p>
         * 
         * @param dataReplication
         *        Indicates whether data replication is enabled, and if enabled, the type of data replication.
         * @see DataReplication
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplication
         */
        Builder dataReplication(DataReplication dataReplication);

        /**
         * <p>
         * The date and time at which the last successful snapshot was taken of the primary WorkSpace used for
         * replicating data.
         * </p>
         * 
         * @param recoverySnapshotTime
         *        The date and time at which the last successful snapshot was taken of the primary WorkSpace used for
         *        replicating data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoverySnapshotTime(Instant recoverySnapshotTime);
    }

    static final class BuilderImpl implements Builder {
        private String standbyWorkspaceId;

        private String dataReplication;

        private Instant recoverySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StandbyWorkspacesProperties model) {
            standbyWorkspaceId(model.standbyWorkspaceId);
            dataReplication(model.dataReplication);
            recoverySnapshotTime(model.recoverySnapshotTime);
        }

        public final String getStandbyWorkspaceId() {
            return standbyWorkspaceId;
        }

        public final void setStandbyWorkspaceId(String standbyWorkspaceId) {
            this.standbyWorkspaceId = standbyWorkspaceId;
        }

        @Override
        public final Builder standbyWorkspaceId(String standbyWorkspaceId) {
            this.standbyWorkspaceId = standbyWorkspaceId;
            return this;
        }

        public final String getDataReplication() {
            return dataReplication;
        }

        public final void setDataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
        }

        @Override
        public final Builder dataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
            return this;
        }

        @Override
        public final Builder dataReplication(DataReplication dataReplication) {
            this.dataReplication(dataReplication == null ? null : dataReplication.toString());
            return this;
        }

        public final Instant getRecoverySnapshotTime() {
            return recoverySnapshotTime;
        }

        public final void setRecoverySnapshotTime(Instant recoverySnapshotTime) {
            this.recoverySnapshotTime = recoverySnapshotTime;
        }

        @Override
        public final Builder recoverySnapshotTime(Instant recoverySnapshotTime) {
            this.recoverySnapshotTime = recoverySnapshotTime;
            return this;
        }

        @Override
        public StandbyWorkspacesProperties build() {
            return new StandbyWorkspacesProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
