/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySamlPropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifySamlPropertiesRequest.Builder, ModifySamlPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ModifySamlPropertiesRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<SamlProperties> SAML_PROPERTIES_FIELD = SdkField
            .<SamlProperties> builder(MarshallingType.SDK_POJO).memberName("SamlProperties")
            .getter(getter(ModifySamlPropertiesRequest::samlProperties)).setter(setter(Builder::samlProperties))
            .constructor(SamlProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlProperties").build()).build();

    private static final SdkField<List<String>> PROPERTIES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PropertiesToDelete")
            .getter(getter(ModifySamlPropertiesRequest::propertiesToDeleteAsStrings))
            .setter(setter(Builder::propertiesToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            SAML_PROPERTIES_FIELD, PROPERTIES_TO_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceId;

    private final SamlProperties samlProperties;

    private final List<String> propertiesToDelete;

    private ModifySamlPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.samlProperties = builder.samlProperties;
        this.propertiesToDelete = builder.propertiesToDelete;
    }

    /**
     * <p>
     * The directory identifier for which you want to configure SAML properties.
     * </p>
     * 
     * @return The directory identifier for which you want to configure SAML properties.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The properties for configuring SAML 2.0 authentication.
     * </p>
     * 
     * @return The properties for configuring SAML 2.0 authentication.
     */
    public final SamlProperties samlProperties() {
        return samlProperties;
    }

    /**
     * <p>
     * The SAML properties to delete as part of your request.
     * </p>
     * <p>
     * Specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertiesToDelete} method.
     * </p>
     * 
     * @return The SAML properties to delete as part of your request.</p>
     *         <p>
     *         Specify one of the following options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
     *         </p>
     *         </li>
     */
    public final List<DeletableSamlProperty> propertiesToDelete() {
        return DeletableSamlPropertiesListCopier.copyStringToEnum(propertiesToDelete);
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertiesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertiesToDelete() {
        return propertiesToDelete != null && !(propertiesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SAML properties to delete as part of your request.
     * </p>
     * <p>
     * Specify one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertiesToDelete} method.
     * </p>
     * 
     * @return The SAML properties to delete as part of your request.</p>
     *         <p>
     *         Specify one of the following options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
     *         </p>
     *         </li>
     */
    public final List<String> propertiesToDeleteAsStrings() {
        return propertiesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(samlProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertiesToDelete() ? propertiesToDeleteAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySamlPropertiesRequest)) {
            return false;
        }
        ModifySamlPropertiesRequest other = (ModifySamlPropertiesRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(samlProperties(), other.samlProperties())
                && hasPropertiesToDelete() == other.hasPropertiesToDelete()
                && Objects.equals(propertiesToDeleteAsStrings(), other.propertiesToDeleteAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySamlPropertiesRequest").add("ResourceId", resourceId())
                .add("SamlProperties", samlProperties())
                .add("PropertiesToDelete", hasPropertiesToDelete() ? propertiesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "SamlProperties":
            return Optional.ofNullable(clazz.cast(samlProperties()));
        case "PropertiesToDelete":
            return Optional.ofNullable(clazz.cast(propertiesToDeleteAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("SamlProperties", SAML_PROPERTIES_FIELD);
        map.put("PropertiesToDelete", PROPERTIES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySamlPropertiesRequest, T> g) {
        return obj -> g.apply((ModifySamlPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifySamlPropertiesRequest> {
        /**
         * <p>
         * The directory identifier for which you want to configure SAML properties.
         * </p>
         * 
         * @param resourceId
         *        The directory identifier for which you want to configure SAML properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The properties for configuring SAML 2.0 authentication.
         * </p>
         * 
         * @param samlProperties
         *        The properties for configuring SAML 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProperties(SamlProperties samlProperties);

        /**
         * <p>
         * The properties for configuring SAML 2.0 authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlProperties.Builder} avoiding the need
         * to create one manually via {@link SamlProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #samlProperties(SamlProperties)}.
         * 
         * @param samlProperties
         *        a consumer that will call methods on {@link SamlProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlProperties(SamlProperties)
         */
        default Builder samlProperties(Consumer<SamlProperties.Builder> samlProperties) {
            return samlProperties(SamlProperties.builder().applyMutation(samlProperties).build());
        }

        /**
         * <p>
         * The SAML properties to delete as part of your request.
         * </p>
         * <p>
         * Specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         * </p>
         * </li>
         * </ul>
         * 
         * @param propertiesToDelete
         *        The SAML properties to delete as part of your request.</p>
         *        <p>
         *        Specify one of the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDeleteWithStrings(Collection<String> propertiesToDelete);

        /**
         * <p>
         * The SAML properties to delete as part of your request.
         * </p>
         * <p>
         * Specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         * </p>
         * </li>
         * </ul>
         * 
         * @param propertiesToDelete
         *        The SAML properties to delete as part of your request.</p>
         *        <p>
         *        Specify one of the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDeleteWithStrings(String... propertiesToDelete);

        /**
         * <p>
         * The SAML properties to delete as part of your request.
         * </p>
         * <p>
         * Specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         * </p>
         * </li>
         * </ul>
         * 
         * @param propertiesToDelete
         *        The SAML properties to delete as part of your request.</p>
         *        <p>
         *        Specify one of the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDelete(Collection<DeletableSamlProperty> propertiesToDelete);

        /**
         * <p>
         * The SAML properties to delete as part of your request.
         * </p>
         * <p>
         * Specify one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         * </p>
         * </li>
         * </ul>
         * 
         * @param propertiesToDelete
         *        The SAML properties to delete as part of your request.</p>
         *        <p>
         *        Specify one of the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDelete(DeletableSamlProperty... propertiesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private SamlProperties samlProperties;

        private List<String> propertiesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySamlPropertiesRequest model) {
            super(model);
            resourceId(model.resourceId);
            samlProperties(model.samlProperties);
            propertiesToDeleteWithStrings(model.propertiesToDelete);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SamlProperties.Builder getSamlProperties() {
            return samlProperties != null ? samlProperties.toBuilder() : null;
        }

        public final void setSamlProperties(SamlProperties.BuilderImpl samlProperties) {
            this.samlProperties = samlProperties != null ? samlProperties.build() : null;
        }

        @Override
        public final Builder samlProperties(SamlProperties samlProperties) {
            this.samlProperties = samlProperties;
            return this;
        }

        public final Collection<String> getPropertiesToDelete() {
            if (propertiesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return propertiesToDelete;
        }

        public final void setPropertiesToDelete(Collection<String> propertiesToDelete) {
            this.propertiesToDelete = DeletableSamlPropertiesListCopier.copy(propertiesToDelete);
        }

        @Override
        public final Builder propertiesToDeleteWithStrings(Collection<String> propertiesToDelete) {
            this.propertiesToDelete = DeletableSamlPropertiesListCopier.copy(propertiesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToDeleteWithStrings(String... propertiesToDelete) {
            propertiesToDeleteWithStrings(Arrays.asList(propertiesToDelete));
            return this;
        }

        @Override
        public final Builder propertiesToDelete(Collection<DeletableSamlProperty> propertiesToDelete) {
            this.propertiesToDelete = DeletableSamlPropertiesListCopier.copyEnumToString(propertiesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToDelete(DeletableSamlProperty... propertiesToDelete) {
            propertiesToDelete(Arrays.asList(propertiesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySamlPropertiesRequest build() {
            return new ModifySamlPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
