/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configurations of the Microsoft Entra.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MicrosoftEntraConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MicrosoftEntraConfig.Builder, MicrosoftEntraConfig> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(MicrosoftEntraConfig::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> APPLICATION_CONFIG_SECRET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationConfigSecretArn")
            .getter(getter(MicrosoftEntraConfig::applicationConfigSecretArn))
            .setter(setter(Builder::applicationConfigSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfigSecretArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD,
            APPLICATION_CONFIG_SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantId;

    private final String applicationConfigSecretArn;

    private MicrosoftEntraConfig(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.applicationConfigSecretArn = builder.applicationConfigSecretArn;
    }

    /**
     * <p>
     * The identifier of the tenant.
     * </p>
     * 
     * @return The identifier of the tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application config.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application config.
     */
    public final String applicationConfigSecretArn() {
        return applicationConfigSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfigSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MicrosoftEntraConfig)) {
            return false;
        }
        MicrosoftEntraConfig other = (MicrosoftEntraConfig) obj;
        return Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(applicationConfigSecretArn(), other.applicationConfigSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MicrosoftEntraConfig").add("TenantId", tenantId())
                .add("ApplicationConfigSecretArn", applicationConfigSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "ApplicationConfigSecretArn":
            return Optional.ofNullable(clazz.cast(applicationConfigSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("ApplicationConfigSecretArn", APPLICATION_CONFIG_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MicrosoftEntraConfig, T> g) {
        return obj -> g.apply((MicrosoftEntraConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MicrosoftEntraConfig> {
        /**
         * <p>
         * The identifier of the tenant.
         * </p>
         * 
         * @param tenantId
         *        The identifier of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application config.
         * </p>
         * 
         * @param applicationConfigSecretArn
         *        The Amazon Resource Name (ARN) of the application config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfigSecretArn(String applicationConfigSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String tenantId;

        private String applicationConfigSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MicrosoftEntraConfig model) {
            tenantId(model.tenantId);
            applicationConfigSecretArn(model.applicationConfigSecretArn);
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getApplicationConfigSecretArn() {
            return applicationConfigSecretArn;
        }

        public final void setApplicationConfigSecretArn(String applicationConfigSecretArn) {
            this.applicationConfigSecretArn = applicationConfigSecretArn;
        }

        @Override
        public final Builder applicationConfigSecretArn(String applicationConfigSecretArn) {
            this.applicationConfigSecretArn = applicationConfigSecretArn;
            return this;
        }

        @Override
        public MicrosoftEntraConfig build() {
            return new MicrosoftEntraConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
