/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportCustomWorkspaceImageRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ImportCustomWorkspaceImageRequest.Builder, ImportCustomWorkspaceImageRequest> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(ImportCustomWorkspaceImageRequest::imageName))
            .setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageDescription").getter(getter(ImportCustomWorkspaceImageRequest::imageDescription))
            .setter(setter(Builder::imageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDescription").build()).build();

    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeType").getter(getter(ImportCustomWorkspaceImageRequest::computeTypeAsString))
            .setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(ImportCustomWorkspaceImageRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<ImageSourceIdentifier> IMAGE_SOURCE_FIELD = SdkField
            .<ImageSourceIdentifier> builder(MarshallingType.SDK_POJO).memberName("ImageSource")
            .getter(getter(ImportCustomWorkspaceImageRequest::imageSource)).setter(setter(Builder::imageSource))
            .constructor(ImageSourceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSource").build()).build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InfrastructureConfigurationArn")
            .getter(getter(ImportCustomWorkspaceImageRequest::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(ImportCustomWorkspaceImageRequest::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OsVersion").getter(getter(ImportCustomWorkspaceImageRequest::osVersionAsString))
            .setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportCustomWorkspaceImageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD,
            IMAGE_DESCRIPTION_FIELD, COMPUTE_TYPE_FIELD, PROTOCOL_FIELD, IMAGE_SOURCE_FIELD,
            INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String imageName;

    private final String imageDescription;

    private final String computeType;

    private final String protocol;

    private final ImageSourceIdentifier imageSource;

    private final String infrastructureConfigurationArn;

    private final String platform;

    private final String osVersion;

    private final List<Tag> tags;

    private ImportCustomWorkspaceImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageName = builder.imageName;
        this.imageDescription = builder.imageDescription;
        this.computeType = builder.computeType;
        this.protocol = builder.protocol;
        this.imageSource = builder.imageSource;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the WorkSpace image.
     * </p>
     * 
     * @return The name of the WorkSpace image.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The description of the WorkSpace image.
     * </p>
     * 
     * @return The description of the WorkSpace image.
     */
    public final String imageDescription() {
        return imageDescription;
    }

    /**
     * <p>
     * The supported compute type for the WorkSpace image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ImageComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The supported compute type for the WorkSpace image.
     * @see ImageComputeType
     */
    public final ImageComputeType computeType() {
        return ImageComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * The supported compute type for the WorkSpace image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ImageComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The supported compute type for the WorkSpace image.
     * @see ImageComputeType
     */
    public final String computeTypeAsString() {
        return computeType;
    }

    /**
     * <p>
     * The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link CustomImageProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
     * @see CustomImageProtocol
     */
    public final CustomImageProtocol protocol() {
        return CustomImageProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link CustomImageProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
     * @see CustomImageProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The options for image import source.
     * </p>
     * 
     * @return The options for image import source.
     */
    public final ImageSourceIdentifier imageSource() {
        return imageSource;
    }

    /**
     * <p>
     * The infrastructure configuration ARN that specifies how the WorkSpace image is built.
     * </p>
     * 
     * @return The infrastructure configuration ARN that specifies how the WorkSpace image is built.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The platform for the WorkSpace image source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform for the WorkSpace image source.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform for the WorkSpace image source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform for the WorkSpace image source.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The OS version for the WorkSpace image source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osVersion} will
     * return {@link OSVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osVersionAsString}.
     * </p>
     * 
     * @return The OS version for the WorkSpace image source.
     * @see OSVersion
     */
    public final OSVersion osVersion() {
        return OSVersion.fromValue(osVersion);
    }

    /**
     * <p>
     * The OS version for the WorkSpace image source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osVersion} will
     * return {@link OSVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osVersionAsString}.
     * </p>
     * 
     * @return The OS version for the WorkSpace image source.
     * @see OSVersion
     */
    public final String osVersionAsString() {
        return osVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageSource());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCustomWorkspaceImageRequest)) {
            return false;
        }
        ImportCustomWorkspaceImageRequest other = (ImportCustomWorkspaceImageRequest) obj;
        return Objects.equals(imageName(), other.imageName()) && Objects.equals(imageDescription(), other.imageDescription())
                && Objects.equals(computeTypeAsString(), other.computeTypeAsString())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(imageSource(), other.imageSource())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(osVersionAsString(), other.osVersionAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportCustomWorkspaceImageRequest").add("ImageName", imageName())
                .add("ImageDescription", imageDescription()).add("ComputeType", computeTypeAsString())
                .add("Protocol", protocolAsString()).add("ImageSource", imageSource())
                .add("InfrastructureConfigurationArn", infrastructureConfigurationArn()).add("Platform", platformAsString())
                .add("OsVersion", osVersionAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageDescription":
            return Optional.ofNullable(clazz.cast(imageDescription()));
        case "ComputeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "ImageSource":
            return Optional.ofNullable(clazz.cast(imageSource()));
        case "InfrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "OsVersion":
            return Optional.ofNullable(clazz.cast(osVersionAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("ImageDescription", IMAGE_DESCRIPTION_FIELD);
        map.put("ComputeType", COMPUTE_TYPE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("ImageSource", IMAGE_SOURCE_FIELD);
        map.put("InfrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("OsVersion", OS_VERSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportCustomWorkspaceImageRequest, T> g) {
        return obj -> g.apply((ImportCustomWorkspaceImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportCustomWorkspaceImageRequest> {
        /**
         * <p>
         * The name of the WorkSpace image.
         * </p>
         * 
         * @param imageName
         *        The name of the WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The description of the WorkSpace image.
         * </p>
         * 
         * @param imageDescription
         *        The description of the WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDescription(String imageDescription);

        /**
         * <p>
         * The supported compute type for the WorkSpace image.
         * </p>
         * 
         * @param computeType
         *        The supported compute type for the WorkSpace image.
         * @see ImageComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * The supported compute type for the WorkSpace image.
         * </p>
         * 
         * @param computeType
         *        The supported compute type for the WorkSpace image.
         * @see ImageComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageComputeType
         */
        Builder computeType(ImageComputeType computeType);

        /**
         * <p>
         * The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
         * </p>
         * 
         * @param protocol
         *        The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
         * @see CustomImageProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomImageProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
         * </p>
         * 
         * @param protocol
         *        The supported protocol for the WorkSpace image. Windows 11 does not support PCOIP protocol.
         * @see CustomImageProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomImageProtocol
         */
        Builder protocol(CustomImageProtocol protocol);

        /**
         * <p>
         * The options for image import source.
         * </p>
         * 
         * @param imageSource
         *        The options for image import source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSource(ImageSourceIdentifier imageSource);

        /**
         * <p>
         * The options for image import source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSourceIdentifier.Builder} avoiding
         * the need to create one manually via {@link ImageSourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSourceIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #imageSource(ImageSourceIdentifier)}.
         * 
         * @param imageSource
         *        a consumer that will call methods on {@link ImageSourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageSource(ImageSourceIdentifier)
         */
        default Builder imageSource(Consumer<ImageSourceIdentifier.Builder> imageSource) {
            return imageSource(ImageSourceIdentifier.builder().applyMutation(imageSource).build());
        }

        /**
         * <p>
         * The infrastructure configuration ARN that specifies how the WorkSpace image is built.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The infrastructure configuration ARN that specifies how the WorkSpace image is built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The platform for the WorkSpace image source.
         * </p>
         * 
         * @param platform
         *        The platform for the WorkSpace image source.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform for the WorkSpace image source.
         * </p>
         * 
         * @param platform
         *        The platform for the WorkSpace image source.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The OS version for the WorkSpace image source.
         * </p>
         * 
         * @param osVersion
         *        The OS version for the WorkSpace image source.
         * @see OSVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSVersion
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The OS version for the WorkSpace image source.
         * </p>
         * 
         * @param osVersion
         *        The OS version for the WorkSpace image source.
         * @see OSVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSVersion
         */
        Builder osVersion(OSVersion osVersion);

        /**
         * <p>
         * The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The resource tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String imageName;

        private String imageDescription;

        private String computeType;

        private String protocol;

        private ImageSourceIdentifier imageSource;

        private String infrastructureConfigurationArn;

        private String platform;

        private String osVersion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCustomWorkspaceImageRequest model) {
            super(model);
            imageName(model.imageName);
            imageDescription(model.imageDescription);
            computeType(model.computeType);
            protocol(model.protocol);
            imageSource(model.imageSource);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            platform(model.platform);
            osVersion(model.osVersion);
            tags(model.tags);
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageDescription() {
            return imageDescription;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final String getComputeType() {
            return computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ImageComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(CustomImageProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final ImageSourceIdentifier.Builder getImageSource() {
            return imageSource != null ? imageSource.toBuilder() : null;
        }

        public final void setImageSource(ImageSourceIdentifier.BuilderImpl imageSource) {
            this.imageSource = imageSource != null ? imageSource.build() : null;
        }

        @Override
        public final Builder imageSource(ImageSourceIdentifier imageSource) {
            this.imageSource = imageSource;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public final Builder osVersion(OSVersion osVersion) {
            this.osVersion(osVersion == null ? null : osVersion.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCustomWorkspaceImageRequest build() {
            return new ImportCustomWorkspaceImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
