/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the image import source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageSourceIdentifier.Builder, ImageSourceIdentifier> {
    private static final SdkField<String> EC2_IMPORT_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2ImportTaskId").getter(getter(ImageSourceIdentifier::ec2ImportTaskId))
            .setter(setter(Builder::ec2ImportTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImportTaskId").build()).build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageBuildVersionArn").getter(getter(ImageSourceIdentifier::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuildVersionArn").build())
            .build();

    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2ImageId").getter(getter(ImageSourceIdentifier::ec2ImageId)).setter(setter(Builder::ec2ImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_IMPORT_TASK_ID_FIELD,
            IMAGE_BUILD_VERSION_ARN_FIELD, EC2_IMAGE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ec2ImportTaskId;

    private final String imageBuildVersionArn;

    private final String ec2ImageId;

    private final Type type;

    private ImageSourceIdentifier(BuilderImpl builder) {
        this.ec2ImportTaskId = builder.ec2ImportTaskId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.ec2ImageId = builder.ec2ImageId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The EC2 import task ID to import the image from the Amazon EC2 VM import process.
     * </p>
     * 
     * @return The EC2 import task ID to import the image from the Amazon EC2 VM import process.
     */
    public final String ec2ImportTaskId() {
        return ec2ImportTaskId;
    }

    /**
     * <p>
     * The ARN of the EC2 Image Builder image.
     * </p>
     * 
     * @return The ARN of the EC2 Image Builder image.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The identifier of the EC2 image.
     * </p>
     * 
     * @return The identifier of the EC2 image.
     */
    public final String ec2ImageId() {
        return ec2ImageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2ImportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ImageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSourceIdentifier)) {
            return false;
        }
        ImageSourceIdentifier other = (ImageSourceIdentifier) obj;
        return Objects.equals(ec2ImportTaskId(), other.ec2ImportTaskId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(ec2ImageId(), other.ec2ImageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSourceIdentifier").add("Ec2ImportTaskId", ec2ImportTaskId())
                .add("ImageBuildVersionArn", imageBuildVersionArn()).add("Ec2ImageId", ec2ImageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ec2ImportTaskId":
            return Optional.ofNullable(clazz.cast(ec2ImportTaskId()));
        case "ImageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "Ec2ImageId":
            return Optional.ofNullable(clazz.cast(ec2ImageId()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ec2ImportTaskId()} initialized to the given value.
     *
     * <p>
     * The EC2 import task ID to import the image from the Amazon EC2 VM import process.
     * </p>
     * 
     * @param ec2ImportTaskId
     *        The EC2 import task ID to import the image from the Amazon EC2 VM import process.
     */
    public static ImageSourceIdentifier fromEc2ImportTaskId(String ec2ImportTaskId) {
        return builder().ec2ImportTaskId(ec2ImportTaskId).build();
    }

    /**
     * Create an instance of this class with {@link #imageBuildVersionArn()} initialized to the given value.
     *
     * <p>
     * The ARN of the EC2 Image Builder image.
     * </p>
     * 
     * @param imageBuildVersionArn
     *        The ARN of the EC2 Image Builder image.
     */
    public static ImageSourceIdentifier fromImageBuildVersionArn(String imageBuildVersionArn) {
        return builder().imageBuildVersionArn(imageBuildVersionArn).build();
    }

    /**
     * Create an instance of this class with {@link #ec2ImageId()} initialized to the given value.
     *
     * <p>
     * The identifier of the EC2 image.
     * </p>
     * 
     * @param ec2ImageId
     *        The identifier of the EC2 image.
     */
    public static ImageSourceIdentifier fromEc2ImageId(String ec2ImageId) {
        return builder().ec2ImageId(ec2ImageId).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ec2ImportTaskId", EC2_IMPORT_TASK_ID_FIELD);
        map.put("ImageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("Ec2ImageId", EC2_IMAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSourceIdentifier, T> g) {
        return obj -> g.apply((ImageSourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSourceIdentifier> {
        /**
         * <p>
         * The EC2 import task ID to import the image from the Amazon EC2 VM import process.
         * </p>
         * 
         * @param ec2ImportTaskId
         *        The EC2 import task ID to import the image from the Amazon EC2 VM import process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ImportTaskId(String ec2ImportTaskId);

        /**
         * <p>
         * The ARN of the EC2 Image Builder image.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The ARN of the EC2 Image Builder image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The identifier of the EC2 image.
         * </p>
         * 
         * @param ec2ImageId
         *        The identifier of the EC2 image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ImageId(String ec2ImageId);
    }

    static final class BuilderImpl implements Builder {
        private String ec2ImportTaskId;

        private String imageBuildVersionArn;

        private String ec2ImageId;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSourceIdentifier model) {
            ec2ImportTaskId(model.ec2ImportTaskId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            ec2ImageId(model.ec2ImageId);
        }

        public final String getEc2ImportTaskId() {
            return ec2ImportTaskId;
        }

        public final void setEc2ImportTaskId(String ec2ImportTaskId) {
            Object oldValue = this.ec2ImportTaskId;
            this.ec2ImportTaskId = ec2ImportTaskId;
            handleUnionValueChange(Type.EC2_IMPORT_TASK_ID, oldValue, this.ec2ImportTaskId);
        }

        @Override
        public final Builder ec2ImportTaskId(String ec2ImportTaskId) {
            Object oldValue = this.ec2ImportTaskId;
            this.ec2ImportTaskId = ec2ImportTaskId;
            handleUnionValueChange(Type.EC2_IMPORT_TASK_ID, oldValue, this.ec2ImportTaskId);
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            Object oldValue = this.imageBuildVersionArn;
            this.imageBuildVersionArn = imageBuildVersionArn;
            handleUnionValueChange(Type.IMAGE_BUILD_VERSION_ARN, oldValue, this.imageBuildVersionArn);
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            Object oldValue = this.imageBuildVersionArn;
            this.imageBuildVersionArn = imageBuildVersionArn;
            handleUnionValueChange(Type.IMAGE_BUILD_VERSION_ARN, oldValue, this.imageBuildVersionArn);
            return this;
        }

        public final String getEc2ImageId() {
            return ec2ImageId;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            Object oldValue = this.ec2ImageId;
            this.ec2ImageId = ec2ImageId;
            handleUnionValueChange(Type.EC2_IMAGE_ID, oldValue, this.ec2ImageId);
        }

        @Override
        public final Builder ec2ImageId(String ec2ImageId) {
            Object oldValue = this.ec2ImageId;
            this.ec2ImageId = ec2ImageId;
            handleUnionValueChange(Type.EC2_IMAGE_ID, oldValue, this.ec2ImageId);
            return this;
        }

        @Override
        public ImageSourceIdentifier build() {
            return new ImageSourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ImageSourceIdentifier#type()
     */
    public enum Type {
        EC2_IMPORT_TASK_ID,

        IMAGE_BUILD_VERSION_ARN,

        EC2_IMAGE_ID,

        UNKNOWN_TO_SDK_VERSION
    }
}
