/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the association between an application and an image resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageResourceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageResourceAssociation.Builder, ImageResourceAssociation> {
    private static final SdkField<String> ASSOCIATED_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceId").getter(getter(ImageResourceAssociation::associatedResourceId))
            .setter(setter(Builder::associatedResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceId").build())
            .build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceType").getter(getter(ImageResourceAssociation::associatedResourceTypeAsString))
            .setter(setter(Builder::associatedResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceType").build())
            .build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(ImageResourceAssociation::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ImageResourceAssociation::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(ImageResourceAssociation::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ImageResourceAssociation::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<AssociationStateReason> STATE_REASON_FIELD = SdkField
            .<AssociationStateReason> builder(MarshallingType.SDK_POJO).memberName("StateReason")
            .getter(getter(ImageResourceAssociation::stateReason)).setter(setter(Builder::stateReason))
            .constructor(AssociationStateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_RESOURCE_ID_FIELD,
            ASSOCIATED_RESOURCE_TYPE_FIELD, CREATED_FIELD, LAST_UPDATED_TIME_FIELD, IMAGE_ID_FIELD, STATE_FIELD,
            STATE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associatedResourceId;

    private final String associatedResourceType;

    private final Instant created;

    private final Instant lastUpdatedTime;

    private final String imageId;

    private final String state;

    private final AssociationStateReason stateReason;

    private ImageResourceAssociation(BuilderImpl builder) {
        this.associatedResourceId = builder.associatedResourceId;
        this.associatedResourceType = builder.associatedResourceType;
        this.created = builder.created;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.imageId = builder.imageId;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    /**
     * <p>
     * The identifier of the associated resource.
     * </p>
     * 
     * @return The identifier of the associated resource.
     */
    public final String associatedResourceId() {
        return associatedResourceId;
    }

    /**
     * <p>
     * The resource type of the associated resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #associatedResourceType} will return {@link ImageAssociatedResourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #associatedResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the associated resources.
     * @see ImageAssociatedResourceType
     */
    public final ImageAssociatedResourceType associatedResourceType() {
        return ImageAssociatedResourceType.fromValue(associatedResourceType);
    }

    /**
     * <p>
     * The resource type of the associated resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #associatedResourceType} will return {@link ImageAssociatedResourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #associatedResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the associated resources.
     * @see ImageAssociatedResourceType
     */
    public final String associatedResourceTypeAsString() {
        return associatedResourceType;
    }

    /**
     * <p>
     * The time the association is created.
     * </p>
     * 
     * @return The time the association is created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The time the association status was last updated.
     * </p>
     * 
     * @return The time the association status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The identifier of the image.
     * </p>
     * 
     * @return The identifier of the image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The status of the image resource association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the image resource association.
     * @see AssociationState
     */
    public final AssociationState state() {
        return AssociationState.fromValue(state);
    }

    /**
     * <p>
     * The status of the image resource association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the image resource association.
     * @see AssociationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason the association deployment failed.
     * </p>
     * 
     * @return The reason the association deployment failed.
     */
    public final AssociationStateReason stateReason() {
        return stateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageResourceAssociation)) {
            return false;
        }
        ImageResourceAssociation other = (ImageResourceAssociation) obj;
        return Objects.equals(associatedResourceId(), other.associatedResourceId())
                && Objects.equals(associatedResourceTypeAsString(), other.associatedResourceTypeAsString())
                && Objects.equals(created(), other.created()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageResourceAssociation").add("AssociatedResourceId", associatedResourceId())
                .add("AssociatedResourceType", associatedResourceTypeAsString()).add("Created", created())
                .add("LastUpdatedTime", lastUpdatedTime()).add("ImageId", imageId()).add("State", stateAsString())
                .add("StateReason", stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedResourceId":
            return Optional.ofNullable(clazz.cast(associatedResourceId()));
        case "AssociatedResourceType":
            return Optional.ofNullable(clazz.cast(associatedResourceTypeAsString()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociatedResourceId", ASSOCIATED_RESOURCE_ID_FIELD);
        map.put("AssociatedResourceType", ASSOCIATED_RESOURCE_TYPE_FIELD);
        map.put("Created", CREATED_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageResourceAssociation, T> g) {
        return obj -> g.apply((ImageResourceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageResourceAssociation> {
        /**
         * <p>
         * The identifier of the associated resource.
         * </p>
         * 
         * @param associatedResourceId
         *        The identifier of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceId(String associatedResourceId);

        /**
         * <p>
         * The resource type of the associated resources.
         * </p>
         * 
         * @param associatedResourceType
         *        The resource type of the associated resources.
         * @see ImageAssociatedResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageAssociatedResourceType
         */
        Builder associatedResourceType(String associatedResourceType);

        /**
         * <p>
         * The resource type of the associated resources.
         * </p>
         * 
         * @param associatedResourceType
         *        The resource type of the associated resources.
         * @see ImageAssociatedResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageAssociatedResourceType
         */
        Builder associatedResourceType(ImageAssociatedResourceType associatedResourceType);

        /**
         * <p>
         * The time the association is created.
         * </p>
         * 
         * @param created
         *        The time the association is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The time the association status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the association status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The identifier of the image.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The status of the image resource association.
         * </p>
         * 
         * @param state
         *        The status of the image resource association.
         * @see AssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the image resource association.
         * </p>
         * 
         * @param state
         *        The status of the image resource association.
         * @see AssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationState
         */
        Builder state(AssociationState state);

        /**
         * <p>
         * The reason the association deployment failed.
         * </p>
         * 
         * @param stateReason
         *        The reason the association deployment failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(AssociationStateReason stateReason);

        /**
         * <p>
         * The reason the association deployment failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationStateReason.Builder} avoiding
         * the need to create one manually via {@link AssociationStateReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociationStateReason.Builder#build()} is called immediately and
         * its result is passed to {@link #stateReason(AssociationStateReason)}.
         * 
         * @param stateReason
         *        a consumer that will call methods on {@link AssociationStateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateReason(AssociationStateReason)
         */
        default Builder stateReason(Consumer<AssociationStateReason.Builder> stateReason) {
            return stateReason(AssociationStateReason.builder().applyMutation(stateReason).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associatedResourceId;

        private String associatedResourceType;

        private Instant created;

        private Instant lastUpdatedTime;

        private String imageId;

        private String state;

        private AssociationStateReason stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageResourceAssociation model) {
            associatedResourceId(model.associatedResourceId);
            associatedResourceType(model.associatedResourceType);
            created(model.created);
            lastUpdatedTime(model.lastUpdatedTime);
            imageId(model.imageId);
            state(model.state);
            stateReason(model.stateReason);
        }

        public final String getAssociatedResourceId() {
            return associatedResourceId;
        }

        public final void setAssociatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
        }

        @Override
        public final Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            return this;
        }

        public final String getAssociatedResourceType() {
            return associatedResourceType;
        }

        public final void setAssociatedResourceType(String associatedResourceType) {
            this.associatedResourceType = associatedResourceType;
        }

        @Override
        public final Builder associatedResourceType(String associatedResourceType) {
            this.associatedResourceType = associatedResourceType;
            return this;
        }

        @Override
        public final Builder associatedResourceType(ImageAssociatedResourceType associatedResourceType) {
            this.associatedResourceType(associatedResourceType == null ? null : associatedResourceType.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final AssociationStateReason.Builder getStateReason() {
            return stateReason != null ? stateReason.toBuilder() : null;
        }

        public final void setStateReason(AssociationStateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(AssociationStateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        @Override
        public ImageResourceAssociation build() {
            return new ImageResourceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
