/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceAssociationsResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspaceAssociationsResponse.Builder, DescribeWorkspaceAssociationsResponse> {
    private static final SdkField<List<WorkspaceResourceAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<WorkspaceResourceAssociation>> builder(MarshallingType.LIST)
            .memberName("Associations")
            .getter(getter(DescribeWorkspaceAssociationsResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceResourceAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceResourceAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkspaceResourceAssociation> associations;

    private DescribeWorkspaceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of information about the specified associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return List of information about the specified associations.
     */
    public final List<WorkspaceResourceAssociation> associations() {
        return associations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceAssociationsResponse)) {
            return false;
        }
        DescribeWorkspaceAssociationsResponse other = (DescribeWorkspaceAssociationsResponse) obj;
        return hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceAssociationsResponse")
                .add("Associations", hasAssociations() ? associations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Associations", ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceAssociationsResponse> {
        /**
         * <p>
         * List of information about the specified associations.
         * </p>
         * 
         * @param associations
         *        List of information about the specified associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<WorkspaceResourceAssociation> associations);

        /**
         * <p>
         * List of information about the specified associations.
         * </p>
         * 
         * @param associations
         *        List of information about the specified associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(WorkspaceResourceAssociation... associations);

        /**
         * <p>
         * List of information about the specified associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link #associations(List<WorkspaceResourceAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<WorkspaceResourceAssociation>)
         */
        Builder associations(Consumer<WorkspaceResourceAssociation.Builder>... associations);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<WorkspaceResourceAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceAssociationsResponse model) {
            super(model);
            associations(model.associations);
        }

        public final List<WorkspaceResourceAssociation.Builder> getAssociations() {
            List<WorkspaceResourceAssociation.Builder> result = WorkspaceResourceAssociationListCopier
                    .copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<WorkspaceResourceAssociation.BuilderImpl> associations) {
            this.associations = WorkspaceResourceAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<WorkspaceResourceAssociation> associations) {
            this.associations = WorkspaceResourceAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(WorkspaceResourceAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<WorkspaceResourceAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> WorkspaceResourceAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeWorkspaceAssociationsResponse build() {
            return new DescribeWorkspaceAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
