/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomWorkspaceImageImportResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeCustomWorkspaceImageImportResponse.Builder, DescribeCustomWorkspaceImageImportResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(DescribeCustomWorkspaceImageImportResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InfrastructureConfigurationArn")
            .getter(getter(DescribeCustomWorkspaceImageImportResponse::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeCustomWorkspaceImageImportResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(DescribeCustomWorkspaceImageImportResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeCustomWorkspaceImageImportResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<ImageSourceIdentifier> IMAGE_SOURCE_FIELD = SdkField
            .<ImageSourceIdentifier> builder(MarshallingType.SDK_POJO).memberName("ImageSource")
            .getter(getter(DescribeCustomWorkspaceImageImportResponse::imageSource)).setter(setter(Builder::imageSource))
            .constructor(ImageSourceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSource").build()).build();

    private static final SdkField<String> IMAGE_BUILDER_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageBuilderInstanceId")
            .getter(getter(DescribeCustomWorkspaceImageImportResponse::imageBuilderInstanceId))
            .setter(setter(Builder::imageBuilderInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderInstanceId").build())
            .build();

    private static final SdkField<List<CustomWorkspaceImageImportErrorDetails>> ERROR_DETAILS_FIELD = SdkField
            .<List<CustomWorkspaceImageImportErrorDetails>> builder(MarshallingType.LIST)
            .memberName("ErrorDetails")
            .getter(getter(DescribeCustomWorkspaceImageImportResponse::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomWorkspaceImageImportErrorDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomWorkspaceImageImportErrorDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, STATE_FIELD, CREATED_FIELD, LAST_UPDATED_TIME_FIELD, IMAGE_SOURCE_FIELD,
            IMAGE_BUILDER_INSTANCE_ID_FIELD, ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String imageId;

    private final String infrastructureConfigurationArn;

    private final String state;

    private final Instant created;

    private final Instant lastUpdatedTime;

    private final ImageSourceIdentifier imageSource;

    private final String imageBuilderInstanceId;

    private final List<CustomWorkspaceImageImportErrorDetails> errorDetails;

    private DescribeCustomWorkspaceImageImportResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.state = builder.state;
        this.created = builder.created;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.imageSource = builder.imageSource;
        this.imageBuilderInstanceId = builder.imageBuilderInstanceId;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The identifier of the WorkSpace image.
     * </p>
     * 
     * @return The identifier of the WorkSpace image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The infrastructure configuration ARN that specifies how the WorkSpace image is built.
     * </p>
     * 
     * @return The infrastructure configuration ARN that specifies how the WorkSpace image is built.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The state of the WorkSpace image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CustomWorkspaceImageImportState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the WorkSpace image.
     * @see CustomWorkspaceImageImportState
     */
    public final CustomWorkspaceImageImportState state() {
        return CustomWorkspaceImageImportState.fromValue(state);
    }

    /**
     * <p>
     * The state of the WorkSpace image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CustomWorkspaceImageImportState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the WorkSpace image.
     * @see CustomWorkspaceImageImportState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp when the WorkSpace image import was created.
     * </p>
     * 
     * @return The timestamp when the WorkSpace image import was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The timestamp when the WorkSpace image import was last updated.
     * </p>
     * 
     * @return The timestamp when the WorkSpace image import was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Describes the image import source.
     * </p>
     * 
     * @return Describes the image import source.
     */
    public final ImageSourceIdentifier imageSource() {
        return imageSource;
    }

    /**
     * <p>
     * The image builder instance ID of the WorkSpace image.
     * </p>
     * 
     * @return The image builder instance ID of the WorkSpace image.
     */
    public final String imageBuilderInstanceId() {
        return imageBuilderInstanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorDetails() {
        return errorDetails != null && !(errorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes in-depth details about the error. These details include the possible causes of the error and
     * troubleshooting information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorDetails} method.
     * </p>
     * 
     * @return Describes in-depth details about the error. These details include the possible causes of the error and
     *         troubleshooting information.
     */
    public final List<CustomWorkspaceImageImportErrorDetails> errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(imageSource());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilderInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorDetails() ? errorDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomWorkspaceImageImportResponse)) {
            return false;
        }
        DescribeCustomWorkspaceImageImportResponse other = (DescribeCustomWorkspaceImageImportResponse) obj;
        return Objects.equals(imageId(), other.imageId())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(created(), other.created())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(imageSource(), other.imageSource())
                && Objects.equals(imageBuilderInstanceId(), other.imageBuilderInstanceId())
                && hasErrorDetails() == other.hasErrorDetails() && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomWorkspaceImageImportResponse").add("ImageId", imageId())
                .add("InfrastructureConfigurationArn", infrastructureConfigurationArn()).add("State", stateAsString())
                .add("Created", created()).add("LastUpdatedTime", lastUpdatedTime()).add("ImageSource", imageSource())
                .add("ImageBuilderInstanceId", imageBuilderInstanceId())
                .add("ErrorDetails", hasErrorDetails() ? errorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InfrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ImageSource":
            return Optional.ofNullable(clazz.cast(imageSource()));
        case "ImageBuilderInstanceId":
            return Optional.ofNullable(clazz.cast(imageBuilderInstanceId()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("InfrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Created", CREATED_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("ImageSource", IMAGE_SOURCE_FIELD);
        map.put("ImageBuilderInstanceId", IMAGE_BUILDER_INSTANCE_ID_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomWorkspaceImageImportResponse, T> g) {
        return obj -> g.apply((DescribeCustomWorkspaceImageImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomWorkspaceImageImportResponse> {
        /**
         * <p>
         * The identifier of the WorkSpace image.
         * </p>
         * 
         * @param imageId
         *        The identifier of the WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The infrastructure configuration ARN that specifies how the WorkSpace image is built.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The infrastructure configuration ARN that specifies how the WorkSpace image is built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The state of the WorkSpace image.
         * </p>
         * 
         * @param state
         *        The state of the WorkSpace image.
         * @see CustomWorkspaceImageImportState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomWorkspaceImageImportState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the WorkSpace image.
         * </p>
         * 
         * @param state
         *        The state of the WorkSpace image.
         * @see CustomWorkspaceImageImportState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomWorkspaceImageImportState
         */
        Builder state(CustomWorkspaceImageImportState state);

        /**
         * <p>
         * The timestamp when the WorkSpace image import was created.
         * </p>
         * 
         * @param created
         *        The timestamp when the WorkSpace image import was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The timestamp when the WorkSpace image import was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the WorkSpace image import was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Describes the image import source.
         * </p>
         * 
         * @param imageSource
         *        Describes the image import source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSource(ImageSourceIdentifier imageSource);

        /**
         * <p>
         * Describes the image import source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSourceIdentifier.Builder} avoiding
         * the need to create one manually via {@link ImageSourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSourceIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #imageSource(ImageSourceIdentifier)}.
         * 
         * @param imageSource
         *        a consumer that will call methods on {@link ImageSourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageSource(ImageSourceIdentifier)
         */
        default Builder imageSource(Consumer<ImageSourceIdentifier.Builder> imageSource) {
            return imageSource(ImageSourceIdentifier.builder().applyMutation(imageSource).build());
        }

        /**
         * <p>
         * The image builder instance ID of the WorkSpace image.
         * </p>
         * 
         * @param imageBuilderInstanceId
         *        The image builder instance ID of the WorkSpace image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilderInstanceId(String imageBuilderInstanceId);

        /**
         * <p>
         * Describes in-depth details about the error. These details include the possible causes of the error and
         * troubleshooting information.
         * </p>
         * 
         * @param errorDetails
         *        Describes in-depth details about the error. These details include the possible causes of the error and
         *        troubleshooting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(Collection<CustomWorkspaceImageImportErrorDetails> errorDetails);

        /**
         * <p>
         * Describes in-depth details about the error. These details include the possible causes of the error and
         * troubleshooting information.
         * </p>
         * 
         * @param errorDetails
         *        Describes in-depth details about the error. These details include the possible causes of the error and
         *        troubleshooting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(CustomWorkspaceImageImportErrorDetails... errorDetails);

        /**
         * <p>
         * Describes in-depth details about the error. These details include the possible causes of the error and
         * troubleshooting information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportErrorDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportErrorDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errorDetails(List<CustomWorkspaceImageImportErrorDetails>)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.CustomWorkspaceImageImportErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(java.util.Collection<CustomWorkspaceImageImportErrorDetails>)
         */
        Builder errorDetails(Consumer<CustomWorkspaceImageImportErrorDetails.Builder>... errorDetails);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String imageId;

        private String infrastructureConfigurationArn;

        private String state;

        private Instant created;

        private Instant lastUpdatedTime;

        private ImageSourceIdentifier imageSource;

        private String imageBuilderInstanceId;

        private List<CustomWorkspaceImageImportErrorDetails> errorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomWorkspaceImageImportResponse model) {
            super(model);
            imageId(model.imageId);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            state(model.state);
            created(model.created);
            lastUpdatedTime(model.lastUpdatedTime);
            imageSource(model.imageSource);
            imageBuilderInstanceId(model.imageBuilderInstanceId);
            errorDetails(model.errorDetails);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CustomWorkspaceImageImportState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final ImageSourceIdentifier.Builder getImageSource() {
            return imageSource != null ? imageSource.toBuilder() : null;
        }

        public final void setImageSource(ImageSourceIdentifier.BuilderImpl imageSource) {
            this.imageSource = imageSource != null ? imageSource.build() : null;
        }

        @Override
        public final Builder imageSource(ImageSourceIdentifier imageSource) {
            this.imageSource = imageSource;
            return this;
        }

        public final String getImageBuilderInstanceId() {
            return imageBuilderInstanceId;
        }

        public final void setImageBuilderInstanceId(String imageBuilderInstanceId) {
            this.imageBuilderInstanceId = imageBuilderInstanceId;
        }

        @Override
        public final Builder imageBuilderInstanceId(String imageBuilderInstanceId) {
            this.imageBuilderInstanceId = imageBuilderInstanceId;
            return this;
        }

        public final List<CustomWorkspaceImageImportErrorDetails.Builder> getErrorDetails() {
            List<CustomWorkspaceImageImportErrorDetails.Builder> result = CustomWorkspaceImageImportErrorDetailsListCopier
                    .copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<CustomWorkspaceImageImportErrorDetails.BuilderImpl> errorDetails) {
            this.errorDetails = CustomWorkspaceImageImportErrorDetailsListCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<CustomWorkspaceImageImportErrorDetails> errorDetails) {
            this.errorDetails = CustomWorkspaceImageImportErrorDetailsListCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(CustomWorkspaceImageImportErrorDetails... errorDetails) {
            errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<CustomWorkspaceImageImportErrorDetails.Builder>... errorDetails) {
            errorDetails(Stream.of(errorDetails)
                    .map(c -> CustomWorkspaceImageImportErrorDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCustomWorkspaceImageImportResponse build() {
            return new DescribeCustomWorkspaceImageImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
