/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStandbyWorkspacesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<CreateStandbyWorkspacesResponse.Builder, CreateStandbyWorkspacesResponse> {
    private static final SdkField<List<FailedCreateStandbyWorkspacesRequest>> FAILED_STANDBY_REQUESTS_FIELD = SdkField
            .<List<FailedCreateStandbyWorkspacesRequest>> builder(MarshallingType.LIST)
            .memberName("FailedStandbyRequests")
            .getter(getter(CreateStandbyWorkspacesResponse::failedStandbyRequests))
            .setter(setter(Builder::failedStandbyRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedStandbyRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedCreateStandbyWorkspacesRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedCreateStandbyWorkspacesRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PendingCreateStandbyWorkspacesRequest>> PENDING_STANDBY_REQUESTS_FIELD = SdkField
            .<List<PendingCreateStandbyWorkspacesRequest>> builder(MarshallingType.LIST)
            .memberName("PendingStandbyRequests")
            .getter(getter(CreateStandbyWorkspacesResponse::pendingStandbyRequests))
            .setter(setter(Builder::pendingStandbyRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingStandbyRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingCreateStandbyWorkspacesRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingCreateStandbyWorkspacesRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_STANDBY_REQUESTS_FIELD,
            PENDING_STANDBY_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests;

    private final List<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests;

    private CreateStandbyWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.failedStandbyRequests = builder.failedStandbyRequests;
        this.pendingStandbyRequests = builder.pendingStandbyRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedStandbyRequests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedStandbyRequests() {
        return failedStandbyRequests != null && !(failedStandbyRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the standby WorkSpace that could not be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedStandbyRequests} method.
     * </p>
     * 
     * @return Information about the standby WorkSpace that could not be created.
     */
    public final List<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests() {
        return failedStandbyRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingStandbyRequests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPendingStandbyRequests() {
        return pendingStandbyRequests != null && !(pendingStandbyRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the standby WorkSpace that was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingStandbyRequests} method.
     * </p>
     * 
     * @return Information about the standby WorkSpace that was created.
     */
    public final List<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests() {
        return pendingStandbyRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedStandbyRequests() ? failedStandbyRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingStandbyRequests() ? pendingStandbyRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStandbyWorkspacesResponse)) {
            return false;
        }
        CreateStandbyWorkspacesResponse other = (CreateStandbyWorkspacesResponse) obj;
        return hasFailedStandbyRequests() == other.hasFailedStandbyRequests()
                && Objects.equals(failedStandbyRequests(), other.failedStandbyRequests())
                && hasPendingStandbyRequests() == other.hasPendingStandbyRequests()
                && Objects.equals(pendingStandbyRequests(), other.pendingStandbyRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStandbyWorkspacesResponse")
                .add("FailedStandbyRequests", hasFailedStandbyRequests() ? failedStandbyRequests() : null)
                .add("PendingStandbyRequests", hasPendingStandbyRequests() ? pendingStandbyRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedStandbyRequests":
            return Optional.ofNullable(clazz.cast(failedStandbyRequests()));
        case "PendingStandbyRequests":
            return Optional.ofNullable(clazz.cast(pendingStandbyRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedStandbyRequests", FAILED_STANDBY_REQUESTS_FIELD);
        map.put("PendingStandbyRequests", PENDING_STANDBY_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStandbyWorkspacesResponse, T> g) {
        return obj -> g.apply((CreateStandbyWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStandbyWorkspacesResponse> {
        /**
         * <p>
         * Information about the standby WorkSpace that could not be created.
         * </p>
         * 
         * @param failedStandbyRequests
         *        Information about the standby WorkSpace that could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedStandbyRequests(Collection<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests);

        /**
         * <p>
         * Information about the standby WorkSpace that could not be created.
         * </p>
         * 
         * @param failedStandbyRequests
         *        Information about the standby WorkSpace that could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedStandbyRequests(FailedCreateStandbyWorkspacesRequest... failedStandbyRequests);

        /**
         * <p>
         * Information about the standby WorkSpace that could not be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedStandbyRequests(List<FailedCreateStandbyWorkspacesRequest>)}.
         * 
         * @param failedStandbyRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedStandbyRequests(java.util.Collection<FailedCreateStandbyWorkspacesRequest>)
         */
        Builder failedStandbyRequests(Consumer<FailedCreateStandbyWorkspacesRequest.Builder>... failedStandbyRequests);

        /**
         * <p>
         * Information about the standby WorkSpace that was created.
         * </p>
         * 
         * @param pendingStandbyRequests
         *        Information about the standby WorkSpace that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingStandbyRequests(Collection<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests);

        /**
         * <p>
         * Information about the standby WorkSpace that was created.
         * </p>
         * 
         * @param pendingStandbyRequests
         *        Information about the standby WorkSpace that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingStandbyRequests(PendingCreateStandbyWorkspacesRequest... pendingStandbyRequests);

        /**
         * <p>
         * Information about the standby WorkSpace that was created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #pendingStandbyRequests(List<PendingCreateStandbyWorkspacesRequest>)}.
         * 
         * @param pendingStandbyRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingStandbyRequests(java.util.Collection<PendingCreateStandbyWorkspacesRequest>)
         */
        Builder pendingStandbyRequests(Consumer<PendingCreateStandbyWorkspacesRequest.Builder>... pendingStandbyRequests);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests = DefaultSdkAutoConstructList.getInstance();

        private List<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStandbyWorkspacesResponse model) {
            super(model);
            failedStandbyRequests(model.failedStandbyRequests);
            pendingStandbyRequests(model.pendingStandbyRequests);
        }

        public final List<FailedCreateStandbyWorkspacesRequest.Builder> getFailedStandbyRequests() {
            List<FailedCreateStandbyWorkspacesRequest.Builder> result = FailedCreateStandbyWorkspacesRequestListCopier
                    .copyToBuilder(this.failedStandbyRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedStandbyRequests(
                Collection<FailedCreateStandbyWorkspacesRequest.BuilderImpl> failedStandbyRequests) {
            this.failedStandbyRequests = FailedCreateStandbyWorkspacesRequestListCopier.copyFromBuilder(failedStandbyRequests);
        }

        @Override
        public final Builder failedStandbyRequests(Collection<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests) {
            this.failedStandbyRequests = FailedCreateStandbyWorkspacesRequestListCopier.copy(failedStandbyRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedStandbyRequests(FailedCreateStandbyWorkspacesRequest... failedStandbyRequests) {
            failedStandbyRequests(Arrays.asList(failedStandbyRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedStandbyRequests(
                Consumer<FailedCreateStandbyWorkspacesRequest.Builder>... failedStandbyRequests) {
            failedStandbyRequests(Stream.of(failedStandbyRequests)
                    .map(c -> FailedCreateStandbyWorkspacesRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PendingCreateStandbyWorkspacesRequest.Builder> getPendingStandbyRequests() {
            List<PendingCreateStandbyWorkspacesRequest.Builder> result = PendingCreateStandbyWorkspacesRequestListCopier
                    .copyToBuilder(this.pendingStandbyRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingStandbyRequests(
                Collection<PendingCreateStandbyWorkspacesRequest.BuilderImpl> pendingStandbyRequests) {
            this.pendingStandbyRequests = PendingCreateStandbyWorkspacesRequestListCopier.copyFromBuilder(pendingStandbyRequests);
        }

        @Override
        public final Builder pendingStandbyRequests(Collection<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests) {
            this.pendingStandbyRequests = PendingCreateStandbyWorkspacesRequestListCopier.copy(pendingStandbyRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingStandbyRequests(PendingCreateStandbyWorkspacesRequest... pendingStandbyRequests) {
            pendingStandbyRequests(Arrays.asList(pendingStandbyRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingStandbyRequests(
                Consumer<PendingCreateStandbyWorkspacesRequest.Builder>... pendingStandbyRequests) {
            pendingStandbyRequests(Stream.of(pendingStandbyRequests)
                    .map(c -> PendingCreateStandbyWorkspacesRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateStandbyWorkspacesResponse build() {
            return new CreateStandbyWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
