/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the access endpoint configuration for a WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessEndpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessEndpointConfig.Builder, AccessEndpointConfig> {
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField
            .<List<AccessEndpoint>> builder(MarshallingType.LIST)
            .memberName("AccessEndpoints")
            .getter(getter(AccessEndpointConfig::accessEndpoints))
            .setter(setter(Builder::accessEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INTERNET_FALLBACK_PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InternetFallbackProtocols")
            .getter(getter(AccessEndpointConfig::internetFallbackProtocolsAsStrings))
            .setter(setter(Builder::internetFallbackProtocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetFallbackProtocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ENDPOINTS_FIELD,
            INTERNET_FALLBACK_PROTOCOLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AccessEndpoint> accessEndpoints;

    private final List<String> internetFallbackProtocols;

    private AccessEndpointConfig(BuilderImpl builder) {
        this.accessEndpoints = builder.accessEndpoints;
        this.internetFallbackProtocols = builder.internetFallbackProtocols;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessEndpoints() {
        return accessEndpoints != null && !(accessEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates a list of access endpoints associated with this directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessEndpoints} method.
     * </p>
     * 
     * @return Indicates a list of access endpoints associated with this directory.
     */
    public final List<AccessEndpoint> accessEndpoints() {
        return accessEndpoints;
    }

    /**
     * <p>
     * Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC endpoint is
     * not available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInternetFallbackProtocols} method.
     * </p>
     * 
     * @return Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC
     *         endpoint is not available.
     */
    public final List<InternetFallbackProtocol> internetFallbackProtocols() {
        return InternetFallbackProtocolListCopier.copyStringToEnum(internetFallbackProtocols);
    }

    /**
     * For responses, this returns true if the service returned a value for the InternetFallbackProtocols property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInternetFallbackProtocols() {
        return internetFallbackProtocols != null && !(internetFallbackProtocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC endpoint is
     * not available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInternetFallbackProtocols} method.
     * </p>
     * 
     * @return Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC
     *         endpoint is not available.
     */
    public final List<String> internetFallbackProtocolsAsStrings() {
        return internetFallbackProtocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessEndpoints() ? accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInternetFallbackProtocols() ? internetFallbackProtocolsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEndpointConfig)) {
            return false;
        }
        AccessEndpointConfig other = (AccessEndpointConfig) obj;
        return hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(accessEndpoints(), other.accessEndpoints())
                && hasInternetFallbackProtocols() == other.hasInternetFallbackProtocols()
                && Objects.equals(internetFallbackProtocolsAsStrings(), other.internetFallbackProtocolsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessEndpointConfig").add("AccessEndpoints", hasAccessEndpoints() ? accessEndpoints() : null)
                .add("InternetFallbackProtocols", hasInternetFallbackProtocols() ? internetFallbackProtocolsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessEndpoints":
            return Optional.ofNullable(clazz.cast(accessEndpoints()));
        case "InternetFallbackProtocols":
            return Optional.ofNullable(clazz.cast(internetFallbackProtocolsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessEndpoints", ACCESS_ENDPOINTS_FIELD);
        map.put("InternetFallbackProtocols", INTERNET_FALLBACK_PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessEndpointConfig, T> g) {
        return obj -> g.apply((AccessEndpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessEndpointConfig> {
        /**
         * <p>
         * Indicates a list of access endpoints associated with this directory.
         * </p>
         * 
         * @param accessEndpoints
         *        Indicates a list of access endpoints associated with this directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints);

        /**
         * <p>
         * Indicates a list of access endpoints associated with this directory.
         * </p>
         * 
         * @param accessEndpoints
         *        Indicates a list of access endpoints associated with this directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(AccessEndpoint... accessEndpoints);

        /**
         * <p>
         * Indicates a list of access endpoints associated with this directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.AccessEndpoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workspaces.model.AccessEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.AccessEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #accessEndpoints(List<AccessEndpoint>)}.
         * 
         * @param accessEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.AccessEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpoints(java.util.Collection<AccessEndpoint>)
         */
        Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints);

        /**
         * <p>
         * Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC endpoint
         * is not available.
         * </p>
         * 
         * @param internetFallbackProtocols
         *        Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC
         *        endpoint is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetFallbackProtocolsWithStrings(Collection<String> internetFallbackProtocols);

        /**
         * <p>
         * Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC endpoint
         * is not available.
         * </p>
         * 
         * @param internetFallbackProtocols
         *        Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC
         *        endpoint is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetFallbackProtocolsWithStrings(String... internetFallbackProtocols);

        /**
         * <p>
         * Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC endpoint
         * is not available.
         * </p>
         * 
         * @param internetFallbackProtocols
         *        Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC
         *        endpoint is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetFallbackProtocols(Collection<InternetFallbackProtocol> internetFallbackProtocols);

        /**
         * <p>
         * Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC endpoint
         * is not available.
         * </p>
         * 
         * @param internetFallbackProtocols
         *        Indicates a list of protocols that fallback to using the public Internet when streaming over a VPC
         *        endpoint is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetFallbackProtocols(InternetFallbackProtocol... internetFallbackProtocols);
    }

    static final class BuilderImpl implements Builder {
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> internetFallbackProtocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEndpointConfig model) {
            accessEndpoints(model.accessEndpoints);
            internetFallbackProtocolsWithStrings(model.internetFallbackProtocols);
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint... accessEndpoints) {
            accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints) {
            accessEndpoints(Stream.of(accessEndpoints).map(c -> AccessEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInternetFallbackProtocols() {
            if (internetFallbackProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return internetFallbackProtocols;
        }

        public final void setInternetFallbackProtocols(Collection<String> internetFallbackProtocols) {
            this.internetFallbackProtocols = InternetFallbackProtocolListCopier.copy(internetFallbackProtocols);
        }

        @Override
        public final Builder internetFallbackProtocolsWithStrings(Collection<String> internetFallbackProtocols) {
            this.internetFallbackProtocols = InternetFallbackProtocolListCopier.copy(internetFallbackProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetFallbackProtocolsWithStrings(String... internetFallbackProtocols) {
            internetFallbackProtocolsWithStrings(Arrays.asList(internetFallbackProtocols));
            return this;
        }

        @Override
        public final Builder internetFallbackProtocols(Collection<InternetFallbackProtocol> internetFallbackProtocols) {
            this.internetFallbackProtocols = InternetFallbackProtocolListCopier.copyEnumToString(internetFallbackProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetFallbackProtocols(InternetFallbackProtocol... internetFallbackProtocols) {
            internetFallbackProtocols(Arrays.asList(internetFallbackProtocols));
            return this;
        }

        @Override
        public AccessEndpointConfig build() {
            return new AccessEndpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
