/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AssociationState;
import software.amazon.awssdk.services.workspaces.model.AssociationStateReason;
import software.amazon.awssdk.services.workspaces.model.WorkSpaceAssociatedResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceResourceAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceResourceAssociation> {
    private static final SdkField<String> ASSOCIATED_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceId").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::associatedResourceId)).setter(WorkspaceResourceAssociation.setter(Builder::associatedResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceId").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceType").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::associatedResourceTypeAsString)).setter(WorkspaceResourceAssociation.setter(Builder::associatedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceType").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::created)).setter(WorkspaceResourceAssociation.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::lastUpdatedTime)).setter(WorkspaceResourceAssociation.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::stateAsString)).setter(WorkspaceResourceAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<AssociationStateReason> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateReason").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::stateReason)).setter(WorkspaceResourceAssociation.setter(Builder::stateReason)).constructor(AssociationStateReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(WorkspaceResourceAssociation.getter(WorkspaceResourceAssociation::workspaceId)).setter(WorkspaceResourceAssociation.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_RESOURCE_ID_FIELD, ASSOCIATED_RESOURCE_TYPE_FIELD, CREATED_FIELD, LAST_UPDATED_TIME_FIELD, STATE_FIELD, STATE_REASON_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceResourceAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associatedResourceId;
    private final String associatedResourceType;
    private final Instant created;
    private final Instant lastUpdatedTime;
    private final String state;
    private final AssociationStateReason stateReason;
    private final String workspaceId;

    private WorkspaceResourceAssociation(BuilderImpl builder) {
        this.associatedResourceId = builder.associatedResourceId;
        this.associatedResourceType = builder.associatedResourceType;
        this.created = builder.created;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.workspaceId = builder.workspaceId;
    }

    public final String associatedResourceId() {
        return this.associatedResourceId;
    }

    public final WorkSpaceAssociatedResourceType associatedResourceType() {
        return WorkSpaceAssociatedResourceType.fromValue(this.associatedResourceType);
    }

    public final String associatedResourceTypeAsString() {
        return this.associatedResourceType;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final AssociationState state() {
        return AssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final AssociationStateReason stateReason() {
        return this.stateReason;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceResourceAssociation)) {
            return false;
        }
        WorkspaceResourceAssociation other = (WorkspaceResourceAssociation)obj;
        return Objects.equals(this.associatedResourceId(), other.associatedResourceId()) && Objects.equals(this.associatedResourceTypeAsString(), other.associatedResourceTypeAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceResourceAssociation").add("AssociatedResourceId", (Object)this.associatedResourceId()).add("AssociatedResourceType", (Object)this.associatedResourceTypeAsString()).add("Created", (Object)this.created()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedResourceId": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceId()));
            }
            case "AssociatedResourceType": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceTypeAsString()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociatedResourceId", ASSOCIATED_RESOURCE_ID_FIELD);
        map.put("AssociatedResourceType", ASSOCIATED_RESOURCE_TYPE_FIELD);
        map.put("Created", CREATED_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceResourceAssociation, T> g) {
        return obj -> g.apply((WorkspaceResourceAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associatedResourceId;
        private String associatedResourceType;
        private Instant created;
        private Instant lastUpdatedTime;
        private String state;
        private AssociationStateReason stateReason;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceResourceAssociation model) {
            this.associatedResourceId(model.associatedResourceId);
            this.associatedResourceType(model.associatedResourceType);
            this.created(model.created);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.workspaceId(model.workspaceId);
        }

        public final String getAssociatedResourceId() {
            return this.associatedResourceId;
        }

        public final void setAssociatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
        }

        @Override
        public final Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            return this;
        }

        public final String getAssociatedResourceType() {
            return this.associatedResourceType;
        }

        public final void setAssociatedResourceType(String associatedResourceType) {
            this.associatedResourceType = associatedResourceType;
        }

        @Override
        public final Builder associatedResourceType(String associatedResourceType) {
            this.associatedResourceType = associatedResourceType;
            return this;
        }

        @Override
        public final Builder associatedResourceType(WorkSpaceAssociatedResourceType associatedResourceType) {
            this.associatedResourceType(associatedResourceType == null ? null : associatedResourceType.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final AssociationStateReason.Builder getStateReason() {
            return this.stateReason != null ? this.stateReason.toBuilder() : null;
        }

        public final void setStateReason(AssociationStateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(AssociationStateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public WorkspaceResourceAssociation build() {
            return new WorkspaceResourceAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceResourceAssociation> {
        public Builder associatedResourceId(String var1);

        public Builder associatedResourceType(String var1);

        public Builder associatedResourceType(WorkSpaceAssociatedResourceType var1);

        public Builder created(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder state(String var1);

        public Builder state(AssociationState var1);

        public Builder stateReason(AssociationStateReason var1);

        default public Builder stateReason(Consumer<AssociationStateReason.Builder> stateReason) {
            return this.stateReason((AssociationStateReason)((AssociationStateReason.Builder)AssociationStateReason.builder().applyMutation(stateReason)).build());
        }

        public Builder workspaceId(String var1);
    }
}

