/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.StopRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, StopWorkspacesRequest> {
    private static final SdkField<List<StopRequest>> STOP_WORKSPACE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StopWorkspaceRequests").getter(StopWorkspacesRequest.getter(StopWorkspacesRequest::stopWorkspaceRequests)).setter(StopWorkspacesRequest.setter(Builder::stopWorkspaceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopWorkspaceRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StopRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOP_WORKSPACE_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StopWorkspacesRequest.memberNameToFieldInitializer();
    private final List<StopRequest> stopWorkspaceRequests;

    private StopWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.stopWorkspaceRequests = builder.stopWorkspaceRequests;
    }

    public final boolean hasStopWorkspaceRequests() {
        return this.stopWorkspaceRequests != null && !(this.stopWorkspaceRequests instanceof SdkAutoConstructList);
    }

    public final List<StopRequest> stopWorkspaceRequests() {
        return this.stopWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopWorkspaceRequests() ? this.stopWorkspaceRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopWorkspacesRequest)) {
            return false;
        }
        StopWorkspacesRequest other = (StopWorkspacesRequest)((Object)obj);
        return this.hasStopWorkspaceRequests() == other.hasStopWorkspaceRequests() && Objects.equals(this.stopWorkspaceRequests(), other.stopWorkspaceRequests());
    }

    public final String toString() {
        return ToString.builder((String)"StopWorkspacesRequest").add("StopWorkspaceRequests", this.hasStopWorkspaceRequests() ? this.stopWorkspaceRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StopWorkspaceRequests": {
                return Optional.ofNullable(clazz.cast(this.stopWorkspaceRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<StopRequest>>> map = new HashMap<String, SdkField<List<StopRequest>>>();
        map.put("StopWorkspaceRequests", STOP_WORKSPACE_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopWorkspacesRequest, T> g) {
        return obj -> g.apply((StopWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<StopRequest> stopWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopWorkspacesRequest model) {
            super(model);
            this.stopWorkspaceRequests(model.stopWorkspaceRequests);
        }

        public final List<StopRequest.Builder> getStopWorkspaceRequests() {
            List<StopRequest.Builder> result = StopWorkspaceRequestsCopier.copyToBuilder(this.stopWorkspaceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopWorkspaceRequests(Collection<StopRequest.BuilderImpl> stopWorkspaceRequests) {
            this.stopWorkspaceRequests = StopWorkspaceRequestsCopier.copyFromBuilder(stopWorkspaceRequests);
        }

        @Override
        public final Builder stopWorkspaceRequests(Collection<StopRequest> stopWorkspaceRequests) {
            this.stopWorkspaceRequests = StopWorkspaceRequestsCopier.copy(stopWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopWorkspaceRequests(StopRequest ... stopWorkspaceRequests) {
            this.stopWorkspaceRequests(Arrays.asList(stopWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopWorkspaceRequests(Consumer<StopRequest.Builder> ... stopWorkspaceRequests) {
            this.stopWorkspaceRequests(Stream.of(stopWorkspaceRequests).map(c -> (StopRequest)((StopRequest.Builder)StopRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopWorkspacesRequest build() {
            return new StopWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopWorkspacesRequest> {
        public Builder stopWorkspaceRequests(Collection<StopRequest> var1);

        public Builder stopWorkspaceRequests(StopRequest ... var1);

        public Builder stopWorkspaceRequests(Consumer<StopRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

