/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AGAModeForWorkSpaceEnum;
import software.amazon.awssdk.services.workspaces.model.AGAPreferredProtocolForWorkSpace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalAcceleratorForWorkSpace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalAcceleratorForWorkSpace> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(GlobalAcceleratorForWorkSpace.getter(GlobalAcceleratorForWorkSpace::modeAsString)).setter(GlobalAcceleratorForWorkSpace.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PREFERRED_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredProtocol").getter(GlobalAcceleratorForWorkSpace.getter(GlobalAcceleratorForWorkSpace::preferredProtocolAsString)).setter(GlobalAcceleratorForWorkSpace.setter(Builder::preferredProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredProtocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, PREFERRED_PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlobalAcceleratorForWorkSpace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String preferredProtocol;

    private GlobalAcceleratorForWorkSpace(BuilderImpl builder) {
        this.mode = builder.mode;
        this.preferredProtocol = builder.preferredProtocol;
    }

    public final AGAModeForWorkSpaceEnum mode() {
        return AGAModeForWorkSpaceEnum.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final AGAPreferredProtocolForWorkSpace preferredProtocol() {
        return AGAPreferredProtocolForWorkSpace.fromValue(this.preferredProtocol);
    }

    public final String preferredProtocolAsString() {
        return this.preferredProtocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredProtocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalAcceleratorForWorkSpace)) {
            return false;
        }
        GlobalAcceleratorForWorkSpace other = (GlobalAcceleratorForWorkSpace)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.preferredProtocolAsString(), other.preferredProtocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalAcceleratorForWorkSpace").add("Mode", (Object)this.modeAsString()).add("PreferredProtocol", (Object)this.preferredProtocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "PreferredProtocol": {
                return Optional.ofNullable(clazz.cast(this.preferredProtocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Mode", MODE_FIELD);
        map.put("PreferredProtocol", PREFERRED_PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalAcceleratorForWorkSpace, T> g) {
        return obj -> g.apply((GlobalAcceleratorForWorkSpace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String preferredProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalAcceleratorForWorkSpace model) {
            this.mode(model.mode);
            this.preferredProtocol(model.preferredProtocol);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AGAModeForWorkSpaceEnum mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPreferredProtocol() {
            return this.preferredProtocol;
        }

        public final void setPreferredProtocol(String preferredProtocol) {
            this.preferredProtocol = preferredProtocol;
        }

        @Override
        public final Builder preferredProtocol(String preferredProtocol) {
            this.preferredProtocol = preferredProtocol;
            return this;
        }

        @Override
        public final Builder preferredProtocol(AGAPreferredProtocolForWorkSpace preferredProtocol) {
            this.preferredProtocol(preferredProtocol == null ? null : preferredProtocol.toString());
            return this;
        }

        public GlobalAcceleratorForWorkSpace build() {
            return new GlobalAcceleratorForWorkSpace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalAcceleratorForWorkSpace> {
        public Builder mode(String var1);

        public Builder mode(AGAModeForWorkSpaceEnum var1);

        public Builder preferredProtocol(String var1);

        public Builder preferredProtocol(AGAPreferredProtocolForWorkSpace var1);
    }
}

