/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomImageProtocol {
    PCOIP("PCOIP"),
    DCV("DCV"),
    BYOP("BYOP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomImageProtocol> VALUE_MAP;
    private final String value;

    private CustomImageProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomImageProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomImageProtocol> knownValues() {
        EnumSet<CustomImageProtocol> knownValues = EnumSet.allOf(CustomImageProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomImageProtocol.class, CustomImageProtocol::toString);
    }
}

