/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.AccountLink;
import software.amazon.awssdk.services.workspaces.model.AccountLinkListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountLinksResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, ListAccountLinksResponse> {
    private static final SdkField<List<AccountLink>> ACCOUNT_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountLinks").getter(ListAccountLinksResponse.getter(ListAccountLinksResponse::accountLinks)).setter(ListAccountLinksResponse.setter(Builder::accountLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccountLinksResponse.getter(ListAccountLinksResponse::nextToken)).setter(ListAccountLinksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LINKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccountLink> accountLinks;
    private final String nextToken;

    private ListAccountLinksResponse(BuilderImpl builder) {
        super(builder);
        this.accountLinks = builder.accountLinks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountLinks() {
        return this.accountLinks != null && !(this.accountLinks instanceof SdkAutoConstructList);
    }

    public final List<AccountLink> accountLinks() {
        return this.accountLinks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountLinks() ? this.accountLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountLinksResponse)) {
            return false;
        }
        ListAccountLinksResponse other = (ListAccountLinksResponse)((Object)obj);
        return this.hasAccountLinks() == other.hasAccountLinks() && Objects.equals(this.accountLinks(), other.accountLinks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccountLinksResponse").add("AccountLinks", this.hasAccountLinks() ? this.accountLinks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountLinks": {
                return Optional.ofNullable(clazz.cast(this.accountLinks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountLinksResponse, T> g) {
        return obj -> g.apply((ListAccountLinksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<AccountLink> accountLinks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountLinksResponse model) {
            super(model);
            this.accountLinks(model.accountLinks);
            this.nextToken(model.nextToken);
        }

        public final List<AccountLink.Builder> getAccountLinks() {
            List<AccountLink.Builder> result = AccountLinkListCopier.copyToBuilder(this.accountLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountLinks(Collection<AccountLink.BuilderImpl> accountLinks) {
            this.accountLinks = AccountLinkListCopier.copyFromBuilder(accountLinks);
        }

        @Override
        public final Builder accountLinks(Collection<AccountLink> accountLinks) {
            this.accountLinks = AccountLinkListCopier.copy(accountLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLinks(AccountLink ... accountLinks) {
            this.accountLinks(Arrays.asList(accountLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLinks(Consumer<AccountLink.Builder> ... accountLinks) {
            this.accountLinks(Stream.of(accountLinks).map(c -> (AccountLink)((AccountLink.Builder)AccountLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccountLinksResponse build() {
            return new ListAccountLinksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountLinksResponse> {
        public Builder accountLinks(Collection<AccountLink> var1);

        public Builder accountLinks(AccountLink ... var1);

        public Builder accountLinks(Consumer<AccountLink.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

