/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolSession;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolSessionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesPoolSessionsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspacesPoolSessionsResponse> {
    private static final SdkField<List<WorkspacesPoolSession>> SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sessions").getter(DescribeWorkspacesPoolSessionsResponse.getter(DescribeWorkspacesPoolSessionsResponse::sessions)).setter(DescribeWorkspacesPoolSessionsResponse.setter(Builder::sessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspacesPoolSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesPoolSessionsResponse.getter(DescribeWorkspacesPoolSessionsResponse::nextToken)).setter(DescribeWorkspacesPoolSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkspacesPoolSession> sessions;
    private final String nextToken;

    private DescribeWorkspacesPoolSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSessions() {
        return this.sessions != null && !(this.sessions instanceof SdkAutoConstructList);
    }

    public final List<WorkspacesPoolSession> sessions() {
        return this.sessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessions() ? this.sessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesPoolSessionsResponse)) {
            return false;
        }
        DescribeWorkspacesPoolSessionsResponse other = (DescribeWorkspacesPoolSessionsResponse)((Object)obj);
        return this.hasSessions() == other.hasSessions() && Objects.equals(this.sessions(), other.sessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesPoolSessionsResponse").add("Sessions", this.hasSessions() ? this.sessions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sessions": {
                return Optional.ofNullable(clazz.cast(this.sessions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesPoolSessionsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesPoolSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspacesPoolSession> sessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesPoolSessionsResponse model) {
            super(model);
            this.sessions(model.sessions);
            this.nextToken(model.nextToken);
        }

        public final List<WorkspacesPoolSession.Builder> getSessions() {
            List<WorkspacesPoolSession.Builder> result = WorkspacesPoolSessionsCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<WorkspacesPoolSession.BuilderImpl> sessions) {
            this.sessions = WorkspacesPoolSessionsCopier.copyFromBuilder(sessions);
        }

        @Override
        public final Builder sessions(Collection<WorkspacesPoolSession> sessions) {
            this.sessions = WorkspacesPoolSessionsCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(WorkspacesPoolSession ... sessions) {
            this.sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<WorkspacesPoolSession.Builder> ... sessions) {
            this.sessions(Stream.of(sessions).map(c -> (WorkspacesPoolSession)((WorkspacesPoolSession.Builder)WorkspacesPoolSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspacesPoolSessionsResponse build() {
            return new DescribeWorkspacesPoolSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesPoolSessionsResponse> {
        public Builder sessions(Collection<WorkspacesPoolSession> var1);

        public Builder sessions(WorkspacesPoolSession ... var1);

        public Builder sessions(Consumer<WorkspacesPoolSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

