/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ConnectionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceConnectionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceConnectionStatus> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(WorkspaceConnectionStatus.getter(WorkspaceConnectionStatus::workspaceId)).setter(WorkspaceConnectionStatus.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionState").getter(WorkspaceConnectionStatus.getter(WorkspaceConnectionStatus::connectionStateAsString)).setter(WorkspaceConnectionStatus.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()}).build();
    private static final SdkField<Instant> CONNECTION_STATE_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConnectionStateCheckTimestamp").getter(WorkspaceConnectionStatus.getter(WorkspaceConnectionStatus::connectionStateCheckTimestamp)).setter(WorkspaceConnectionStatus.setter(Builder::connectionStateCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStateCheckTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_KNOWN_USER_CONNECTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastKnownUserConnectionTimestamp").getter(WorkspaceConnectionStatus.getter(WorkspaceConnectionStatus::lastKnownUserConnectionTimestamp)).setter(WorkspaceConnectionStatus.setter(Builder::lastKnownUserConnectionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastKnownUserConnectionTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, CONNECTION_STATE_FIELD, CONNECTION_STATE_CHECK_TIMESTAMP_FIELD, LAST_KNOWN_USER_CONNECTION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceConnectionStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workspaceId;
    private final String connectionState;
    private final Instant connectionStateCheckTimestamp;
    private final Instant lastKnownUserConnectionTimestamp;

    private WorkspaceConnectionStatus(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.connectionState = builder.connectionState;
        this.connectionStateCheckTimestamp = builder.connectionStateCheckTimestamp;
        this.lastKnownUserConnectionTimestamp = builder.lastKnownUserConnectionTimestamp;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public final Instant connectionStateCheckTimestamp() {
        return this.connectionStateCheckTimestamp;
    }

    public final Instant lastKnownUserConnectionTimestamp() {
        return this.lastKnownUserConnectionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastKnownUserConnectionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceConnectionStatus)) {
            return false;
        }
        WorkspaceConnectionStatus other = (WorkspaceConnectionStatus)obj;
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.connectionStateCheckTimestamp(), other.connectionStateCheckTimestamp()) && Objects.equals(this.lastKnownUserConnectionTimestamp(), other.lastKnownUserConnectionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceConnectionStatus").add("WorkspaceId", (Object)this.workspaceId()).add("ConnectionState", (Object)this.connectionStateAsString()).add("ConnectionStateCheckTimestamp", (Object)this.connectionStateCheckTimestamp()).add("LastKnownUserConnectionTimestamp", (Object)this.lastKnownUserConnectionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "ConnectionStateCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.connectionStateCheckTimestamp()));
            }
            case "LastKnownUserConnectionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastKnownUserConnectionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("ConnectionState", CONNECTION_STATE_FIELD);
        map.put("ConnectionStateCheckTimestamp", CONNECTION_STATE_CHECK_TIMESTAMP_FIELD);
        map.put("LastKnownUserConnectionTimestamp", LAST_KNOWN_USER_CONNECTION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceConnectionStatus, T> g) {
        return obj -> g.apply((WorkspaceConnectionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workspaceId;
        private String connectionState;
        private Instant connectionStateCheckTimestamp;
        private Instant lastKnownUserConnectionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceConnectionStatus model) {
            this.workspaceId(model.workspaceId);
            this.connectionState(model.connectionState);
            this.connectionStateCheckTimestamp(model.connectionStateCheckTimestamp);
            this.lastKnownUserConnectionTimestamp(model.lastKnownUserConnectionTimestamp);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final Instant getConnectionStateCheckTimestamp() {
            return this.connectionStateCheckTimestamp;
        }

        public final void setConnectionStateCheckTimestamp(Instant connectionStateCheckTimestamp) {
            this.connectionStateCheckTimestamp = connectionStateCheckTimestamp;
        }

        @Override
        public final Builder connectionStateCheckTimestamp(Instant connectionStateCheckTimestamp) {
            this.connectionStateCheckTimestamp = connectionStateCheckTimestamp;
            return this;
        }

        public final Instant getLastKnownUserConnectionTimestamp() {
            return this.lastKnownUserConnectionTimestamp;
        }

        public final void setLastKnownUserConnectionTimestamp(Instant lastKnownUserConnectionTimestamp) {
            this.lastKnownUserConnectionTimestamp = lastKnownUserConnectionTimestamp;
        }

        @Override
        public final Builder lastKnownUserConnectionTimestamp(Instant lastKnownUserConnectionTimestamp) {
            this.lastKnownUserConnectionTimestamp = lastKnownUserConnectionTimestamp;
            return this;
        }

        public WorkspaceConnectionStatus build() {
            return new WorkspaceConnectionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceConnectionStatus> {
        public Builder workspaceId(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionState var1);

        public Builder connectionStateCheckTimestamp(Instant var1);

        public Builder lastKnownUserConnectionTimestamp(Instant var1);
    }
}

